/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.liquibase.common.LiquibaseCommandManagerKt;
import com.intellij.liquibase.database.IdeaDataStore;
import com.intellij.liquibase.database.ext.intellij.das.DasToDbObjectsConverter;
import com.intellij.openapi.project.Project;
import com.intellij.re.DbSnapshotModel;
import com.intellij.re.UltimateDbSnapshotGenerator;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import liquibase.GlobalConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002J\u0014\u0010\u0016\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/re/UltimateDbSnapshotGeneratorImpl;", "Lcom/intellij/re/UltimateDbSnapshotGenerator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "loadModel", "Lcom/intellij/re/DbSnapshotModel;", "dataStore", "Lcom/intellij/jpa/jpb/model/core/model/AbstractRdbmsStore;", "getRealDataSource", "Lcom/intellij/database/dataSource/AbstractDataSource;", "Lcom/intellij/database/model/DasDataSource;", "filterDasObjectByDataStore", "", "dasObject", "Lcom/intellij/database/model/DasObject;", "schemaName", "", "dbName", "isSame", "intellij.javaee.reverseEngineering"})
public final class UltimateDbSnapshotGeneratorImpl
implements UltimateDbSnapshotGenerator {
    @NotNull
    private final Project project;

    public UltimateDbSnapshotGeneratorImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public DbSnapshotModel loadModel(@NotNull AbstractRdbmsStore dataStore) {
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)dataStore, (String)"dataStore");
            List list = DbPsiFacade.getInstance((Project)this.project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                DbDataSource it = (DbDataSource)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                AbstractDataSource abstractDataSource = this.getRealDataSource((DasDataSource)it);
                if (!(abstractDataSource != null ? this.isSame((DasDataSource)abstractDataSource, dataStore) : false)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        DbDataSource dbDataSource = v2;
        if (dbDataSource == null) {
            return DbSnapshotModel.Companion.getEMPTY_MODEL();
        }
        DbDataSource dbDataSource2 = dbDataSource;
        JBIterable jBIterable = DasToDbObjectsConverter.INSTANCE.getNonSystemTables((DasDataSource)dbDataSource2).filter(arg_0 -> UltimateDbSnapshotGeneratorImpl.loadModel$lambda$1(new Function1(this, dataStore){
            final /* synthetic */ UltimateDbSnapshotGeneratorImpl this$0;
            final /* synthetic */ AbstractRdbmsStore $dataStore;
            {
                this.this$0 = $receiver;
                this.$dataStore = $dataStore;
            }

            public final Boolean invoke(DasTable it) {
                Intrinsics.checkNotNull((Object)it);
                return UltimateDbSnapshotGeneratorImpl.access$filterDasObjectByDataStore(this.this$0, (DasObject)it, this.$dataStore);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        JBIterable dasTables2 = jBIterable;
        JBIterable jBIterable2 = DasToDbObjectsConverter.INSTANCE.getNonSystemSequences((DasDataSource)dbDataSource2).filter(arg_0 -> UltimateDbSnapshotGeneratorImpl.loadModel$lambda$2(new Function1(this, dataStore){
            final /* synthetic */ UltimateDbSnapshotGeneratorImpl this$0;
            final /* synthetic */ AbstractRdbmsStore $dataStore;
            {
                this.this$0 = $receiver;
                this.$dataStore = $dataStore;
            }

            public final Boolean invoke(BasicSequence it) {
                Intrinsics.checkNotNull((Object)it);
                return UltimateDbSnapshotGeneratorImpl.access$filterDasObjectByDataStore(this.this$0, (DasObject)it, this.$dataStore);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"filter(...)");
        JBIterable basicSequence2 = jBIterable2;
        return (DbSnapshotModel)LiquibaseCommandManagerKt.runWithPluginClassLoader(() -> UltimateDbSnapshotGeneratorImpl.loadModel$lambda$3(dasTables2, dataStore, basicSequence2));
    }

    private final AbstractDataSource getRealDataSource(DasDataSource $this$getRealDataSource) {
        if ($this$getRealDataSource instanceof AbstractDataSource) {
            return (AbstractDataSource)$this$getRealDataSource;
        }
        if ($this$getRealDataSource instanceof DbDataSource) {
            RawDataSource rawDataSource = ((DbDataSource)$this$getRealDataSource).getDelegate();
            return rawDataSource instanceof AbstractDataSource ? (AbstractDataSource)rawDataSource : null;
        }
        return null;
    }

    private final boolean filterDasObjectByDataStore(DasObject dasObject, AbstractRdbmsStore dataStore) {
        if (!(dataStore instanceof CustomDataStore)) {
            return true;
        }
        String schemaName = ((CustomDataStore)dataStore).getCustomSchemaName();
        String ideaDbName = ((CustomDataStore)dataStore).getIdeaDbName();
        return this.filterDasObjectByDataStore(dasObject, schemaName, ideaDbName);
    }

    private final boolean filterDasObjectByDataStore(DasObject dasObject, String schemaName, String dbName) {
        String string = DasUtil.getSchema((DasObject)dasObject);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSchema(...)");
        String objectSchemaName = string;
        CharSequence charSequence = schemaName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && !Intrinsics.areEqual((Object)schemaName, (Object)objectSchemaName)) {
            return false;
        }
        String string2 = DasUtil.getCatalog((DasObject)dasObject);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCatalog(...)");
        String objectCatalogName = string2;
        CharSequence charSequence2 = dbName;
        return charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2) || Intrinsics.areEqual((Object)dbName, (Object)objectCatalogName);
    }

    private final boolean isSame(DasDataSource $this$isSame, AbstractRdbmsStore dataStore) {
        return Intrinsics.areEqual((Object)$this$isSame.getUniqueId(), (Object)dataStore.getId()) || dataStore instanceof IdeaDataStore && Intrinsics.areEqual((Object)$this$isSame.getUniqueId(), (Object)((IdeaDataStore)dataStore).getDsUniqueId());
    }

    private static final boolean loadModel$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean loadModel$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final DbSnapshotModel loadModel$lambda$3(JBIterable $dasTables, AbstractRdbmsStore $dataStore, JBIterable $basicSequence) {
        GlobalConfiguration.INCLUDE_CATALOG_IN_SPECIFICATION.getCurrentValue();
        DbType dbType = $dataStore.getDbProperties().getType();
        Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
        return new DbSnapshotModel(DasToDbObjectsConverter.INSTANCE.createRelations($dasTables, dbType, null), DasToDbObjectsConverter.INSTANCE.createSequences($basicSequence));
    }

    public static final /* synthetic */ boolean access$filterDasObjectByDataStore(UltimateDbSnapshotGeneratorImpl $this, DasObject dasObject, AbstractRdbmsStore dataStore) {
        return $this.filterDasObjectByDataStore(dasObject, dataStore);
    }
}

