/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.exposed;

import com.intellij.jpa.jpb.model.core.util.Fqn;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.orm.ep.OrmEntityWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.re.exposed.orm.AbstractExposedOrmProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J4\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/re/exposed/ExposedOrmEntityWriter;", "Lcom/intellij/re/exposed/orm/AbstractExposedOrmProvider;", "Lcom/intellij/jpa/jpb/model/orm/ep/OrmEntityWriter;", "<init>", "()V", "createDatatypeObjects", "", "newAttributeModels", "", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "entityModels", "Lcom/intellij/jpa/jpb/model/model/EntityModel;", "targetDirectory", "Lcom/intellij/psi/PsiDirectory;", "language", "Lcom/intellij/jpa/jpb/model/model/SourceLanguage;", "createEntity", "Lcom/intellij/psi/PsiFile;", "entityModel", "addAttributes", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "entityClass", "Lcom/intellij/psi/PsiClass;", "attributes", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "createTableClass", "createAttributeText", "", "entityAttribute", "intellij.javaee.reverseEngineering.exposed"})
@SourceDebugExtension(value={"SMAP\nExposedOrmEntityWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExposedOrmEntityWriter.kt\ncom/intellij/re/exposed/ExposedOrmEntityWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n*S KotlinDebug\n*F\n+ 1 ExposedOrmEntityWriter.kt\ncom/intellij/re/exposed/ExposedOrmEntityWriter\n*L\n55#1:111\n55#1:112,2\n*E\n"})
public final class ExposedOrmEntityWriter
extends AbstractExposedOrmProvider
implements OrmEntityWriter {
    public void createDatatypeObjects(@NotNull List<? extends EntityAttributeModel> newAttributeModels, @NotNull List<? extends EntityModel> entityModels, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage language) {
        Intrinsics.checkNotNullParameter(newAttributeModels, (String)"newAttributeModels");
        Intrinsics.checkNotNullParameter(entityModels, (String)"entityModels");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
    }

    @NotNull
    public List<PsiFile> createEntity(@NotNull EntityModel entityModel, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage language) {
        Intrinsics.checkNotNullParameter((Object)entityModel, (String)"entityModel");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return CollectionsKt.listOf((Object)this.createTableClass(entityModel, targetDirectory));
    }

    public void addAttributes(@NotNull Entity entity, @NotNull PsiClass entityClass, @NotNull List<? extends EntityAttribute> attributes) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
    }

    /*
     * WARNING - void declaration
     */
    private final PsiFile createTableClass(EntityModel entityModel, PsiDirectory targetDirectory) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String string = Strings.pluralize((String)entityModel.getClassName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pluralize(...)");
        String tableClassName = string;
        Datatype datatype = entityModel.getIdAttribute().getType();
        Fqn parentFqn = Fqn.Companion.ofFullName(Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Long) ? "org.jetbrains.exposed.dao.id.LongIdTable" : (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Integer) ? "org.jetbrains.exposed.dao.id.IntIdTable" : (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.UUID) ? "org.jetbrains.exposed.dao.id.UUIDTable" : "org.jetbrains.exposed.sql.Table")));
        String idColumn = Intrinsics.areEqual((Object)parentFqn.getClassName(), (Object)"Table") ? "" : ", \"" + entityModel.getIdAttribute().getName() + "\"";
        String pkText = ((CharSequence)idColumn).length() == 0 ? "\n    override val primaryKey = PrimaryKey(" + entityModel.getIdAttribute().getName() + ")" : "";
        String string2 = entityModel.getPackageName();
        String string3 = parentFqn.getExternalFullName();
        String string4 = parentFqn.getClassName();
        String string5 = entityModel.getTable();
        List list = entityModel.getAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributes(...)");
        Iterable iterable = list;
        String string6 = idColumn;
        String string7 = string5;
        String string8 = string4;
        String string9 = tableClassName;
        String string10 = string3;
        String string11 = string2;
        boolean $i$f$filter = false;
        void var10_15 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EntityAttribute it = (EntityAttribute)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)idColumn).length() == 0 || !it.isId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        String classText = StringsKt.trimIndent((String)("\npackage " + string11 + "\n\nimport " + string10 + "\n\nobject " + string9 + ": " + string8 + "(\"" + string7 + "\"" + string6 + ") {\n    " + CollectionsKt.joinToString$default((Iterable)list2, (CharSequence)"\n    ", null, null, (int)0, null, arg_0 -> ExposedOrmEntityWriter.createTableClass$lambda$1(this, arg_0), (int)30, null) + "\n    " + pkText + "\n}\n    "));
        Project project = targetDirectory.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiFile psiFile = new KtPsiFactory(project, false).createFile(tableClassName + ".kt", classText).getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        PsiFile file = psiFile;
        PsiElement psiElement = targetDirectory.add((PsiElement)file);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
        return (PsiFile)psiElement;
    }

    private final String createAttributeText(EntityAttribute entityAttribute) {
        Pair[] pairArray;
        Pair pair;
        if (entityAttribute.getMappingType() == EntityAttribute.MappingType.ASSOCIATION) {
            String string = entityAttribute.getName();
            Set set = entityAttribute.getJoinColumns().keySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
            return "val " + string + " = reference(\"" + CollectionsKt.firstOrNull((Iterable)set) + "\", " + Strings.pluralize((String)entityAttribute.getType().getClassName()) + ")";
        }
        Datatype datatype = entityAttribute.getType();
        if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.UUID)) {
            pair = TuplesKt.to((Object)"uuid", (Object)MapsKt.emptyMap());
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.String)) {
            pair = TuplesKt.to((Object)"varchar", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"length", (Object)entityAttribute.getLength())));
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Boolean)) {
            pair = TuplesKt.to((Object)"bool", (Object)MapsKt.emptyMap());
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Integer)) {
            pair = TuplesKt.to((Object)"integer", (Object)MapsKt.emptyMap());
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Long)) {
            pair = TuplesKt.to((Object)"long", (Object)MapsKt.emptyMap());
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Double)) {
            pair = TuplesKt.to((Object)"double", (Object)MapsKt.emptyMap());
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Float)) {
            pair = TuplesKt.to((Object)"float", (Object)MapsKt.emptyMap());
        } else if (Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.BigDecimal)) {
            pairArray = new Pair[]{TuplesKt.to((Object)"scale", (Object)String.valueOf(entityAttribute.getScale())), TuplesKt.to((Object)"precision", (Object)String.valueOf(entityAttribute.getPrecision()))};
            pair = TuplesKt.to((Object)"decimal", (Object)MapsKt.mapOf((Pair[])pairArray));
        } else {
            pair = Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.Date) || Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.LocalDate) || Intrinsics.areEqual((Object)datatype, (Object)Datatypes.BasicDatatype.LocalDateTime) ? TuplesKt.to((Object)"datetimeValue", (Object)MapsKt.emptyMap()) : TuplesKt.to((Object)"column", (Object)MapsKt.emptyMap());
        }
        Pair function = pair;
        String text = "val " + entityAttribute.getName() + " = " + function.getFirst() + "(\"" + entityAttribute.getColumn() + "\"";
        text = ((Map)function.getSecond()).isEmpty() ? text + ")" : text + CollectionsKt.joinToString$default((Iterable)((Map)function.getSecond()).entrySet(), (CharSequence)", ", (CharSequence)", ", (CharSequence)")", (int)0, null, ExposedOrmEntityWriter::createAttributeText$lambda$2, (int)24, null);
        if (entityAttribute.isId()) {
            pairArray = (Pair[])entityAttribute.getSequenceOrTableGeneratorName();
            text = !(pairArray == null || pairArray.length() == 0) ? text + ".autoIncrement(" + entityAttribute.getSequenceOrTableGeneratorName() + ")" : text + ".autoIncrement()";
        }
        if (entityAttribute.isUnique()) {
            text = text + ".uniqueIndex()";
        }
        return text;
    }

    private static final CharSequence createTableClass$lambda$1(ExposedOrmEntityWriter this$0, EntityAttribute it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.createAttributeText(it);
    }

    private static final CharSequence createAttributeText$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getKey() + " = " + it.getValue();
    }
}

