/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui.bulk;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.ui.util.HColor;
import com.intellij.re.ui.AttrMappingType;
import com.intellij.re.ui.DbColumnNodesStore;
import com.intellij.re.ui.DbColumnTreeNode;
import com.intellij.re.ui.bulk.EntityRelationTree;
import com.intellij.re.ui.bulk.RelationNode;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import liquibase.structure.core.View;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006JD\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0016H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/re/ui/bulk/EntityRelationTreeCellRender;", "Lcom/intellij/ui/CheckboxTree$CheckboxTreeCellRenderer;", "filterSupplier", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "customizeRenderer", "", "tree", "Ljavax/swing/JTree;", "node", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "getRelationNodePresentation", "Lcom/intellij/re/ui/bulk/EntityRelationTreeCellRender$NodePresentation;", "Lcom/intellij/re/ui/bulk/RelationNode;", "NodePresentation", "intellij.javaee.reverseEngineering"})
public final class EntityRelationTreeCellRender
extends CheckboxTree.CheckboxTreeCellRenderer {
    @NotNull
    private final Function0<String> filterSupplier;

    public EntityRelationTreeCellRender(@NotNull Function0<String> filterSupplier) {
        Intrinsics.checkNotNullParameter(filterSupplier, (String)"filterSupplier");
        this.filterSupplier = filterSupplier;
    }

    public void customizeRenderer(@Nullable JTree tree, @Nullable Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (node instanceof RelationNode) {
            String text = ((RelationNode)((Object)node)).getRelation().getName();
            Color color = UIUtil.getTreeBackground((boolean)selected, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTreeBackground(...)");
            Color background = color;
            UIUtil.changeBackGround((Component)((Component)((Object)this)), (Color)background);
            NodePresentation presentation = this.getRelationNodePresentation((RelationNode)((Object)node));
            SimpleTextAttributes attributes = presentation.getSimpleTextAttributes();
            String string = (String)this.filterSupplier.invoke();
            int n = attributes.getStyle();
            Color color2 = attributes.getFgColor();
            ColoredTreeCellRenderer coloredTreeCellRenderer = this.getTextRenderer();
            Intrinsics.checkNotNullExpressionValue((Object)coloredTreeCellRenderer, (String)"getTextRenderer(...)");
            SearchUtil.appendFragments((String)string, (String)text, (int)n, (Color)color2, (Color)background, (SimpleColoredComponent)((SimpleColoredComponent)coloredTreeCellRenderer));
            this.setToolTipText(presentation.getToolTipText());
        } else if (node instanceof DefaultMutableTreeNode) {
            ColoredTreeCellRenderer coloredTreeCellRenderer = this.getTextRenderer();
            Object object = ((DefaultMutableTreeNode)node).getUserObject();
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            coloredTreeCellRenderer.append((String)object, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            if (tree instanceof EntityRelationTree) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                this.getTextRenderer().setIcon(Intrinsics.areEqual((Object)(defaultMutableTreeNode = (DefaultMutableTreeNode)node), (Object)((Object)((EntityRelationTree)((Object)tree)).getTablesNode())) ? AllIcons.Nodes.DataTables : (Intrinsics.areEqual((Object)defaultMutableTreeNode, (Object)((Object)((EntityRelationTree)((Object)tree)).getViewsNode())) ? AllIcons.Nodes.DataSchema : null));
            }
        }
    }

    private final NodePresentation getRelationNodePresentation(RelationNode node) {
        if (!node.isChecked()) {
            return new NodePresentation(null, null, 3, null);
        }
        if (node.getRelation() instanceof View && node.getIdColumns().isEmpty()) {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"ERROR_ATTRIBUTES");
            return new NodePresentation(simpleTextAttributes, JpaModelBundle.message((String)"db.view.without.id.columns", (Object[])new Object[0]));
        }
        DbColumnNodesStore columnNodesStore2 = node.getColumnNodesStore();
        if (columnNodesStore2 != null) {
            String unmappedColumnWarning;
            block7: {
                String string;
                for (DbColumnTreeNode it : (Iterable)columnNodesStore2.getNewColumnNodes()) {
                    String string2;
                    String string3;
                    boolean bl = false;
                    if (it.getAttrMappingType() != AttrMappingType.Todo) {
                        string3 = null;
                    } else {
                        Object v = it.getAttribute().getAdditionalProperties().get("unmappedColumn");
                        string3 = v != null ? v.toString() : null;
                    }
                    if ((string2 = string3) == null) continue;
                    string = string2;
                    break block7;
                }
                string = unmappedColumnWarning = null;
            }
            if (unmappedColumnWarning != null) {
                return new NodePresentation(new SimpleTextAttributes(0, HColor.YELLOW), unmappedColumnWarning);
            }
        }
        return new NodePresentation(null, null, 3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/re/ui/bulk/EntityRelationTreeCellRender$NodePresentation;", "", "simpleTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "toolTipText", "", "<init>", "(Lcom/intellij/ui/SimpleTextAttributes;Ljava/lang/String;)V", "getSimpleTextAttributes", "()Lcom/intellij/ui/SimpleTextAttributes;", "getToolTipText", "()Ljava/lang/String;", "intellij.javaee.reverseEngineering"})
    private static final class NodePresentation {
        @NotNull
        private final SimpleTextAttributes simpleTextAttributes;
        @Nullable
        private final String toolTipText;

        public NodePresentation(@NotNull SimpleTextAttributes simpleTextAttributes, @Nls @Nullable String toolTipText) {
            Intrinsics.checkNotNullParameter((Object)simpleTextAttributes, (String)"simpleTextAttributes");
            this.simpleTextAttributes = simpleTextAttributes;
            this.toolTipText = toolTipText;
        }

        public /* synthetic */ NodePresentation(SimpleTextAttributes simpleTextAttributes, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            }
            if ((n & 2) != 0) {
                string = null;
            }
            this(simpleTextAttributes, string);
        }

        @NotNull
        public final SimpleTextAttributes getSimpleTextAttributes() {
            return this.simpleTextAttributes;
        }

        @Nullable
        public final String getToolTipText() {
            return this.toolTipText;
        }

        public NodePresentation() {
            this(null, null, 3, null);
        }
    }
}

