/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui.settings;

import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.re.msg.ReBundle;
import com.intellij.re.ui.settings.EntityNameTemplate;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\b\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable;", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "<init>", "()V", "initTemplateStrValues", "", "", "saveState", "", "state", "Lcom/intellij/jpa/jpb/model/config/ProjectState;", "loadFromState", "parseEntityTemplate", "templateName", "value", "isModified", "", "CaseColumnInfo", "PluralizeColumnInfo", "UnderscoreColumnInfo", "PostfixColumnInfo", "PrefixColumnInfo", "NameColumnInfo", "SelectedColumnInfo", "Companion", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nNameTemplatesTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameTemplatesTable.kt\ncom/intellij/re/ui/settings/NameTemplatesTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1202#2,2:243\n1230#2,4:245\n1755#2,3:249\n*S KotlinDebug\n*F\n+ 1 NameTemplatesTable.kt\ncom/intellij/re/ui/settings/NameTemplatesTable\n*L\n39#1:243,2\n39#1:245,4\n69#1:249,3\n*E\n"})
public final class NameTemplatesTable
extends TableView<EntityNameTemplate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> initTemplateStrValues = new LinkedHashMap();
    @NotNull
    public static final String ENTITY_COLUMN_NAME = "Entity";
    @NotNull
    public static final String TABLE_COLUMN_NAME = "Table";
    @NotNull
    public static final String COLUMN_COLUMN_NAME = "Column";

    public NameTemplatesTable() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new SelectedColumnInfo(), new NameColumnInfo(), new CaseColumnInfo(), new PrefixColumnInfo(), new PostfixColumnInfo(), new UnderscoreColumnInfo(), new PluralizeColumnInfo()};
        this.setModelAndUpdateColumns(new ListTableModel(columnInfoArray));
        this.setSelectionMode(0);
        this.autoResizeMode = 3;
        this.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)-1));
        this.setVisibleRowCount(7);
        this.rowHeight = JBUI.scale((int)32);
    }

    /*
     * WARNING - void declaration
     */
    public final void saveState(@NotNull ProjectState state) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List list = this.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        Iterable $this$associateBy$iv = list;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            EntityNameTemplate entityNameTemplate = (EntityNameTemplate)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getName(), element$iv$iv);
        }
        Map templates = destination$iv$iv;
        Object v = templates.get(TABLE_COLUMN_NAME);
        Intrinsics.checkNotNull(v);
        state.tableNameTemplate = ((EntityNameTemplate)v).convertToString();
        Object v2 = templates.get(COLUMN_COLUMN_NAME);
        Intrinsics.checkNotNull(v2);
        state.columnNameTemplate = ((EntityNameTemplate)v2).convertToString();
        Object v3 = templates.get(ENTITY_COLUMN_NAME);
        Intrinsics.checkNotNull(v3);
        state.entityNameTemplate = ((EntityNameTemplate)v3).convertToString();
    }

    public final void loadFromState(@NotNull ProjectState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.initTemplateStrValues.clear();
        List initTemplates = new ArrayList();
        initTemplates.add(this.parseEntityTemplate(TABLE_COLUMN_NAME, state.tableNameTemplate));
        initTemplates.add(this.parseEntityTemplate(COLUMN_COLUMN_NAME, state.columnNameTemplate));
        initTemplates.add(this.parseEntityTemplate(ENTITY_COLUMN_NAME, state.entityNameTemplate));
        this.getListTableModel().setItems(initTemplates);
    }

    private final EntityNameTemplate parseEntityTemplate(String templateName, String value) {
        EntityNameTemplate entityNameTemplate;
        EntityNameTemplate it = entityNameTemplate = EntityNameTemplate.Companion.parse(templateName, value);
        boolean bl = false;
        this.initTemplateStrValues.put(templateName, it.convertToString());
        return entityNameTemplate;
    }

    public final boolean isModified() {
        boolean bl;
        block4: {
            List list = this.getListTableModel().getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            List currTemplates = list;
            if (currTemplates.size() != this.initTemplateStrValues.size()) {
                return true;
            }
            Iterable $this$any$iv = currTemplates;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String currValue;
                    EntityNameTemplate currTemplate = (EntityNameTemplate)element$iv;
                    boolean bl2 = false;
                    String initValue = this.initTemplateStrValues.get(currTemplate.getName());
                    if (!(!Intrinsics.areEqual((Object)initValue, (Object)(currValue = currTemplate.convertToString())))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$CaseColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "Lcom/intellij/re/ui/settings/EntityNameTemplate$NameCase;", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "getEditor", "Ljavax/swing/table/TableCellEditor;", "intellij.javaee.reverseEngineering"})
    public static final class CaseColumnInfo
    extends ColumnInfo<EntityNameTemplate, EntityNameTemplate.NameCase> {
        public CaseColumnInfo() {
            super(ReBundle.message("column.name.case", new Object[0]));
        }

        @Nullable
        public EntityNameTemplate.NameCase valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.getNameCase() : null;
        }

        public boolean isCellEditable(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? Intrinsics.areEqual((Object)entityNameTemplate.isSelected(), (Object)true) : false;
        }

        public void setValue(@Nullable EntityNameTemplate item, @Nullable EntityNameTemplate.NameCase value) {
            block0: {
                EntityNameTemplate entityNameTemplate = item;
                if (entityNameTemplate == null) break block0;
                entityNameTemplate.setNameCase(value);
            }
        }

        @Nullable
        public TableCellEditor getEditor(@Nullable EntityNameTemplate item) {
            return (TableCellEditor)ComboBoxTableCellEditor.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$Companion;", "", "<init>", "()V", "ENTITY_COLUMN_NAME", "", "TABLE_COLUMN_NAME", "COLUMN_COLUMN_NAME", "intellij.javaee.reverseEngineering"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$NameColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "", "<init>", "()V", "valueOf", "item", "intellij.javaee.reverseEngineering"})
    public static final class NameColumnInfo
    extends ColumnInfo<EntityNameTemplate, String> {
        public NameColumnInfo() {
            super(ReBundle.message("column.name.target", new Object[0]));
        }

        @Nullable
        public String valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.getName() : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J!\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$PluralizeColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "", "<init>", "()V", "valueOf", "item", "(Lcom/intellij/re/ui/settings/EntityNameTemplate;)Ljava/lang/Boolean;", "isCellEditable", "setValue", "", "value", "(Lcom/intellij/re/ui/settings/EntityNameTemplate;Ljava/lang/Boolean;)V", "getColumnClass", "Ljava/lang/Class;", "intellij.javaee.reverseEngineering"})
    public static final class PluralizeColumnInfo
    extends ColumnInfo<EntityNameTemplate, Boolean> {
        public PluralizeColumnInfo() {
            super(ReBundle.message("column.name.pluralize", new Object[0]));
        }

        @Nullable
        public Boolean valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.isPluralize() : null;
        }

        public boolean isCellEditable(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return (entityNameTemplate != null ? Intrinsics.areEqual((Object)entityNameTemplate.isSelected(), (Object)true) : false) && Intrinsics.areEqual((Object)item.getName(), (Object)NameTemplatesTable.TABLE_COLUMN_NAME);
        }

        public void setValue(@Nullable EntityNameTemplate item, @Nullable Boolean value) {
            block0: {
                EntityNameTemplate entityNameTemplate = item;
                if (entityNameTemplate == null) break block0;
                entityNameTemplate.setPluralize(value);
            }
        }

        @NotNull
        public Class<?> getColumnClass() {
            return Boolean.TYPE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$PostfixColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "intellij.javaee.reverseEngineering"})
    public static final class PostfixColumnInfo
    extends ColumnInfo<EntityNameTemplate, String> {
        public PostfixColumnInfo() {
            super(ReBundle.message("column.name.postfix", new Object[0]));
        }

        @Nullable
        public String valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.getPostfix() : null;
        }

        public boolean isCellEditable(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? Intrinsics.areEqual((Object)entityNameTemplate.isSelected(), (Object)true) : false;
        }

        public void setValue(@Nullable EntityNameTemplate item, @Nullable String value) {
            block0: {
                EntityNameTemplate entityNameTemplate = item;
                if (entityNameTemplate == null) break block0;
                entityNameTemplate.setPostfix(value);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$PrefixColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "intellij.javaee.reverseEngineering"})
    public static final class PrefixColumnInfo
    extends ColumnInfo<EntityNameTemplate, String> {
        public PrefixColumnInfo() {
            super(ReBundle.message("column.name.prefix", new Object[0]));
        }

        @Nullable
        public String valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.getPrefix() : null;
        }

        public boolean isCellEditable(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? Intrinsics.areEqual((Object)entityNameTemplate.isSelected(), (Object)true) : false;
        }

        public void setValue(@Nullable EntityNameTemplate item, @Nullable String value) {
            block0: {
                EntityNameTemplate entityNameTemplate = item;
                if (entityNameTemplate == null) break block0;
                entityNameTemplate.setPrefix(value);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J!\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$SelectedColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "", "<init>", "()V", "valueOf", "item", "(Lcom/intellij/re/ui/settings/EntityNameTemplate;)Ljava/lang/Boolean;", "isCellEditable", "setValue", "", "value", "(Lcom/intellij/re/ui/settings/EntityNameTemplate;Ljava/lang/Boolean;)V", "getColumnClass", "Ljava/lang/Class;", "getWidth", "", "table", "Ljavax/swing/JTable;", "intellij.javaee.reverseEngineering"})
    public static final class SelectedColumnInfo
    extends ColumnInfo<EntityNameTemplate, Boolean> {
        public SelectedColumnInfo() {
            super("");
        }

        @Nullable
        public Boolean valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.isSelected() : null;
        }

        public boolean isCellEditable(@Nullable EntityNameTemplate item) {
            return true;
        }

        public void setValue(@Nullable EntityNameTemplate item, @Nullable Boolean value) {
            block0: {
                EntityNameTemplate entityNameTemplate = item;
                if (entityNameTemplate == null) break block0;
                entityNameTemplate.setSelected(value);
            }
        }

        @NotNull
        public Class<?> getColumnClass() {
            return Boolean.TYPE;
        }

        public int getWidth(@Nullable JTable table) {
            return 30;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016J!\u0010\n\u001a\u00020\u000b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\f\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/re/ui/settings/NameTemplatesTable$UnderscoreColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/re/ui/settings/EntityNameTemplate;", "", "<init>", "()V", "valueOf", "item", "(Lcom/intellij/re/ui/settings/EntityNameTemplate;)Ljava/lang/Boolean;", "isCellEditable", "setValue", "", "value", "(Lcom/intellij/re/ui/settings/EntityNameTemplate;Ljava/lang/Boolean;)V", "getColumnClass", "Ljava/lang/Class;", "intellij.javaee.reverseEngineering"})
    public static final class UnderscoreColumnInfo
    extends ColumnInfo<EntityNameTemplate, Boolean> {
        public UnderscoreColumnInfo() {
            super(ReBundle.message("column.name.underscore", new Object[0]));
        }

        @Nullable
        public Boolean valueOf(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? entityNameTemplate.isUnderscore() : null;
        }

        public boolean isCellEditable(@Nullable EntityNameTemplate item) {
            EntityNameTemplate entityNameTemplate = item;
            return entityNameTemplate != null ? Intrinsics.areEqual((Object)entityNameTemplate.isSelected(), (Object)true) : false;
        }

        public void setValue(@Nullable EntityNameTemplate item, @Nullable Boolean value) {
            block0: {
                EntityNameTemplate entityNameTemplate = item;
                if (entityNameTemplate == null) break block0;
                entityNameTemplate.setUnderscore(value);
            }
        }

        @NotNull
        public Class<?> getColumnClass() {
            return Boolean.TYPE;
        }
    }
}

