/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity;

import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.velocity.psi.VtlImplicitVariable;
import com.intellij.velocity.psi.VtlPsiUtil;
import com.intellij.velocity.psi.files.VtlFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VtlReferenceContributor
extends PsiReferenceContributor {
    static boolean isSpecialComment(PsiComment comment) {
        return Holder.VTL_VARIABLE_COMMENT.accepts((Object)comment) || Holder.VTL_MACRO_LIBRARY_COMMENT.accepts((Object)comment) || Holder.VELOCITY_PROPERTIES_COMMENT.accepts((Object)comment);
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            VtlReferenceContributor.$$$reportNull$$$0(0);
        }
        VtlReferenceContributor.registerImplicitVariableProvider(registrar);
        VtlReferenceContributor.registerExternalMacroLibraryProvider(registrar);
        VtlReferenceContributor.registerVelocityPropertiesProvider(registrar);
    }

    private static void registerImplicitVariableProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(Holder.VTL_VARIABLE_COMMENT, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                String text;
                TextRange range;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((range = VtlPsiUtil.findRange(text = element.getText(), "name=\"", "\"")) == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                String name = range.substring(text);
                TextRange filePathRange = VtlPsiUtil.findRange(text, "file=\"", "\"");
                String scopeFilePath = filePathRange == null ? null : filePathRange.substring(text);
                final VtlImplicitVariable variable = ((VtlFile)element.getContainingFile()).findImplicitVariable(name, scopeFilePath);
                if (variable == null) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReferenceBase<PsiComment> ref = new PsiReferenceBase<PsiComment>((PsiComment)element, TextRange.from((int)range.getStartOffset(), (int)name.length())){

                    public PsiElement resolve() {
                        return variable;
                    }
                };
                SmartList result = new SmartList();
                result.add(ref);
                VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection<PsiReference>)result);
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(4);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static void registerExternalMacroLibraryProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(Holder.VTL_MACRO_LIBRARY_COMMENT, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                SmartList result;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (VtlReferenceContributor.findAndAddReferencesByElement(element, "path=\"", "\"", (Collection<PsiReference>)(result = new SmartList()))) {
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection<PsiReference>)result);
                }
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static void registerVelocityPropertiesProvider(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider(Holder.VELOCITY_PROPERTIES_COMMENT, new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                SmartList result;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (VtlReferenceContributor.findAndAddReferencesByElement(element, "path=\"", "\"", (Collection<PsiReference>)(result = new SmartList()))) {
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "runtime_root=\"", "\"", (Collection<PsiReference>)result);
                    VtlReferenceContributor.findAndAddReferencesByElement(element, "file=\"", "\"", (Collection<PsiReference>)result);
                }
                PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
                if (psiReferenceArray == null) {
                    3.$$$reportNull$$$0(2);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/velocity/VtlReferenceContributor$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static boolean findAndAddReferencesByElement(@NotNull PsiElement element, @NotNull String startMarker, @NotNull String endMarker, @NotNull Collection<PsiReference> collection) {
        String text;
        TextRange range;
        if (element == null) {
            VtlReferenceContributor.$$$reportNull$$$0(1);
        }
        if (startMarker == null) {
            VtlReferenceContributor.$$$reportNull$$$0(2);
        }
        if (endMarker == null) {
            VtlReferenceContributor.$$$reportNull$$$0(3);
        }
        if (collection == null) {
            VtlReferenceContributor.$$$reportNull$$$0(4);
        }
        if ((range = VtlPsiUtil.findRange(text = element.getText(), startMarker, endMarker)) == null) {
            return false;
        }
        String filePath = range.substring(text);
        FileReference[] fileReferences = VtlPsiUtil.getFileReferences(filePath, element, range.getStartOffset(), false);
        return collection.addAll(Arrays.asList(fileReferences));
    }

    @Nullable
    public static TextRange findTypeNameRange(@NotNull String text) {
        if (text == null) {
            VtlReferenceContributor.$$$reportNull$$$0(5);
        }
        return VtlPsiUtil.findRange(text, "type=\"", "\"");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startMarker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endMarker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/VtlReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndAddReferencesByElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeNameRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Holder {
        public static final PsiElementPattern.Capture<PsiComment> VTL_VARIABLE_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@vtlvariable "));
        private static final PsiElementPattern.Capture<PsiComment> VTL_MACRO_LIBRARY_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@vtlmacrolibrary "));
        private static final PsiElementPattern.Capture<PsiComment> VELOCITY_PROPERTIES_COMMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiComment.class).inFile((ElementPattern)PlatformPatterns.psiElement(VtlFile.class))).withText((ElementPattern)StandardPatterns.string().contains("@velocityproperties "));
    }
}

