/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.inspections.DefineInCommentIntention;
import com.intellij.velocity.inspections.Util;
import com.intellij.velocity.psi.directives.VtlMacroCall;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class DefineVelocityPropertiesRefIntention
extends DefineInCommentIntention {
    public DefineVelocityPropertiesRefIntention(@NotNull @IntentionName String text) {
        if (text == null) {
            DefineVelocityPropertiesRefIntention.$$$reportNull$$$0(0);
        }
        super(text, VelocityBundle.message("add.velocity.properties.ref.fix.name", new Object[0]));
    }

    @Override
    protected boolean isAvailable(@NotNull VtlReferenceExpression ref) {
        if (ref == null) {
            DefineVelocityPropertiesRefIntention.$$$reportNull$$$0(1);
        }
        return ref.getParent() instanceof VtlMacroCall;
    }

    @Override
    protected void prepareTemplate(@NotNull Template template, @NotNull PsiElement element, String relativePath, @NotNull PsiFile fileToInsertComment) {
        if (template == null) {
            DefineVelocityPropertiesRefIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            DefineVelocityPropertiesRefIntention.$$$reportNull$$$0(3);
        }
        if (fileToInsertComment == null) {
            DefineVelocityPropertiesRefIntention.$$$reportNull$$$0(4);
        }
        List allFiles = Util.collectFilePaths(element, psiFile -> {
            PsiFile file = psiFile.getViewProvider().getPsi((Language)PropertiesLanguage.INSTANCE);
            if (!(file instanceof PropertiesFile)) {
                return null;
            }
            VelocityPropertiesProvider propertiesProvider = new VelocityPropertiesProvider((PropertiesFile)file);
            List<PsiFile> macroLibs = DefineVelocityPropertiesRefIntention.collectReferencedLibFiles(ModuleUtilCore.findModuleForPsiElement((PsiElement)element), propertiesProvider);
            for (PsiFile macroLib : macroLibs) {
                VirtualFile vFile;
                String res;
                if (!(macroLib instanceof VtlFile) || ((VtlFile)macroLib).getNumberOfMacros(((VtlReferenceExpression)element).getReferenceName()) <= 0 || (res = Util.computeFilePath(propertiesProvider, (vFile = macroLib.getViewProvider().getVirtualFile()).getPath(), vFile.getName(), fileToInsertComment)) == null) continue;
                return res;
            }
            return null;
        });
        template.addTextSegment("#* @velocityproperties path=");
        ConstantNode pathExpression = new ConstantNode((String)ContainerUtil.getOnlyItem(allFiles)).withLookupStrings(allFiles);
        template.addVariable("PATH", (Expression)pathExpression, (Expression)pathExpression, true);
        Object fileRef = relativePath != null ? " file=\"" + relativePath + "\"" : "";
        template.addTextSegment((String)fileRef + " *#\n");
        template.addEndVariable();
    }

    private static List<PsiFile> collectReferencedLibFiles(Module module, VelocityPropertiesProvider propertiesProvider) {
        String[] libNames = propertiesProvider.getVelocimacroLibraryNames();
        if (libNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PsiFile> files = new ArrayList<PsiFile>(libNames.length);
        for (String libName : libNames) {
            ContainerUtil.addAll(files, (Object[])Util.findReferencedFiles(module, libName));
        }
        return files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToInsertComment";
                break;
            }
        }
        objectArray2[1] = "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ModuleWide
    extends DefineVelocityPropertiesRefIntention {
        public ModuleWide() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.module.wide", new Object[0]));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                ModuleWide.$$$reportNull$$$0(0);
            }
            this.chooseTargetFile(file, editor, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$ModuleWide", "invoke"));
        }
    }

    public static class LocalExternal
    extends DefineVelocityPropertiesRefIntention {
        public LocalExternal() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.external", new Object[0]));
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                LocalExternal.$$$reportNull$$$0(0);
            }
            this.chooseTargetFile(file, editor, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$LocalExternal", "invoke"));
        }
    }

    public static class Local
    extends DefineVelocityPropertiesRefIntention {
        public Local() {
            super(VelocityBundle.message("add.velocity.properties.ref.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                Local.$$$reportNull$$$0(0);
            }
            this.defineInComment(editor, file, file, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/velocity/inspections/DefineVelocityPropertiesRefIntention$Local", "invoke"));
        }
    }
}

