/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.java;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.velocity.java.VelocityNamingUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class VelocityStylePropertyResolveHelper {
    private PropertyAccessorMatchLevel myMatchLevel = PropertyAccessorMatchLevel.NameMismatch;
    private final Map<MethodSignature, PsiMethod> myMethods = new HashMap<MethodSignature, PsiMethod>();
    private final boolean mySetterNeeded;
    @Nullable
    private final String myReferenceNameWithoutFirstChar;
    private final char myReferenceNameFirstChar;

    public VelocityStylePropertyResolveHelper(@Nullable String referenceName, boolean setterNeeded) {
        this.mySetterNeeded = setterNeeded;
        if (referenceName == null) {
            this.myReferenceNameWithoutFirstChar = null;
            this.myReferenceNameFirstChar = '\u0000';
            this.myMatchLevel = PropertyAccessorMatchLevel.NameMismatch;
        } else {
            this.myReferenceNameWithoutFirstChar = referenceName.substring(1);
            this.myReferenceNameFirstChar = referenceName.charAt(0);
            this.myMatchLevel = PropertyAccessorMatchLevel.GetByObjectMethod;
        }
    }

    public boolean checkAndAddMethod(PsiMethod method, PsiSubstitutor substitutor) {
        PropertyAccessorMatchLevel matchLevel = this.getPropertyAccessorMatchLevel(method);
        if (matchLevel == PropertyAccessorMatchLevel.NotAccessor) {
            return false;
        }
        MethodSignature signature = method.getSignature(substitutor);
        PsiMethod alreadyStoredMethod = this.myMethods.get(signature);
        if (alreadyStoredMethod != null) {
            for (MethodSignatureBackedByPsiMethod methodSignature : SuperMethodsSearch.search((PsiMethod)alreadyStoredMethod, (PsiClass)alreadyStoredMethod.getContainingClass(), (boolean)true, (boolean)false).findAll()) {
                if (!methodSignature.equals((Object)signature)) continue;
                return true;
            }
        }
        if (matchLevel.compareTo(this.myMatchLevel) > 0) {
            this.myMethods.clear();
            this.myMethods.put(signature, method);
            this.myMatchLevel = matchLevel;
        } else if (matchLevel == this.myMatchLevel) {
            this.myMethods.put(signature, method);
        }
        return true;
    }

    private PropertyAccessorMatchLevel getPropertyAccessorMatchLevel(PsiMethod method) {
        String propertyName;
        String methodName = method.getName();
        if (this.mySetterNeeded) {
            if (!VelocityNamingUtil.isPropertySetter(method)) {
                return PropertyAccessorMatchLevel.NotAccessor;
            }
            propertyName = methodName.substring("set".length());
        } else {
            if (this.myReferenceNameWithoutFirstChar != null && "get".equals(methodName)) {
                PsiParameterList parameterList = method.getParameterList();
                if (parameterList.getParametersCount() != 1) {
                    return PropertyAccessorMatchLevel.NotAccessor;
                }
                PsiParameter parameter = parameterList.getParameters()[0];
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory();
                PsiClassType javaLangObject = factory.createTypeByFQClassName("java.lang.Object", method.getResolveScope());
                if (parameter.getType().isAssignableFrom((PsiType)javaLangObject)) {
                    return PropertyAccessorMatchLevel.GetByObjectMethod;
                }
                PsiClassType javaLangString = factory.createTypeByFQClassName("java.lang.String", method.getResolveScope());
                if (parameter.getType().isAssignableFrom((PsiType)javaLangString)) {
                    return PropertyAccessorMatchLevel.GetByStringMethod;
                }
                return PropertyAccessorMatchLevel.NotAccessor;
            }
            if (!VelocityNamingUtil.isPropertyGetter(method)) {
                return PropertyAccessorMatchLevel.NotAccessor;
            }
            int prefixLength = methodName.startsWith("get") ? "get".length() : "is".length();
            propertyName = methodName.substring(prefixLength);
        }
        if (this.myReferenceNameWithoutFirstChar != null && this.myReferenceNameWithoutFirstChar.equals(propertyName.substring(1))) {
            if (this.myReferenceNameFirstChar == propertyName.charAt(0)) {
                return PropertyAccessorMatchLevel.ExactNameMatch;
            }
            if (StringUtil.toLowerCase((char)this.myReferenceNameFirstChar) == StringUtil.toLowerCase((char)propertyName.charAt(0))) {
                return PropertyAccessorMatchLevel.OnlyFirstCharCaseMismatch;
            }
        }
        return PropertyAccessorMatchLevel.NameMismatch;
    }

    public Collection<PsiMethod> getMethods() {
        return this.myMethods.values();
    }

    private static enum PropertyAccessorMatchLevel {
        NotAccessor,
        NameMismatch,
        GetByObjectMethod,
        GetByStringMethod,
        OnlyFirstCharCaseMismatch,
        ExactNameMatch;

    }
}

