/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.directives;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.VelocityIcons;
import com.intellij.velocity.editorActions.VtlCommenter;
import com.intellij.velocity.psi.VtlDirectiveHeader;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlMacro;
import com.intellij.velocity.psi.VtlParameterDeclaration;
import com.intellij.velocity.psi.VtlPresentableNamedElement;
import com.intellij.velocity.psi.VtlPsiUtil;
import com.intellij.velocity.psi.directives.FixedNameVariable;
import com.intellij.velocity.psi.directives.VtlDirective;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VtlMacroImpl
extends VtlPresentableNamedElement
implements VtlDirective,
VtlMacro {
    public VtlMacroImpl(@NotNull ASTNode node) {
        if (node == null) {
            VtlMacroImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            VtlMacroImpl.$$$reportNull$$$0(1);
        }
        if (state == null) {
            VtlMacroImpl.$$$reportNull$$$0(2);
        }
        if (place == null) {
            VtlMacroImpl.$$$reportNull$$$0(3);
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        for (VtlParameterDeclaration declaration : this.getParameters()) {
            if (processor.execute((PsiElement)declaration, state)) continue;
            return false;
        }
        return processor.execute((PsiElement)new FixedNameVariable((PsiElement)this, "bodyContent", null), state) && (!VtlPsiUtil.isAtLeast17(this) || processor.execute((PsiElement)new FixedNameVariable(this, "macro", null, true), state));
    }

    @Override
    @Nullable
    protected PsiElement getNameElement() {
        return this.findHeaderOfDirective().findChildByType(VtlElementTypes.IDENTIFIER);
    }

    @Nullable
    public TextRange getNameElementRange() {
        PsiElement nameElement = this.getNameElement();
        return nameElement == null ? null : nameElement.getTextRange();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = "macro '" + this.getName() + "'";
        if (string == null) {
            VtlMacroImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public VtlParameterDeclaration @NotNull [] getParameters() {
        VtlParameterDeclaration[] vtlParameterDeclarationArray = this.findHeaderOfDirective().findChildrenByClass(VtlParameterDeclaration.class);
        if (vtlParameterDeclarationArray == null) {
            VtlMacroImpl.$$$reportNull$$$0(5);
        }
        return vtlParameterDeclarationArray;
    }

    @Override
    public VtlDirectiveHeader findHeaderOfDirective() {
        return super.findHeaderOfDirective();
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public int getFoldingStartOffset() {
        return this.getNode().getTextRange().getStartOffset() + "#macro".length();
    }

    @Override
    public int getFoldingEndOffset() {
        return this.getNode().getTextRange().getEndOffset() - "#end".length();
    }

    @Override
    public boolean needsClosing() {
        return true;
    }

    public String getTypeName() {
        return VelocityBundle.message("type.name.macro", new Object[0]);
    }

    public Icon getIcon() {
        return VelocityIcons.Sharp;
    }

    @Nullable
    public TextRange getBodyRange() {
        VtlDirectiveHeader header = (VtlDirectiveHeader)((Object)this.findChildByClass(VtlDirectiveHeader.class));
        PsiElement end = this.findChildByType(VtlElementTypes.SHARP_END);
        if (header != null && end != null) {
            return new TextRange(header.getTextRange().getEndOffset() - this.getTextRange().getStartOffset(), end.getStartOffsetInParent());
        }
        return null;
    }

    @Override
    public PsiComment getDocComment() {
        return VtlCommenter.findDocComment(this);
    }

    @Nullable
    public VtlParameterDeclaration findParameter(String name) {
        for (VtlParameterDeclaration declaration : this.getParameters()) {
            if (!name.equals(declaration.getName())) continue;
            return declaration;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/velocity/psi/directives/VtlMacroImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/velocity/psi/directives/VtlMacroImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

