/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.KubernetesYamlDetector;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.remote.JsonSchemaCatalogExclusion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/KubernetesJsonSchemaExclusion;", "Lcom/jetbrains/jsonSchema/remote/JsonSchemaCatalogExclusion;", "<init>", "()V", "isExcluded", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesJsonSchemaExclusion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesJsonSchemaExclusion.kt\ncom/intellij/kubernetes/KubernetesJsonSchemaExclusion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,17:1\n40#2,3:18\n*S KotlinDebug\n*F\n+ 1 KubernetesJsonSchemaExclusion.kt\ncom/intellij/kubernetes/KubernetesJsonSchemaExclusion\n*L\n15#1:18,3\n*E\n"})
public final class KubernetesJsonSchemaExclusion
implements JsonSchemaCatalogExclusion {
    public boolean isExcluded(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (KubernetesUtilKt.isKustomizationYamlName(file)) {
            return true;
        }
        if (Chart.Companion.isChartYamlName(file.getNameSequence())) {
            return true;
        }
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)file);
        if (project == null) {
            return false;
        }
        Project project2 = project;
        boolean $i$f$service = false;
        Class<KubernetesYamlDetector> serviceClass$iv = KubernetesYamlDetector.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((KubernetesYamlDetector)object).looksLikeKubernetesYaml(project2, file);
    }
}

