/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.kubernetes.KubernetesModelContext;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.ExternalSpecInfo;
import com.intellij.kubernetes.model.KubernetesModelSettings;
import com.intellij.kubernetes.model.RegularKubernetesModel;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.ultimate.PluginVerifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R2\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007R\u00020\u00000\u0005j\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\u0007R\u00020\u0000`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/KubernetesModelProvider;", "", "<init>", "()V", "modelHolders", "Ljava/util/HashMap;", "Lcom/intellij/kubernetes/KubernetesModelProvider$ModelKey;", "Lcom/intellij/kubernetes/KubernetesModelProvider$ModelHolder;", "Lkotlin/collections/HashMap;", "useModel", "Lcom/intellij/kubernetes/KubernetesModelContext;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/kubernetes/model/KubernetesModelSettings;", "invalidateAll", "", "releaseModel", "modelKey", "dropModel", "ModelKey", "ModelHolder", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesModelProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesModelProvider.kt\ncom/intellij/kubernetes/KubernetesModelProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1#2:190\n1863#3,2:191\n*S KotlinDebug\n*F\n+ 1 KubernetesModelProvider.kt\ncom/intellij/kubernetes/KubernetesModelProvider\n*L\n117#1:191,2\n*E\n"})
public final class KubernetesModelProvider {
    @NotNull
    private final HashMap<ModelKey, ModelHolder> modelHolders = new HashMap();

    public KubernetesModelProvider() {
        PluginVerifier.verifyUltimatePlugin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final KubernetesModelContext useModel(@NotNull Project project, @NotNull KubernetesModelSettings settings) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        HashMap<ModelKey, ModelHolder> hashMap = this.modelHolders;
        synchronized (hashMap) {
            boolean bl = false;
            ModelKey modelKey = new ModelKey(settings);
            KubernetesModelContext kubernetesModelContext = this.modelHolders.computeIfAbsent(modelKey, arg_0 -> KubernetesModelProvider.useModel$lambda$2$lambda$1(arg_0 -> KubernetesModelProvider.useModel$lambda$2$lambda$0(settings, modelKey, this, project, arg_0), arg_0)).use();
            return kubernetesModelContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invalidateAll() {
        ArrayList<ModelHolder> arrayList;
        HashMap<ModelKey, ModelHolder> hashMap = this.modelHolders;
        synchronized (hashMap) {
            boolean bl = false;
            arrayList = new ArrayList<ModelHolder>(this.modelHolders.values());
        }
        Iterable $this$forEach$iv = arrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelHolder p0 = (ModelHolder)element$iv;
            boolean $i$f$invalidateAll$stub_for_inlining = false;
            boolean bl = false;
            p0.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseModel(ModelKey modelKey) {
        HashMap<ModelKey, ModelHolder> hashMap = this.modelHolders;
        synchronized (hashMap) {
            boolean bl = false;
            ModelHolder modelHolder = this.modelHolders.get(modelKey);
            if (modelHolder != null && modelHolder.decrement()) {
                this.modelHolders.remove(modelKey);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dropModel(ModelKey modelKey) {
        HashMap<ModelKey, ModelHolder> hashMap = this.modelHolders;
        synchronized (hashMap) {
            boolean bl = false;
            ModelHolder modelHolder = this.modelHolders.remove(modelKey);
        }
    }

    private static final ModelHolder useModel$lambda$2$lambda$0(KubernetesModelSettings $settings, ModelKey $modelKey, KubernetesModelProvider this$0, Project $project, ModelKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RegularKubernetesModel model2 = RegularKubernetesModel.Companion.load($settings, $modelKey.getModelHash(), new RegularKubernetesModel.ErrorHandler($project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void handleFileError(ExternalSpecInfo specInfo, Exception error) {
                Intrinsics.checkNotNullParameter((Object)specInfo, (String)"specInfo");
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Object[] objectArray = new Object[]{specInfo.getLocalFile(), error.getMessage()};
                String string = KubernetesBundle.message("KubernetesModelProvider.model.loading.file.error", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                NotificationsKt.createModelLoadingErrorNotification(string).notify(this.$project);
            }

            public void handleUnresolvedDefinition(String typeName, SchemaSpecInfo specInfo) {
                Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
                Intrinsics.checkNotNullParameter((Object)specInfo, (String)"specInfo");
                Object[] objectArray = new Object[]{typeName, specInfo.getSpecFileMoniker()};
                String string = KubernetesBundle.message("KubernetesModelProvider.model.loading.unresolved.definition.error", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                NotificationsKt.createModelLoadingErrorNotification(string).notify(this.$project);
            }

            public void handleGenericError(String typeName, SchemaSpecInfo specInfo, String message2) {
                Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
                Intrinsics.checkNotNullParameter((Object)specInfo, (String)"specInfo");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Object[] objectArray = new Object[]{typeName, specInfo.getSpecFileMoniker(), message2};
                String string = KubernetesBundle.message("KubernetesModelProvider.model.loading.processing.definition.error", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                NotificationsKt.createModelLoadingErrorNotification(string).notify(this.$project);
            }
        });
        return this$0.new ModelHolder(model2, $modelKey);
    }

    private static final ModelHolder useModel$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        return (ModelHolder)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0006\u0010\u0017\u001a\u00020\u0001J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\u0006\u0010\u0019\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000fR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/KubernetesModelProvider$ModelHolder;", "Lcom/intellij/kubernetes/KubernetesModelContext;", "model", "Lcom/intellij/kubernetes/model/RegularKubernetesModel;", "modelKey", "Lcom/intellij/kubernetes/KubernetesModelProvider$ModelKey;", "<init>", "(Lcom/intellij/kubernetes/KubernetesModelProvider;Lcom/intellij/kubernetes/model/RegularKubernetesModel;Lcom/intellij/kubernetes/KubernetesModelProvider$ModelKey;)V", "getModel", "()Lcom/intellij/kubernetes/model/RegularKubernetesModel;", "valid", "Ljava/util/concurrent/atomic/AtomicBoolean;", "outdated", "", "isValid", "()Z", "isOutdated", "markOutdated", "", "clearOutdated", "invalidate", "usageCounter", "", "use", "release", "decrement", "intellij.clouds.kubernetes"})
    private final class ModelHolder
    implements KubernetesModelContext {
        @NotNull
        private final RegularKubernetesModel model;
        @NotNull
        private final ModelKey modelKey;
        @NotNull
        private final AtomicBoolean valid;
        private boolean outdated;
        private int usageCounter;

        public ModelHolder(@NotNull RegularKubernetesModel model2, ModelKey modelKey) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)modelKey, (String)"modelKey");
            this.model = model2;
            this.modelKey = modelKey;
            this.valid = new AtomicBoolean(true);
        }

        @Override
        @NotNull
        public RegularKubernetesModel getModel() {
            return this.model;
        }

        @Override
        public boolean isValid() {
            return this.valid.get();
        }

        @Override
        public boolean isOutdated() {
            return this.outdated;
        }

        @Override
        public void markOutdated() {
            this.outdated = true;
        }

        @Override
        public void clearOutdated() {
            this.outdated = false;
        }

        @Override
        public void invalidate() {
            if (this.valid.compareAndSet(true, false)) {
                KubernetesModelProvider.this.dropModel(this.modelKey);
            }
        }

        @NotNull
        public final KubernetesModelContext use() {
            ++this.usageCounter;
            return this;
        }

        @Override
        public void release() {
            KubernetesModelProvider.this.releaseModel(this.modelKey);
        }

        public final boolean decrement() {
            boolean bl;
            boolean bl2 = bl = this.usageCounter > 0;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.usageCounter += -1;
            return this.usageCounter == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u0007H\u0016J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/KubernetesModelProvider$ModelKey;", "", "settings", "Lcom/intellij/kubernetes/model/KubernetesModelSettings;", "<init>", "(Lcom/intellij/kubernetes/model/KubernetesModelSettings;)V", "modelHash", "", "getModelHash", "()I", "hashCode", "equals", "", "other", "intellij.clouds.kubernetes"})
    private static final class ModelKey {
        private final int modelHash;

        public ModelKey(@NotNull KubernetesModelSettings settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.modelHash = settings.hashCode();
        }

        public final int getModelHash() {
            return this.modelHash;
        }

        public int hashCode() {
            return this.modelHash;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.kubernetes.KubernetesModelProvider.ModelKey");
            ModelKey cfr_ignored_0 = (ModelKey)other;
            return this.modelHash == ((ModelKey)other).modelHash;
        }
    }
}

