/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020(H\u0016J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020(H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020(H\u0016J\u0010\u0010-\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020(H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR@\u0010\r\u001a2\u0012\u000e\u0012\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u0011 \u0013*\u0017\u0012\u000e\u0012\f0\u000f\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\b\u00110\u0012\u00a2\u0006\u0002\b\u00110\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006."}, d2={"Lcom/intellij/kubernetes/SpecModificationListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modelAccessor", "Lcom/intellij/kubernetes/KubernetesModelAccessor;", "getModelAccessor", "()Lcom/intellij/kubernetes/KubernetesModelAccessor;", "modelAccessor$delegate", "Lkotlin/Lazy;", "crdPaths", "", "", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "Ljava/util/Set;", "update", "", "localSpecPaths", "", "isCrdSpec", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "checkFile", "fileCreated", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileDeletion", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "contentsChanged", "childAdded", "Lcom/intellij/psi/PsiTreeChangeEvent;", "childRemoved", "childReplaced", "childMoved", "childrenChanged", "processPsiTreeChange", "intellij.clouds.kubernetes"})
public final class SpecModificationListener
extends PsiTreeChangeAdapter
implements VirtualFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy modelAccessor$delegate;
    @NotNull
    private final Set<String> crdPaths;

    public SpecModificationListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modelAccessor$delegate = LazyKt.lazy(() -> SpecModificationListener.modelAccessor_delegate$lambda$0(this));
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.crdPaths = set;
    }

    private final KubernetesModelAccessor getModelAccessor() {
        Lazy lazy = this.modelAccessor$delegate;
        return (KubernetesModelAccessor)lazy.getValue();
    }

    public final void update(@NotNull Collection<String> localSpecPaths) {
        Intrinsics.checkNotNullParameter(localSpecPaths, (String)"localSpecPaths");
        this.crdPaths.clear();
        this.crdPaths.addAll(localSpecPaths);
    }

    private final boolean isCrdSpec(VirtualFile file) {
        return !file.isDirectory() && this.crdPaths.contains(file.getPath());
    }

    private final void checkFile(VirtualFile file) {
        if (this.isCrdSpec(file)) {
            this.getModelAccessor().markOutdated();
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!Intrinsics.areEqual((Object)event2.getPropertyName(), (Object)"name") || Intrinsics.areEqual((Object)event2.getOldValue(), (Object)event2.getNewValue())) {
            return;
        }
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    private final void processPsiTreeChange(PsiTreeChangeEvent event2) {
        PsiFile psiFile = event2.getFile();
        if (psiFile == null || (psiFile = YamlUtilKt.getVfsFile((PsiElement)psiFile)) == null) {
            return;
        }
        this.checkFile((VirtualFile)psiFile);
    }

    private static final KubernetesModelAccessor modelAccessor_delegate$lambda$0(SpecModificationListener this$0) {
        return KubernetesModelAccessor.Companion.getInstance(this$0.project);
    }
}

