/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.google.gson.reflect.TypeToken;
import com.intellij.kubernetes.api.ApiClientTools;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.api.KubernetesKtorWatch;
import com.intellij.kubernetes.api.KubernetesKtorWatchKt;
import com.intellij.openapi.util.registry.Registry;
import io.ktor.client.HttpClient;
import io.ktor.client.plugins.HttpTimeout;
import io.ktor.client.plugins.HttpTimeoutKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.http.HttpMethod;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.util.Watch;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JM\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007\"\b\b\u0001\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0011J@\u0010\u0012\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007\"\b\b\u0001\u0010\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u0002H\u00060\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001d\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J0\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\b0\u0018\"\b\b\u0000\u0010\b*\u00020\t2\u0010\u0010\f\u001a\f\u0012\u0004\u0012\u0002H\b\u0012\u0002\b\u00030\r2\u0006\u0010\n\u001a\u00020\u000bJ4\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\b0\u0018\"\b\b\u0000\u0010\b*\u00020\t2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J&\u0010\u001d\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150!0\u001eH\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/api/KubernetesWatchFactory;", "", "<init>", "()V", "getHttpRequestBuilder", "Lio/ktor/client/request/HttpRequestBuilder;", "L", "Lio/kubernetes/client/common/KubernetesListObject;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "entity", "Lcom/intellij/kubernetes/api/KubernetesEntity;", "useProxy", "", "watch", "getHttpRequestBuilder$intellij_clouds_kubernetes", "createKubernetesHttpRequestBuilderWithProxy", "getHttpRequestSelfSubjectAccessReviewBuilder", "resource", "", "getHttpRequestSelfSubjectAccessReviewBuilder$intellij_clouds_kubernetes", "createResourceWatch", "Lcom/intellij/kubernetes/api/KubernetesKtorWatch;", "createKtorWatch", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "builder", "prepareParams", "Lkotlin/Pair;", "", "Lio/kubernetes/client/openapi/Pair;", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesWatchFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesWatchFactory.kt\ncom/intellij/kubernetes/api/KubernetesWatchFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,221:1\n1#2:222\n126#3:223\n153#3,3:224\n*S KotlinDebug\n*F\n+ 1 KubernetesWatchFactory.kt\ncom/intellij/kubernetes/api/KubernetesWatchFactory\n*L\n114#1:223\n114#1:224,3\n*E\n"})
public final class KubernetesWatchFactory {
    @NotNull
    public static final KubernetesWatchFactory INSTANCE = new KubernetesWatchFactory();

    private KubernetesWatchFactory() {
    }

    @NotNull
    public final <L extends KubernetesListObject, T extends KubernetesObject> HttpRequestBuilder getHttpRequestBuilder$intellij_clouds_kubernetes(@NotNull KubernetesApiModel apiModel2, @NotNull KubernetesEntity<T, L> entity, boolean useProxy, boolean watch2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        if (!useProxy) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        HttpRequestBuilder builder = this.createKubernetesHttpRequestBuilderWithProxy(apiModel2, entity, watch2);
        HttpTimeoutKt.timeout((HttpRequestBuilder)builder, KubernetesWatchFactory::getHttpRequestBuilder$lambda$0);
        return builder;
    }

    private final <L extends KubernetesListObject, T extends KubernetesObject> HttpRequestBuilder createKubernetesHttpRequestBuilderWithProxy(KubernetesApiModel apiModel2, KubernetesEntity<T, L> entity, boolean watch2) {
        CharSequence charSequence;
        KubernetesApiModel $this$createKubernetesHttpRequestBuilderWithProxy_u24lambda_u242 = apiModel2;
        boolean bl = false;
        Pair<List<io.kubernetes.client.openapi.Pair>, Map<String, String>> pair = INSTANCE.prepareParams();
        List queryParams = (List)pair.component1();
        Map headerParams = (Map)pair.component2();
        Sequence<String> sequence = entity.apiPathSegments($this$createKubernetesHttpRequestBuilderWithProxy_u24lambda_u242.getNamespaceForRequest(), watch2);
        CharSequence charSequence2 = "/";
        CharSequence charSequence3 = "/";
        CharSequence charSequence4 = Registry.Companion.stringValue("kubernetes.cluster.watch.url.suffix");
        if (charSequence4.length() == 0) {
            CharSequence charSequence5 = charSequence3;
            CharSequence charSequence6 = charSequence2;
            Sequence<String> sequence2 = sequence;
            boolean bl2 = false;
            String string = "/";
            sequence = sequence2;
            charSequence2 = charSequence6;
            charSequence3 = charSequence5;
            charSequence = string;
        } else {
            charSequence = charSequence4;
        }
        String string = SequencesKt.joinToString$default(sequence, (CharSequence)charSequence2, (CharSequence)charSequence3, (CharSequence)charSequence, (int)0, null, null, (int)56, null);
        charSequence4 = HttpMethod.Companion.getGet();
        List list2 = CollectionsKt.toMutableList((Collection)queryParams);
        String string2 = "http://127.0.0.1:" + $this$createKubernetesHttpRequestBuilderWithProxy_u24lambda_u242.getProxy$intellij_clouds_kubernetes().getProxyPort();
        HttpRequestBuilder builder = KubernetesKtorWatchKt.buildKtorRequest$default(string, (HttpMethod)charSequence4, list2, headerParams, string2, null, 32, null);
        return builder;
    }

    @NotNull
    public final HttpRequestBuilder getHttpRequestSelfSubjectAccessReviewBuilder$intellij_clouds_kubernetes(@NotNull KubernetesApiModel apiModel2, @NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        String postBody = StringsKt.trimIndent((String)("\n        {\n            \"apiVersion\": \"authorization.k8s.io/v1\",\n            \"kind\": \"SelfSubjectAccessReview\",\n            \"spec\": {\n                \"resourceAttributes\": {\n                    \"namespace\": \"" + apiModel2.getNamespaceForRequest() + "\",\n                    \"verb\": \"get\",\n                    \"resource\": \"" + resource + "\"\n                }\n            }\n        }\n    "));
        Pair[] pairArray = new Pair[2];
        String[] stringArray = new String[]{"application/json"};
        pairArray[0] = TuplesKt.to((Object)"Accept", (Object)ApiClientTools.INSTANCE.selectHeaderAccept(stringArray));
        pairArray[1] = TuplesKt.to((Object)"Content-Type", (Object)"application/json");
        Map headerParams = MapsKt.mapOf((Pair[])pairArray);
        stringArray = HttpMethod.Companion.getPost();
        String string = "http://127.0.0.1:" + apiModel2.getProxy$intellij_clouds_kubernetes().getProxyPort();
        List list2 = new ArrayList();
        HttpRequestBuilder builder = KubernetesKtorWatchKt.buildKtorRequest("/apis/authorization.k8s.io/v1/selfsubjectaccessreviews", (HttpMethod)stringArray, list2, headerParams, string, postBody);
        HttpTimeoutKt.timeout((HttpRequestBuilder)builder, KubernetesWatchFactory::getHttpRequestSelfSubjectAccessReviewBuilder$lambda$3);
        return builder;
    }

    @NotNull
    public final <T extends KubernetesObject> KubernetesKtorWatch<T> createResourceWatch(@NotNull KubernetesEntity<T, ?> entity, @NotNull KubernetesApiModel apiModel2) {
        Intrinsics.checkNotNullParameter(entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Type[] typeArray = new Type[]{JvmClassMappingKt.getJavaClass(entity.getType())};
        TypeToken typeToken = TypeToken.getParameterized((Type)((Type)((Object)Watch.Response.class)), (Type[])typeArray);
        if (!apiModel2.getProxy$intellij_clouds_kubernetes().getProxyIsRunning()) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        HttpRequestBuilder builder = this.createKubernetesHttpRequestBuilderWithProxy(apiModel2, entity, true);
        Intrinsics.checkNotNull((Object)typeToken);
        return this.createKtorWatch(typeToken, apiModel2, builder);
    }

    private final <T extends KubernetesObject> KubernetesKtorWatch<T> createKtorWatch(TypeToken<?> typeToken, KubernetesApiModel apiModel2, HttpRequestBuilder builder) {
        HttpClient httpClient = apiModel2.getKtorClient();
        KubernetesKtorWatch watch2 = new KubernetesKtorWatch(apiModel2.getCoroutineScope(), httpClient, builder, typeToken);
        return watch2;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<io.kubernetes.client.openapi.Pair>, Map<String, String>> prepareParams() {
        void $this$mapTo$iv$iv;
        Pair[] $this$map$iv = MapsKt.mapOf((Pair)TuplesKt.to((Object)"timeoutSeconds", (Object)0));
        boolean $i$f$map22 = false;
        Pair[] pairArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key = (String)entry.getKey();
            int value2 = ((Number)entry.getValue()).intValue();
            collection.add(new io.kubernetes.client.openapi.Pair(key, ApiClientTools.INSTANCE.parameterToString(value2)));
        }
        List queryParams = (List)destination$iv$iv;
        String[] $i$f$map22 = new String[]{"application/json", "application/json;stream=watch"};
        String[] accepts = $i$f$map22;
        pairArray = new Pair[]{TuplesKt.to((Object)"Accept", (Object)ApiClientTools.INSTANCE.selectHeaderAccept(accepts)), TuplesKt.to((Object)"Content-Type", (Object)ApiClientTools.INSTANCE.selectHeaderContentType(new String[0]))};
        Map headerParams = MapsKt.mapOf((Pair[])pairArray);
        return new Pair((Object)queryParams, (Object)headerParams);
    }

    private static final Unit getHttpRequestBuilder$lambda$0(HttpTimeout.HttpTimeoutCapabilityConfiguration $this$timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"$this$timeout");
        $this$timeout.setRequestTimeoutMillis(Long.valueOf(3000L));
        return Unit.INSTANCE;
    }

    private static final Unit getHttpRequestSelfSubjectAccessReviewBuilder$lambda$3(HttpTimeout.HttpTimeoutCapabilityConfiguration $this$timeout) {
        Intrinsics.checkNotNullParameter((Object)$this$timeout, (String)"$this$timeout");
        $this$timeout.setRequestTimeoutMillis(Long.valueOf(3000L));
        return Unit.INSTANCE;
    }
}

