/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.kubernetes.api.ClusterLogPublisher;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesLogHandler;
import com.intellij.kubernetes.api.ProcessFlowEvent;
import com.intellij.kubernetes.view.KubernetesContextServiceViewContributor;
import com.intellij.kubernetes.view.KubernetesServiceViewContributor;
import com.intellij.kubernetes.view.KubernetesServiceViewContributorKt;
import com.intellij.openapi.progress.CoroutinesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096B\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/api/LogHandlerPublisher;", "Lcom/intellij/kubernetes/api/ClusterLogPublisher;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "logHandler", "Lcom/intellij/kubernetes/api/KubernetesLogHandler;", "invoke", "", "value", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "(Lcom/intellij/kubernetes/api/ProcessFlowEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishIdeProcessLog", "message", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishConsoleProcessLog", "printErr", "", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectModelInServiceView", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nFlowProcessExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowProcessExecutor.kt\ncom/intellij/kubernetes/api/LogHandlerPublisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class LogHandlerPublisher
extends ClusterLogPublisher {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final KubernetesLogHandler logHandler;

    public LogHandlerPublisher(@NotNull KubernetesApiModel apiModel2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        this.apiModel = apiModel2;
        this.logHandler = (KubernetesLogHandler)this.apiModel.getProject().getMessageBus().syncPublisher(KubernetesLogHandler.TOPIC);
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull ProcessFlowEvent value2, @NotNull Continuation<? super Unit> $completion) {
        ProcessFlowEvent processFlowEvent = value2;
        if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput.OnStdOut) {
            Object object = CoroutinesKt.blockingContext(() -> LogHandlerPublisher.invoke$lambda$0(this, value2), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput.OnStdError) {
            Object object = CoroutinesKt.blockingContext(() -> LogHandlerPublisher.invoke$lambda$1(this, value2), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (processFlowEvent instanceof ProcessFlowEvent.OnCommandLine) {
            Object object = CoroutinesKt.blockingContext(() -> LogHandlerPublisher.invoke$lambda$2(this, value2), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object publishIdeProcessLog(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        this.logHandler.printSystem(this.apiModel, message2 + "\n");
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object publishConsoleProcessLog(@NotNull String message2, boolean printErr, @NotNull Continuation<? super Unit> $completion) {
        if (printErr) {
            this.logHandler.printError(this.apiModel, message2 + "\n");
        } else {
            this.logHandler.printNormal(this.apiModel, message2 + "\n");
        }
        return Unit.INSTANCE;
    }

    private final void selectModelInServiceView(KubernetesApiModel apiModel2) {
        Object v1;
        block3: {
            KubernetesServiceViewContributor kubernetesServiceViewContributor = (KubernetesServiceViewContributor)ServiceViewContributor.findRootContributor(KubernetesServiceViewContributor.class);
            if (kubernetesServiceViewContributor == null) {
                return;
            }
            KubernetesServiceViewContributor kubernetesServiceViewContributor2 = kubernetesServiceViewContributor;
            Iterable iterable = kubernetesServiceViewContributor2.getServices(apiModel2.getProject());
            for (Object t : iterable) {
                ServiceViewContributor svc = (ServiceViewContributor)t;
                boolean bl = false;
                if (!(svc instanceof KubernetesContextServiceViewContributor && ((KubernetesContextServiceViewContributor)svc).getApiModel$intellij_clouds_kubernetes() == apiModel2)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        ServiceViewContributor serviceViewContributor = v1;
        if (serviceViewContributor == null) {
            return;
        }
        ServiceViewContributor serviceViewContributor2 = serviceViewContributor;
        KubernetesServiceViewContributorKt.selectKubernetesService(apiModel2.getProject(), serviceViewContributor2);
    }

    private static final Unit invoke$lambda$0(LogHandlerPublisher this$0, ProcessFlowEvent $value) {
        KubernetesLogHandler kubernetesLogHandler = this$0.logHandler;
        KubernetesApiModel kubernetesApiModel = this$0.apiModel;
        String string = ((ProcessFlowEvent.OnProcessOutput.OnStdOut)$value).getProcessEvent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        kubernetesLogHandler.printNormal(kubernetesApiModel, string);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$1(LogHandlerPublisher this$0, ProcessFlowEvent $value) {
        KubernetesLogHandler kubernetesLogHandler = this$0.logHandler;
        KubernetesApiModel kubernetesApiModel = this$0.apiModel;
        String string = ((ProcessFlowEvent.OnProcessOutput.OnStdError)$value).getProcessEvent().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        kubernetesLogHandler.printError(kubernetesApiModel, string);
        return Unit.INSTANCE;
    }

    private static final Unit invoke$lambda$2(LogHandlerPublisher this$0, ProcessFlowEvent $value) {
        this$0.selectModelInServiceView(this$0.apiModel);
        this$0.logHandler.printSystem(this$0.apiModel, "\n" + ((ProcessFlowEvent.OnCommandLine)$value).getCommandLine() + "\n\n");
        return Unit.INSTANCE;
    }
}

