/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api.settings;

import com.intellij.kubernetes.api.settings.KubernetesApiSettings;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@State(name="KubernetesApiSettings", storages={@Storage(value="kubernetes-settings.xml")})
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0017\u0018B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "topic", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings$Listener;", "getTopic", "()Lcom/intellij/util/messages/Topic;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "getMessageBus", "()Lcom/intellij/util/messages/MessageBus;", "value", "", "autoDetectServerPath", "getAutoDetectServerPath", "()Z", "setAutoDetectServerPath", "(Z)V", "Companion", "Listener", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesApiProjectSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiProjectSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings\n+ 2 MessageBusUtilities.kt\ncom/intellij/kubernetes/util/MessageBusUtilitiesKt\n*L\n1#1,42:1\n6#2,4:43\n*S KotlinDebug\n*F\n+ 1 KubernetesApiProjectSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings\n*L\n23#1:43,4\n*E\n"})
public final class KubernetesApiProjectSettings
extends KubernetesApiSettings<KubernetesApiSettings.State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageBus messageBus;
    @Topic.ProjectLevel
    @JvmField
    @NotNull
    public static final Topic<Listener> TOPIC;

    public KubernetesApiProjectSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new KubernetesApiSettings.State());
        MessageBus messageBus = project.getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        this.messageBus = messageBus;
    }

    @Override
    @NotNull
    protected Topic<Listener> getTopic() {
        return TOPIC;
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        return this.messageBus;
    }

    public final boolean getAutoDetectServerPath() {
        return ((KubernetesApiSettings.State)this.getState()).getAutoDetectShellPath();
    }

    public final void setAutoDetectServerPath(boolean value2) {
        boolean oldValue = ((KubernetesApiSettings.State)this.getState()).getAutoDetectShellPath();
        if (oldValue == value2) {
            return;
        }
        ((KubernetesApiSettings.State)this.getState()).setAutoDetectShellPath(value2);
    }

    @JvmStatic
    @NotNull
    public static final KubernetesApiProjectSettings getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        String displayName$iv = "K8s API project settings changes";
        Topic.BroadcastDirection direction$iv = Topic.BroadcastDirection.TO_CHILDREN;
        boolean $i$f$createTopic = false;
        Topic topic = Topic.create((String)displayName$iv, Listener.class, (Topic.BroadcastDirection)direction$iv);
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"create(...)");
        TOPIC = topic;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings$Listener;", "getInstance", "Lcom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesApiProjectSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiProjectSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,42:1\n31#2,2:43\n*S KotlinDebug\n*F\n+ 1 KubernetesApiProjectSettings.kt\ncom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings$Companion\n*L\n26#1:43,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesApiProjectSettings getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesApiProjectSettings> serviceClass$iv = KubernetesApiProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesApiProjectSettings)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0002\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/api/settings/KubernetesApiProjectSettings$Listener;", "Lcom/intellij/kubernetes/api/settings/KubernetesApiSettings$Listener;", "intellij.clouds.kubernetes"})
    public static interface Listener
    extends KubernetesApiSettings.Listener {
    }
}

