/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.debug.survey;

import com.intellij.codeWithMe.ClientId;
import com.intellij.kubernetes.debug.survey.DebugInKubernetesSurveyStore;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.testFramework.LightVirtualFile;
import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DebugInKubernetesSurveyStore", storages={@Storage(value="debugInKubernetesSurveyStore.xml")})
@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0001\u0018\u0000 52\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000556789B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\r\u0010\u0017\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0018J\r\u0010\u0019\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aJ\u0015\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002J\u0016\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0082@\u00a2\u0006\u0002\u0010&J\r\u0010'\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b.J\r\u0010/\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b2J\b\u00103\u001a\u00020\u0015H\u0002J\b\u00104\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$MyPersistentState;", "serviceScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "canShowSurvey", "", "monitoringScope", "deploymentChangeCheckStartedAt", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/datetime/Instant;", "telepresenceUsageMonitor", "Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$TelepresenceUsageMonitor;", "telepresenceWithFollowingKubernetesUsageMonitor", "Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$TelepresenceWithFollowingKubernetesUsageMonitor;", "kubernetesUsageMonitor", "Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$KubernetesUsageMonitor;", "getState", "loadState", "", "state", "isCanBeShown", "isCanBeShown$intellij_clouds_kubernetes", "projectOpened", "projectOpened$intellij_clouds_kubernetes", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "documentChanged$intellij_clouds_kubernetes", "codeWasEdited", "tryScheduleDeploymentChangeCheck", "document", "Lcom/intellij/openapi/editor/Document;", "checkPossibleDeploymentChange", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "telepresenceWasConnected", "telepresenceWasConnected$intellij_clouds_kubernetes", "telepresenceWasDisconnected", "telepresenceWasDisconnected$intellij_clouds_kubernetes", "runOrDebugWasLaunched", "runOrDebugWasLaunched$intellij_clouds_kubernetes", "kubernetesClusterWasConnected", "kubernetesClusterWasConnected$intellij_clouds_kubernetes", "kubernetesClusterWasDisconnected", "kubernetesClusterWasDisconnected$intellij_clouds_kubernetes", "kubernetesPluginWasUsed", "kubernetesPluginWasUsed$intellij_clouds_kubernetes", "deploymentWasEdited", "allowShowingSurveyAndCancelMonitoring", "Companion", "MyPersistentState", "TelepresenceUsageMonitor", "TelepresenceWithFollowingKubernetesUsageMonitor", "KubernetesUsageMonitor", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nDebugInKubernetesSurveyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugInKubernetesSurveyStore.kt\ncom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,333:1\n12574#2,2:334\n14#3:336\n*S KotlinDebug\n*F\n+ 1 DebugInKubernetesSurveyStore.kt\ncom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore\n*L\n118#1:334,2\n27#1:336\n*E\n"})
public final class DebugInKubernetesSurveyStore
implements PersistentStateComponent<MyPersistentState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope serviceScope;
    private boolean canShowSurvey;
    @NotNull
    private final CoroutineScope monitoringScope;
    @NotNull
    private final MutableStateFlow<Instant> deploymentChangeCheckStartedAt;
    @NotNull
    private final TelepresenceUsageMonitor telepresenceUsageMonitor;
    @NotNull
    private final TelepresenceWithFollowingKubernetesUsageMonitor telepresenceWithFollowingKubernetesUsageMonitor;
    @NotNull
    private final KubernetesUsageMonitor kubernetesUsageMonitor;
    @NotNull
    private static final Logger LOG;

    public DebugInKubernetesSurveyStore(@NotNull CoroutineScope serviceScope) {
        Intrinsics.checkNotNullParameter((Object)serviceScope, (String)"serviceScope");
        this.serviceScope = serviceScope;
        this.monitoringScope = CoroutineScopeKt.childScope$default((CoroutineScope)this.serviceScope, (String)"DebugInKubernetesSurveyStore.monitoringScope", null, (boolean)true, (int)2, null);
        this.deploymentChangeCheckStartedAt = StateFlowKt.MutableStateFlow((Object)Clock.System.INSTANCE.now());
        this.telepresenceUsageMonitor = new TelepresenceUsageMonitor();
        this.telepresenceWithFollowingKubernetesUsageMonitor = new TelepresenceWithFollowingKubernetesUsageMonitor();
        this.kubernetesUsageMonitor = new KubernetesUsageMonitor();
    }

    @NotNull
    public MyPersistentState getState() {
        return new MyPersistentState(this.canShowSurvey, this.telepresenceUsageMonitor.isTimerStarted());
    }

    public void loadState(@NotNull MyPersistentState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        LOG.trace("loadState() called. loaded state = " + state);
        if (state.getCanShowSurvey()) {
            this.allowShowingSurveyAndCancelMonitoring();
        } else {
            this.canShowSurvey = false;
        }
        this.telepresenceUsageMonitor.timerStartedStateLoaded(state.getTelepresenceUsageMonitorTimerStarted());
    }

    public final boolean isCanBeShown$intellij_clouds_kubernetes() {
        return this.canShowSurvey;
    }

    public final void projectOpened$intellij_clouds_kubernetes() {
        this.telepresenceUsageMonitor.projectOpened();
    }

    public final void documentChanged$intellij_clouds_kubernetes(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        this.codeWasEdited();
        Document document = event2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        this.tryScheduleDeploymentChangeCheck(document);
    }

    private final void codeWasEdited() {
        LOG.trace("codeWasEdited(): call telepresenceWithFollowingKubernetesUsageMonitor.relatedActivityHappened()");
        this.telepresenceWithFollowingKubernetesUsageMonitor.relatedActivityHappened();
    }

    private final void tryScheduleDeploymentChangeCheck(Document document) {
        Instant previousCheckTime = (Instant)this.deploymentChangeCheckStartedAt.getValue();
        Instant now = Clock.System.INSTANCE.now();
        if (Duration.compareTo-LRDsOJo((long)now.minus-5sfh64U(previousCheckTime), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        if (!this.deploymentChangeCheckStartedAt.compareAndSet((Object)previousCheckTime, (Object)now)) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        if (virtualFile == null) {
            return;
        }
        if (virtualFile instanceof LightVirtualFile) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.monitoringScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, virtualFile, null){
            int label;
            final /* synthetic */ DebugInKubernetesSurveyStore this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = DebugInKubernetesSurveyStore.access$checkPossibleDeploymentChange(this.this$0, this.$virtualFile, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkPossibleDeploymentChange(VirtualFile var1_1, Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkPossibleDeploymentChange.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DebugInKubernetesSurveyStore this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DebugInKubernetesSurveyStore.access$checkPossibleDeploymentChange(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                DebugInKubernetesSurveyStore.LOG.trace("checkPossibleDeploymentChange() called: file.name=" + virtualFile.getName());
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, checkPossibleDeploymentChange$lambda$1(com.intellij.openapi.vfs.VirtualFile ), ()Ljava/lang/Boolean;)((VirtualFile)virtualFile), (Continuation)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                this = (DebugInKubernetesSurveyStore)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                if (isPlainKubernetesFile = ((Boolean)v0).booleanValue()) {
                    DebugInKubernetesSurveyStore.LOG.trace("checkPossibleDeploymentChange(): isPlainKubernetesFile is true. call deploymentWasEdited()");
                    this.deploymentWasEdited();
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void telepresenceWasConnected$intellij_clouds_kubernetes() {
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        LOG.trace("telepresenceWasConnected(): call telepresenceUsageMonitor.telepresenceWasConnected()");
        this.telepresenceUsageMonitor.telepresenceWasConnected();
        LOG.trace("telepresenceWasConnected(): call telepresenceWithFollowingKubernetesUsageMonitor.telepresenceWasConnected()");
        this.telepresenceWithFollowingKubernetesUsageMonitor.telepresenceWasConnected();
    }

    public final void telepresenceWasDisconnected$intellij_clouds_kubernetes() {
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        this.telepresenceUsageMonitor.telepresenceWasDisconnected();
    }

    public final void runOrDebugWasLaunched$intellij_clouds_kubernetes() {
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        LOG.trace("runOrDebugWasLaunched(): call telepresenceWithFollowingKubernetesUsageMonitor.relatedActivityHappened()");
        this.telepresenceWithFollowingKubernetesUsageMonitor.relatedActivityHappened();
        LOG.trace("runOrDebugWasLaunched(): call kubernetesUsageMonitor.relatedActivityHappened()");
        this.kubernetesUsageMonitor.relatedActivityHappened();
    }

    public final void kubernetesClusterWasConnected$intellij_clouds_kubernetes() {
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        LOG.trace("kubernetesClusterWasConnected(): call kubernetesUsageMonitor.relatedActivityHappened()");
        this.kubernetesUsageMonitor.relatedActivityHappened();
        LOG.trace("kubernetesClusterWasConnected(): call kubernetesUsageMonitor.initialActivityHappened()");
        this.kubernetesUsageMonitor.initialActivityHappened();
    }

    public final void kubernetesClusterWasDisconnected$intellij_clouds_kubernetes() {
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        LOG.trace("kubernetesClusterWasDisconnected(): call kubernetesUsageMonitor.relatedActivityHappened()");
        this.kubernetesUsageMonitor.relatedActivityHappened();
    }

    public final void kubernetesPluginWasUsed$intellij_clouds_kubernetes() {
        if (!kotlinx.coroutines.CoroutineScopeKt.isActive((CoroutineScope)this.monitoringScope)) {
            return;
        }
        LOG.trace("kubernetesPluginWasUsed(): call telepresenceWithFollowingKubernetesUsageMonitor.relatedActivityHappened()");
        this.telepresenceWithFollowingKubernetesUsageMonitor.relatedActivityHappened();
    }

    private final void deploymentWasEdited() {
        LOG.trace("deploymentWasEdited(): call kubernetesUsageMonitor.relatedActivityHappened()");
        this.kubernetesUsageMonitor.relatedActivityHappened();
        LOG.trace("deploymentWasEdited(): call kubernetesUsageMonitor.initialActivityHappened()");
        this.kubernetesUsageMonitor.initialActivityHappened();
    }

    private final void allowShowingSurveyAndCancelMonitoring() {
        LOG.trace("allowShowingSurveyAndCancelMonitoring() called");
        BuildersKt.launch$default((CoroutineScope)this.serviceScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DebugInKubernetesSurveyStore this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        DebugInKubernetesSurveyStore.access$getLOG$cp().trace("canShowSurvey = true; monitoringScope.cancel()");
                        DebugInKubernetesSurveyStore.access$setCanShowSurvey$p(this.this$0, true);
                        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)DebugInKubernetesSurveyStore.access$getMonitoringScope$p(this.this$0), null, (int)1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkPossibleDeploymentChange$lambda$1(VirtualFile $virtualFile) {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$any$iv = projectArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            Project it = (Project)element$iv;
            boolean bl = false;
            if (ProjectFileIndex.getInstance((Project)it).isInContent($virtualFile)) {
                Intrinsics.checkNotNull((Object)it);
                if (UtilsKt.isPlainKubernetesFile($virtualFile, it)) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final /* synthetic */ Object access$checkPossibleDeploymentChange(DebugInKubernetesSurveyStore $this, VirtualFile virtualFile, Continuation $completion) {
        return $this.checkPossibleDeploymentChange(virtualFile, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$setCanShowSurvey$p(DebugInKubernetesSurveyStore $this, boolean bl) {
        $this.canShowSurvey = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DebugInKubernetesSurveyStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "instance", "Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore;", "getInstance", "()Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nDebugInKubernetesSurveyStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugInKubernetesSurveyStore.kt\ncom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,333:1\n40#2,3:334\n*S KotlinDebug\n*F\n+ 1 DebugInKubernetesSurveyStore.kt\ncom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$Companion\n*L\n29#1:334,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DebugInKubernetesSurveyStore getInstance() {
            boolean $i$f$service = false;
            Class<DebugInKubernetesSurveyStore> serviceClass$iv = DebugInKubernetesSurveyStore.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (DebugInKubernetesSurveyStore)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$KubernetesUsageMonitor;", "", "<init>", "(Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore;)V", "relatedActivityObserverStarted", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "relatedActivityHappened", "", "initialActivityHappened", "intellij.clouds.kubernetes"})
    private final class KubernetesUsageMonitor {
        @NotNull
        private MutableStateFlow<Boolean> relatedActivityObserverStarted = StateFlowKt.MutableStateFlow((Object)false);
        @NotNull
        private MutableStateFlow<Boolean> relatedActivityHappened = StateFlowKt.MutableStateFlow((Object)false);

        public final void relatedActivityHappened() {
            this.relatedActivityHappened.setValue((Object)true);
        }

        public final void initialActivityHappened() {
            BuildersKt.launch$default((CoroutineScope)DebugInKubernetesSurveyStore.this.monitoringScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, DebugInKubernetesSurveyStore.this, null){
                int I$0;
                int label;
                final /* synthetic */ KubernetesUsageMonitor this$0;
                final /* synthetic */ DebugInKubernetesSurveyStore this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            canStart = KubernetesUsageMonitor.access$getRelatedActivityObserverStarted$p(this.this$0).compareAndSet((Object)Boxing.boxBoolean((boolean)false), (Object)Boxing.boxBoolean((boolean)true));
                            if (!canStart) {
                                return Unit.INSTANCE;
                            }
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 3: successfully started");
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 3: trigger3ActivityHappened.value = false (reset)");
                            KubernetesUsageMonitor.access$getRelatedActivityHappened$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                            i = 1;
lbl12:
                            // 2 sources

                            while (i < 4) {
                                this.I$0 = i;
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl25
                            }
                            break;
                        }
                        case 1: {
                            i = this.I$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl25:
                            // 2 sources

                            if (!((Boolean)KubernetesUsageMonitor.access$getRelatedActivityHappened$p(this.this$0).getValue()).booleanValue()) {
                                KubernetesUsageMonitor.access$getRelatedActivityObserverStarted$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                                DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 3: finished by timeout (no activity at round " + i + ")");
                                return Unit.INSTANCE;
                            }
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 3: passed round " + i + ". Reset activity flag.");
                            KubernetesUsageMonitor.access$getRelatedActivityHappened$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                            ++i;
                            ** GOTO lbl12
                        }
                    }
                    KubernetesUsageMonitor.access$getRelatedActivityObserverStarted$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                    DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 3: finish. call allowShowingSurveyAndCancelMonitoring()");
                    DebugInKubernetesSurveyStore.access$allowShowingSurveyAndCancelMonitoring(this.this$1);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ MutableStateFlow access$getRelatedActivityObserverStarted$p(KubernetesUsageMonitor $this) {
            return $this.relatedActivityObserverStarted;
        }

        public static final /* synthetic */ MutableStateFlow access$getRelatedActivityHappened$p(KubernetesUsageMonitor $this) {
            return $this.relatedActivityHappened;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$MyPersistentState;", "", "canShowSurvey", "", "telepresenceUsageMonitorTimerStarted", "<init>", "(ZZ)V", "getCanShowSurvey", "()Z", "setCanShowSurvey", "(Z)V", "getTelepresenceUsageMonitorTimerStarted", "setTelepresenceUsageMonitorTimerStarted", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.clouds.kubernetes"})
    public static final class MyPersistentState {
        private boolean canShowSurvey;
        private boolean telepresenceUsageMonitorTimerStarted;

        public MyPersistentState(boolean canShowSurvey, boolean telepresenceUsageMonitorTimerStarted) {
            this.canShowSurvey = canShowSurvey;
            this.telepresenceUsageMonitorTimerStarted = telepresenceUsageMonitorTimerStarted;
        }

        public /* synthetic */ MyPersistentState(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public final boolean getCanShowSurvey() {
            return this.canShowSurvey;
        }

        public final void setCanShowSurvey(boolean bl) {
            this.canShowSurvey = bl;
        }

        public final boolean getTelepresenceUsageMonitorTimerStarted() {
            return this.telepresenceUsageMonitorTimerStarted;
        }

        public final void setTelepresenceUsageMonitorTimerStarted(boolean bl) {
            this.telepresenceUsageMonitorTimerStarted = bl;
        }

        public final boolean component1() {
            return this.canShowSurvey;
        }

        public final boolean component2() {
            return this.telepresenceUsageMonitorTimerStarted;
        }

        @NotNull
        public final MyPersistentState copy(boolean canShowSurvey, boolean telepresenceUsageMonitorTimerStarted) {
            return new MyPersistentState(canShowSurvey, telepresenceUsageMonitorTimerStarted);
        }

        public static /* synthetic */ MyPersistentState copy$default(MyPersistentState myPersistentState, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = myPersistentState.canShowSurvey;
            }
            if ((n & 2) != 0) {
                bl2 = myPersistentState.telepresenceUsageMonitorTimerStarted;
            }
            return myPersistentState.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "MyPersistentState(canShowSurvey=" + this.canShowSurvey + ", telepresenceUsageMonitorTimerStarted=" + this.telepresenceUsageMonitorTimerStarted + ")";
        }

        public int hashCode() {
            int result2 = Boolean.hashCode(this.canShowSurvey);
            result2 = result2 * 31 + Boolean.hashCode(this.telepresenceUsageMonitorTimerStarted);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyPersistentState)) {
                return false;
            }
            MyPersistentState myPersistentState = (MyPersistentState)other;
            if (this.canShowSurvey != myPersistentState.canShowSurvey) {
                return false;
            }
            return this.telepresenceUsageMonitorTimerStarted == myPersistentState.telepresenceUsageMonitorTimerStarted;
        }

        public MyPersistentState() {
            this(false, false, 3, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rR\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$TelepresenceUsageMonitor;", "", "<init>", "(Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore;)V", "timerJob", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/coroutines/Job;", "timerStarted", "", "firstProjectOpened", "stateLoaded", "isTimerStarted", "timerStartedStateLoaded", "", "projectOpened", "telepresenceWasConnected", "telepresenceWasDisconnected", "intellij.clouds.kubernetes"})
    private final class TelepresenceUsageMonitor {
        @NotNull
        private MutableStateFlow<Job> timerJob = StateFlowKt.MutableStateFlow(null);
        @NotNull
        private MutableStateFlow<Boolean> timerStarted = StateFlowKt.MutableStateFlow((Object)false);
        private boolean firstProjectOpened;
        private boolean stateLoaded;

        public final boolean isTimerStarted() {
            return (Boolean)this.timerStarted.getValue();
        }

        public final void timerStartedStateLoaded(boolean timerStarted) {
            if (this.stateLoaded) {
                return;
            }
            this.stateLoaded = true;
            this.timerStarted.setValue((Object)timerStarted);
        }

        public final void projectOpened() {
            if (this.firstProjectOpened) {
                return;
            }
            this.firstProjectOpened = true;
            if (((Boolean)this.timerStarted.getValue()).booleanValue()) {
                DebugInKubernetesSurveyStore.this.allowShowingSurveyAndCancelMonitoring();
            }
        }

        public final void telepresenceWasConnected() {
            BuildersKt.launch$default((CoroutineScope)DebugInKubernetesSurveyStore.this.monitoringScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ TelepresenceUsageMonitor this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Job nextValue$iv;
                            Object prevValue$iv;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$launch = (CoroutineScope)this.L$0;
                            boolean canStart = TelepresenceUsageMonitor.access$getTimerStarted$p(this.this$0).compareAndSet((Object)Boxing.boxBoolean((boolean)false), (Object)Boxing.boxBoolean((boolean)true));
                            if (!canStart) {
                                return Unit.INSTANCE;
                            }
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 1: successfully started");
                            Job newJob2 = BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ TelepresenceUsageMonitor this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object invokeSuspend(Object var1_1) {
                                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            this.label = 1;
                                            v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                            if (v0 == var2_2) {
                                                return var2_2;
                                            }
                                            ** GOTO lbl14
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
lbl14:
                                            // 2 sources

                                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 1: finished by timeout");
                                            TelepresenceUsageMonitor.access$getTimerStarted$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null);
                            MutableStateFlow $this$getAndUpdate$iv = TelepresenceUsageMonitor.access$getTimerJob$p(this.this$0);
                            boolean $i$f$getAndUpdate = false;
                            do {
                                prevValue$iv = $this$getAndUpdate$iv.getValue();
                                Job cfr_ignored_0 = (Job)prevValue$iv;
                                boolean bl = false;
                            } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = newJob2)));
                            Job oldJob = (Job)prevValue$iv;
                            if (oldJob != null) {
                                DebugInKubernetesSurveyStore.access$getLOG$cp().error("monitor1: timer job variable was not empty while creating a new one timer. Cancelling the old one.");
                                Job.DefaultImpls.cancel$default((Job)oldJob, null, (int)1, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public final void telepresenceWasDisconnected() {
            BuildersKt.launch$default((CoroutineScope)DebugInKubernetesSurveyStore.this.monitoringScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, DebugInKubernetesSurveyStore.this, null){
                int label;
                final /* synthetic */ TelepresenceUsageMonitor this$0;
                final /* synthetic */ DebugInKubernetesSurveyStore this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 1: telepresenceWasDisconnected() called");
                            if (((Boolean)TelepresenceUsageMonitor.access$getTimerStarted$p(this.this$0).getValue()).booleanValue()) {
                                Object nextValue$iv;
                                Object prevValue$iv;
                                DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 1: telepresenceWasDisconnected: call allowShowingSurveyAndCancelMonitoring()");
                                DebugInKubernetesSurveyStore.access$allowShowingSurveyAndCancelMonitoring(this.this$1);
                                DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 1: clearing timers and flags");
                                MutableStateFlow $this$getAndUpdate$iv = TelepresenceUsageMonitor.access$getTimerJob$p(this.this$0);
                                boolean $i$f$getAndUpdate = false;
                                do {
                                    prevValue$iv = $this$getAndUpdate$iv.getValue();
                                    Job cfr_ignored_0 = (Job)prevValue$iv;
                                    boolean bl = false;
                                } while (!$this$getAndUpdate$iv.compareAndSet(prevValue$iv, nextValue$iv = null));
                                Job job2 = (Job)prevValue$iv;
                                if (job2 != null) {
                                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                                }
                                TelepresenceUsageMonitor.access$getTimerStarted$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ MutableStateFlow access$getTimerStarted$p(TelepresenceUsageMonitor $this) {
            return $this.timerStarted;
        }

        public static final /* synthetic */ MutableStateFlow access$getTimerJob$p(TelepresenceUsageMonitor $this) {
            return $this.timerJob;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore$TelepresenceWithFollowingKubernetesUsageMonitor;", "", "<init>", "(Lcom/intellij/kubernetes/debug/survey/DebugInKubernetesSurveyStore;)V", "relatedActivityObserverStarted", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "relatedActivityHappened", "", "telepresenceWasConnected", "intellij.clouds.kubernetes"})
    private final class TelepresenceWithFollowingKubernetesUsageMonitor {
        @NotNull
        private MutableStateFlow<Boolean> relatedActivityObserverStarted = StateFlowKt.MutableStateFlow((Object)false);
        @NotNull
        private MutableStateFlow<Boolean> relatedActivityHappened = StateFlowKt.MutableStateFlow((Object)false);

        public final void relatedActivityHappened() {
            this.relatedActivityHappened.setValue((Object)true);
        }

        public final void telepresenceWasConnected() {
            BuildersKt.launch$default((CoroutineScope)DebugInKubernetesSurveyStore.this.monitoringScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, DebugInKubernetesSurveyStore.this, null){
                int I$0;
                int label;
                final /* synthetic */ TelepresenceWithFollowingKubernetesUsageMonitor this$0;
                final /* synthetic */ DebugInKubernetesSurveyStore this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            canStart = TelepresenceWithFollowingKubernetesUsageMonitor.access$getRelatedActivityObserverStarted$p(this.this$0).compareAndSet((Object)Boxing.boxBoolean((boolean)false), (Object)Boxing.boxBoolean((boolean)true));
                            if (!canStart) {
                                return Unit.INSTANCE;
                            }
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 2: successfully started");
                            i = 1;
lbl10:
                            // 2 sources

                            while (i < 11) {
                                this.I$0 = i;
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                                if (v0 == var4_2) {
                                    return var4_2;
                                }
                                ** GOTO lbl23
                            }
                            break;
                        }
                        case 1: {
                            i = this.I$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            if (!((Boolean)TelepresenceWithFollowingKubernetesUsageMonitor.access$getRelatedActivityHappened$p(this.this$0).getValue()).booleanValue()) {
                                TelepresenceWithFollowingKubernetesUsageMonitor.access$getRelatedActivityObserverStarted$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                                DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 2: finished by timeout (no activity at round " + i + ")");
                                return Unit.INSTANCE;
                            }
                            DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 2: passed round " + i + ". Reset activity flag.");
                            TelepresenceWithFollowingKubernetesUsageMonitor.access$getRelatedActivityHappened$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                            ++i;
                            ** GOTO lbl10
                        }
                    }
                    TelepresenceWithFollowingKubernetesUsageMonitor.access$getRelatedActivityObserverStarted$p(this.this$0).setValue((Object)Boxing.boxBoolean((boolean)false));
                    DebugInKubernetesSurveyStore.access$getLOG$cp().trace("monitor 2: finish. call allowShowingSurveyAndCancelMonitoring()");
                    DebugInKubernetesSurveyStore.access$allowShowingSurveyAndCancelMonitoring(this.this$1);
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public static final /* synthetic */ MutableStateFlow access$getRelatedActivityObserverStarted$p(TelepresenceWithFollowingKubernetesUsageMonitor $this) {
            return $this.relatedActivityObserverStarted;
        }

        public static final /* synthetic */ MutableStateFlow access$getRelatedActivityHappened$p(TelepresenceWithFollowingKubernetesUsageMonitor $this) {
            return $this.relatedActivityHappened;
        }
    }
}

