/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.RemoteHelmDependencyRepository;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.dto.HubChartDto;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.helm.model.SimpleKeyValueInsertHandler;
import com.intellij.kubernetes.helm.model.WebLinkMetaClass;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.intentions.HelmAddRepositoryAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/helm/model/RepositoryMetaClass;", "Lcom/intellij/kubernetes/helm/model/WebLinkMetaClass;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/RepositoryMetaClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,585:1\n1#2:586\n31#3,2:587\n31#3,2:589\n31#3,2:591\n1863#4,2:593\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/RepositoryMetaClass\n*L\n449#1:587,2\n464#1:589,2\n482#1:591,2\n497#1:593,2\n*E\n"})
public final class RepositoryMetaClass
extends WebLinkMetaClass {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RepositoryMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(def);
    }

    @Override
    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        String $this$getReferencesFromValue_u24lambda_u240 = YamlUtilKt.getEffectiveText((YAMLValue)valueScalar);
        boolean bl = false;
        return StringsKt.startsWith$default((String)$this$getReferencesFromValue_u24lambda_u240, (String)"alias:", (boolean)false, (int)2, null) | StringsKt.startsWith$default((String)$this$getReferencesFromValue_u24lambda_u240, (String)"@", (boolean)false, (int)2, null) ? new PsiReference[]{} : super.getReferencesFromValue(valueScalar);
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Project project = scalarValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        RemoteHelmDependencyRepository remoteHelmDependencyRepository = HelmDependencyRepository.Companion.getRemote(project, YamlUtilKt.getEffectiveText((YAMLValue)scalarValue));
        if (remoteHelmDependencyRepository == null) {
            return;
        }
        RemoteHelmDependencyRepository helmRepository = remoteHelmDependencyRepository;
        if (helmRepository.getAlias() != null) {
            Project project2 = holder.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            Object[] $this$service$iv = (Object[])project2;
            boolean $i$f$service = false;
            Class<HelmIndex> serviceClass$iv = HelmIndex.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            if (((HelmIndex)object).getAddedRepos() != null && helmRepository.getOrFindUrl() == null) {
                $this$service$iv = new Object[]{helmRepository.getAlias()};
                String string = KubernetesBundle.message("HelmChartUnknownValuesInspection.cannot.find.added.repository.name.message", $this$service$iv);
                $this$service$iv = new LocalQuickFix[]{new HelmAddRepositoryAction(helmRepository)};
                holder.registerProblem((PsiElement)scalarValue, string, ProblemHighlightType.WARNING, (LocalQuickFix[])$this$service$iv);
            }
        } else if (helmRepository.getSpecifiedUrl() != null) {
            Url parsedUrl;
            Url url = parsedUrl = Urls.parse((String)helmRepository.getSpecifiedUrl(), (boolean)false);
            if (!Intrinsics.areEqual((Object)(url != null ? url.getScheme() : null), (Object)"file")) {
                Url url2 = parsedUrl;
                CharSequence $i$f$service = url2 != null ? url2.getAuthority() : null;
                if ($i$f$service == null || StringsKt.isBlank((CharSequence)$i$f$service)) {
                    holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("HelmChartUnknownValuesInspection.invalid.repository.url.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                } else {
                    Project project3 = holder.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                    ComponentManager $this$service$iv = (ComponentManager)project3;
                    boolean $i$f$service2 = false;
                    Class<HelmIndex> serviceClass$iv = HelmIndex.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    Collection<HubRepoDto> addedRepos = ((HelmIndex)object).getAddedRepos();
                    if (addedRepos != null) {
                        Object v10;
                        block13: {
                            Iterable iterable = addedRepos;
                            for (Object t : iterable) {
                                HubRepoDto it = (HubRepoDto)t;
                                boolean bl = false;
                                String string = it.getUrl();
                                if (!(string == null ? false : Intrinsics.areEqual((Object)StringUtil.trimEnd((String)string, (char)'/'), (Object)helmRepository.getSpecifiedUrl()))) continue;
                                v10 = t;
                                break block13;
                            }
                            v10 = null;
                        }
                        if (v10 == null) {
                            Object[] objectArray = new Object[]{helmRepository.getSpecifiedUrl()};
                            String string = KubernetesBundle.message("HelmChartUnknownValuesInspection.cannot.find.added.repository.url.message", objectArray);
                            objectArray = new LocalQuickFix[]{new HelmAddRepositoryAction(helmRepository)};
                            holder.registerProblem((PsiElement)scalarValue, string, ProblemHighlightType.WARNING, (LocalQuickFix[])objectArray);
                        }
                    }
                }
            }
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar scalarValue, @Nullable CompletionContext completionContext) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Object object = ActionsKt.runReadAction(() -> RepositoryMetaClass.getValueLookups$lambda$2(scalarValue));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Project project = (Project)object;
        Callable<List> callable = () -> RepositoryMetaClass.getValueLookups$lambda$7(project);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Object object2 = ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"runWithCheckCanceled(...)");
        return (List)object2;
    }

    private static final Project getValueLookups$lambda$2(YAMLScalar $scalarValue) {
        return $scalarValue.getProject();
    }

    private static final HubRepoDto getValueLookups$lambda$7$lambda$3(HubChartDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRepository();
    }

    private static final boolean getValueLookups$lambda$7$lambda$4(HubRepoDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUrl() != null;
    }

    private static final LookupElementBuilder getValueLookups$lambda$7$lambda$5(HubRepoDto it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getUrl();
        Intrinsics.checkNotNull((Object)string);
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)string);
        String string2 = it.getName();
        if (string2 == null) {
            string2 = "";
        }
        return lookupElementBuilder.withLookupString(string2).withPresentableText(it.getUrl()).withTypeText(it.getName()).withInsertHandler((InsertHandler)Companion.RepositoryInsertHandler.INSTANCE);
    }

    private static final List getValueLookups$lambda$7(Project $project) {
        List result2;
        block3: {
            ComponentManager $this$service$iv = (ComponentManager)$project;
            boolean $i$f$service = false;
            Class<HelmIndex> serviceClass$iv = HelmIndex.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            HelmIndex helmIndex = (HelmIndex)object;
            result2 = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)helmIndex.getAllCharts()), RepositoryMetaClass::getValueLookups$lambda$7$lambda$3)), RepositoryMetaClass::getValueLookups$lambda$7$lambda$4), RepositoryMetaClass::getValueLookups$lambda$7$lambda$5));
            Collection<HubRepoDto> collection = helmIndex.getAddedRepos();
            if (collection == null) break block3;
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HubRepoDto it = (HubRepoDto)element$iv;
                boolean bl = false;
                String string = it.getUrl();
                Intrinsics.checkNotNull((Object)string);
                LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)string);
                String string2 = it.getName();
                if (string2 == null) {
                    string2 = "";
                }
                result2.add(lookupElementBuilder.withLookupString(string2).withPresentableText(it.getUrl()).withTypeText(it.getName()).withInsertHandler((InsertHandler)Companion.RepositoryInsertHandler.INSTANCE));
                result2.add(LookupElementBuilder.create((String)("alias:" + it.getName())).withTypeText(it.getUrl()).withInsertHandler((InsertHandler)Companion.RepositoryInsertHandler.INSTANCE));
                result2.add(LookupElementBuilder.create((String)("@" + it.getName())).withTypeText(it.getUrl()).withInsertHandler((InsertHandler)Companion.RepositoryInsertHandler.INSTANCE));
            }
        }
        return result2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/kubernetes/helm/model/RepositoryMetaClass$Companion;", "", "<init>", "()V", "RepositoryInsertHandler", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/helm/model/RepositoryMetaClass$Companion$RepositoryInsertHandler;", "Lcom/intellij/kubernetes/helm/model/SimpleKeyValueInsertHandler;", "<init>", "()V", "getInsertString", "", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "intellij.clouds.kubernetes"})
        @SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/RepositoryMetaClass$Companion$RepositoryInsertHandler\n+ 2 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,585:1\n53#2:586\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/RepositoryMetaClass$Companion$RepositoryInsertHandler\n*L\n524#1:586\n*E\n"})
        private static final class RepositoryInsertHandler
        extends SimpleKeyValueInsertHandler {
            @NotNull
            public static final RepositoryInsertHandler INSTANCE = new RepositoryInsertHandler();

            private RepositoryInsertHandler() {
                super("repository");
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public String getInsertString(@NotNull LookupElement item) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                String string = item.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
                String string2 = string;
                String string3 = item.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLookupString(...)");
                boolean condition$iv = StringsKt.startsWith$default((CharSequence)string3, (char)'@', (boolean)false, (int)2, null);
                boolean $i$f$transformIf = false;
                if (condition$iv) {
                    void $this$transformIf$iv;
                    void it = $this$transformIf$iv;
                    boolean bl = false;
                    object = "\"" + (String)it + "\"";
                } else {
                    object = string2;
                }
                return object;
            }
        }
    }
}

