/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.kubernetes.logs.KubernetesAnsiParsingException;
import com.intellij.kubernetes.logs.KubernetesContextLogsTabPanel;
import com.intellij.kubernetes.logs.KubernetesLogAnsiSegmentKt;
import com.intellij.openapi.editor.markup.TextAttributes;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/logs/AnsiSegment;", "", "code", "", "text", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getText", "toLogEntry", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogEntry;", "toLogEntry$intellij_clouds_kubernetes", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes"})
public final class AnsiSegment {
    @NotNull
    private final String code;
    @NotNull
    private final String text;

    public AnsiSegment(@NotNull String code, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.code = code;
        this.text = text;
    }

    @NotNull
    public final String getCode() {
        return this.code;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final KubernetesContextLogsTabPanel.LogEntry toLogEntry$intellij_clouds_kubernetes() {
        ConsoleViewContentType consoleViewContentType;
        try {
            consoleViewContentType = new ConsoleViewContentType("KUBERNETES_LOG_ANSI_CVCT", new TextAttributes(KubernetesLogAnsiSegmentKt.access$ansiToJColor(this.code), null, null, null, 0));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new KubernetesAnsiParsingException(e);
        }
        ConsoleViewContentType contentType = consoleViewContentType;
        return new KubernetesContextLogsTabPanel.LogEntry(this.text, LazyKt.lazy(() -> AnsiSegment.toLogEntry$lambda$0(contentType)), null, null, 12, null);
    }

    @NotNull
    public final String component1() {
        return this.code;
    }

    @NotNull
    public final String component2() {
        return this.text;
    }

    @NotNull
    public final AnsiSegment copy(@NotNull String code, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new AnsiSegment(code, text);
    }

    public static /* synthetic */ AnsiSegment copy$default(AnsiSegment ansiSegment, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = ansiSegment.code;
        }
        if ((n & 2) != 0) {
            string2 = ansiSegment.text;
        }
        return ansiSegment.copy(string, string2);
    }

    @NotNull
    public String toString() {
        return "AnsiSegment(code=" + this.code + ", text=" + this.text + ")";
    }

    public int hashCode() {
        int result2 = this.code.hashCode();
        result2 = result2 * 31 + this.text.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnsiSegment)) {
            return false;
        }
        AnsiSegment ansiSegment = (AnsiSegment)other;
        if (!Intrinsics.areEqual((Object)this.code, (Object)ansiSegment.code)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)ansiSegment.text);
    }

    private static final ConsoleViewContentType toLogEntry$lambda$0(ConsoleViewContentType $contentType) {
        return $contentType;
    }
}

