/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.settings.KubernetesLogsGlobalSettings;
import com.intellij.kubernetes.api.settings.LogHighlightingPattern;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.AnsiSegment;
import com.intellij.kubernetes.logs.KubernetesAnsiParsingException;
import com.intellij.kubernetes.logs.KubernetesContextLog;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.KubernetesContextLogsTabPanel;
import com.intellij.kubernetes.logs.KubernetesLogAnsiSegmentKt;
import com.intellij.kubernetes.logs.KubernetesLogFilterModel;
import com.intellij.kubernetes.logs.KubernetesLogFilterTabKt;
import com.intellij.kubernetes.logs.KubernetesLogPresentationSettings;
import com.intellij.kubernetes.logs.KubernetesLogsPresentableTextBuildersKt;
import com.intellij.kubernetes.logs.MyK8sLogTextFilterField;
import com.intellij.kubernetes.logs.TimeSlice;
import com.intellij.kubernetes.view.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.actions.logs.KubernetesOpenLogsTabActionKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.JBUI;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a3\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f*\u0001\u0018\b\u0000\u0018\u0000 a2\u00020\u00012\u00020\u0002:\u0003_`aB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0016H\u0002J\r\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u0016H\u0016J\r\u0010*\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b+J\r\u0010,\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020)H\u0002J\b\u0010/\u001a\u00020\u0016H\u0002J\r\u00108\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b;J+\u0010A\u001a\u00020\u00162\u0006\u0010B\u001a\u00020C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020F0E2\u0006\u0010G\u001a\u00020'H\u0000\u00a2\u0006\u0002\bHJ\u0006\u0010I\u001a\u00020\u0016J\u0006\u0010J\u001a\u00020\u0016J\u001c\u0010M\u001a\u00020\u00162\f\u0010N\u001a\b\u0012\u0004\u0012\u00020L0EH\u0086@\u00a2\u0006\u0002\u0010OJ&\u0010P\u001a\u00020\u00162\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020L0R2\u0006\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0002J,\u0010W\u001a\u00020\u00162\u0006\u0010X\u001a\u00020T2\u0006\u0010S\u001a\u00020T2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020L0EH\u0082@\u00a2\u0006\u0002\u0010YJ$\u0010Z\u001a\u00020T2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020L0E2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020L0EH\u0002J\u0016\u0010]\u001a\u00020\u00162\f\u0010^\u001a\b\u0012\u0004\u0012\u00020L0EH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020>\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020L0EX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "logsManager", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor$intellij_clouds_kubernetes", "()Lcom/intellij/openapi/editor/Editor;", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument$intellij_clouds_kubernetes", "()Lcom/intellij/openapi/editor/Document;", "setupEditor", "", "createMouseListener", "com/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$createMouseListener$1", "()Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$createMouseListener$1;", "dispose", "textFilterModel", "Lcom/intellij/kubernetes/logs/KubernetesLogFilterModel;", "getTextFilterModel", "()Lcom/intellij/kubernetes/logs/KubernetesLogFilterModel;", "progressBar", "Ljavax/swing/JProgressBar;", "getProgressBar", "()Ljavax/swing/JProgressBar;", "filterPanel", "getFilterPanel", "()Ljavax/swing/JPanel;", "canShowIncompleteLogsPanel", "", "incompleteLogsPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "hideIncompleteLogsPanel", "hideIncompleteLogsPanel$intellij_clouds_kubernetes", "showIncompleteLogsPanel", "showIncompleteLogsPanel$intellij_clouds_kubernetes", "createIncompleteLogsPanel", "navigateToAdvancedSettings", "chevronDownAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getChevronDownAction", "()Lcom/intellij/openapi/actionSystem/AnAction;", "textTimeSliceLabel", "Lcom/intellij/ui/components/JBLabel;", "sourcesLabel", "timePeriodAndSourceField", "showStreamingLogsText", "showStreamingLogsText$intellij_clouds_kubernetes", "hideLogsStreamingProgressStatusText", "hideLogsStreamingProgressStatusText$intellij_clouds_kubernetes", "chevronTextLabel", "textFilterField", "Lcom/intellij/kubernetes/logs/MyK8sLogTextFilterField;", "getTextFilterField", "()Lcom/intellij/kubernetes/logs/MyK8sLogTextFilterField;", "updateTimePeriodAndSourcesFields", "timeSlice", "Lcom/intellij/kubernetes/logs/TimeSlice;", "sources", "", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "addEvents", "updateTimePeriodAndSourcesFields$intellij_clouds_kubernetes", "showProgressBar", "hideProgressBar", "lastLogs", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogLineEntry;", "updateTextAndHighlighting", "logsList", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "highlightLogEntries", "newCachedLogs", "", "commonPrefix", "", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "removeAndReplaceLogTextWriteAction", "endDropOffset", "(IILjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findCommonPrefix", "logs1", "logs2", "clearOldHighlighting", "logLines", "LogEntry", "LogLineEntry", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogFilterTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogFilterTab.kt\ncom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,726:1\n1485#2:727\n1510#2,3:728\n1513#2,3:738\n1062#2:741\n1368#2:743\n1454#2,5:744\n1368#2:751\n1454#2,5:752\n381#3,7:731\n1#4:742\n14#5:749\n14#5:750\n*S KotlinDebug\n*F\n+ 1 KubernetesLogFilterTab.kt\ncom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel\n*L\n253#1:727\n253#1:728,3\n253#1:738,3\n255#1:741\n306#1:743\n306#1:744,5\n351#1:751\n351#1:752,5\n253#1:731,7\n308#1:749\n318#1:750\n*E\n"})
public final class KubernetesContextLogsTabPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final KubernetesContextLogsManager logsManager;
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Document document;
    @NotNull
    private final KubernetesLogFilterModel textFilterModel;
    @NotNull
    private final JProgressBar progressBar;
    @NotNull
    private final JPanel filterPanel;
    private boolean canShowIncompleteLogsPanel;
    @NotNull
    private final EditorNotificationPanel incompleteLogsPanel;
    @NotNull
    private final AnAction chevronDownAction;
    @NotNull
    private final JBLabel textTimeSliceLabel;
    @NotNull
    private final JBLabel sourcesLabel;
    @NotNull
    private final JPanel timePeriodAndSourceField;
    @NotNull
    private final JBLabel chevronTextLabel;
    @NotNull
    private final MyK8sLogTextFilterField textFilterField;
    @NotNull
    private List<LogLineEntry> lastLogs;
    @NotNull
    private static final Key<HyperlinkInfo> HYPERLINK_INFO_KEY;
    private static final ConsoleViewContentType NORMAL_OUTPUT;
    @NotNull
    private static final ConsoleViewContentType TIMESTAMP_CONTENT_TYPE;
    @NotNull
    private static final ConsoleViewContentType SOURCE_CONTENT_TYPE;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_NORMAL;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_SOURCE;
    @NotNull
    private static final Lazy<ConsoleViewContentType> LAZY_TIMESTAMP;
    @NotNull
    private static final LogEntry OPENING_BRACKET_ENTRY;
    @NotNull
    private static final LogEntry CLOSING_BRACKET_TAB_ENTRY;
    @NotNull
    private static final LogEntry LINE_BREAK_ENTRY;

    /*
     * WARNING - void declaration
     */
    public KubernetesContextLogsTabPanel(@NotNull KubernetesApiModel apiModel2, @NotNull KubernetesContextLogsManager logsManager) {
        JPanel jPanel;
        void $this$chevronTextLabel_u24lambda_u249;
        Object $this$timePeriodAndSourceField_u24lambda_u248;
        Object $this$sourcesLabel_u24lambda_u247;
        Object $this$textTimeSliceLabel_u24lambda_u246;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)logsManager, (String)"logsManager");
        super(new BorderLayout());
        this.apiModel = apiModel2;
        this.logsManager = logsManager;
        this.project = this.apiModel.getProject();
        Object editorFactory = EditorFactory.getInstance();
        this.document = editorFactory.createDocument((CharSequence)"");
        UndoUtil.disableUndoFor((Document)this.document);
        this.editor = editorFactory.createEditor(this.document, this.project);
        this.setupEditor();
        Disposer.register((Disposable)((Disposable)this.logsManager.getApiModel().getApiProvider$intellij_clouds_kubernetes()), (Disposable)this);
        this.textFilterModel = this.logsManager.getFilterModel$intellij_clouds_kubernetes();
        this.progressBar = new JProgressBar();
        this.filterPanel = new JPanel(new BorderLayout());
        this.canShowIncompleteLogsPanel = true;
        this.incompleteLogsPanel = this.createIncompleteLogsPanel();
        editorFactory = AllIcons.General.ChevronDown;
        this.chevronDownAction = new AnAction(this, (Icon)editorFactory){
            final /* synthetic */ KubernetesContextLogsTabPanel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                boolean isVisible = KubernetesContextLogsTabPanel.access$getTimePeriodAndSourceField$p(this.this$0).isVisible();
                KubernetesContextLogsTabPanel.access$getTimePeriodAndSourceField$p(this.this$0).setVisible(!isVisible);
                e.getPresentation().setIcon(isVisible ? AllIcons.General.ChevronDown : AllIcons.General.ChevronUp);
                e.getPresentation().setText(isVisible ? KubernetesBundle.message("k8s.logs.action.show.time.slice.text", new Object[0]) : KubernetesBundle.message("k8s.logs.action.hide.time.slice.text", new Object[0]));
                KubernetesContextLogsTabPanel.access$getTimePeriodAndSourceField$p(this.this$0).repaint();
            }
        };
        Object object = editorFactory = new JBLabel();
        KubernetesContextLogsTabPanel kubernetesContextLogsTabPanel = this;
        boolean bl = false;
        $this$textTimeSliceLabel_u24lambda_u246.setToolTipText(KubernetesBundle.message("k8s.logs.tooltip.shows.current.log.time.period.sources", new Object[0]));
        $this$textTimeSliceLabel_u24lambda_u246.setBorder(JBUI.Borders.empty((int)5));
        $this$textTimeSliceLabel_u24lambda_u246.setVisible(true);
        kubernetesContextLogsTabPanel.textTimeSliceLabel = editorFactory;
        $this$textTimeSliceLabel_u24lambda_u246 = editorFactory = new JBLabel();
        kubernetesContextLogsTabPanel = this;
        boolean bl2 = false;
        $this$sourcesLabel_u24lambda_u247.setToolTipText(KubernetesBundle.message("k8s.logs.tooltip.shows.current.log.sources", new Object[0]));
        $this$sourcesLabel_u24lambda_u247.setBorder(JBUI.Borders.empty((int)5));
        $this$sourcesLabel_u24lambda_u247.setText(KubernetesBundle.message("k8s.logs.label.sources.not.available", new Object[0]));
        $this$sourcesLabel_u24lambda_u247.setVisible(true);
        kubernetesContextLogsTabPanel.sourcesLabel = editorFactory;
        $this$sourcesLabel_u24lambda_u247 = editorFactory = new JPanel(new BorderLayout());
        kubernetesContextLogsTabPanel = this;
        boolean bl3 = false;
        $this$timePeriodAndSourceField_u24lambda_u248.setVisible(false);
        $this$timePeriodAndSourceField_u24lambda_u248.add((Component)new JSeparator(), "North");
        $this$timePeriodAndSourceField_u24lambda_u248.add((Component)this.textTimeSliceLabel, "West");
        $this$timePeriodAndSourceField_u24lambda_u248.add((Component)this.sourcesLabel, "Center");
        kubernetesContextLogsTabPanel.timePeriodAndSourceField = editorFactory;
        $this$timePeriodAndSourceField_u24lambda_u248 = editorFactory = new JBLabel(KubernetesBundle.message("k8s.logs.label.streaming.logs", new Object[0]));
        kubernetesContextLogsTabPanel = this;
        boolean $i$a$-apply-KubernetesContextLogsTabPanel$chevronTextLabel$22 = false;
        $this$chevronTextLabel_u24lambda_u249.setVisible(false);
        $this$chevronTextLabel_u24lambda_u249.setToolTipText(KubernetesBundle.message("k8s.logs.tooltip.streaming.filtering.logs.from.cluster", new Object[0]));
        $this$chevronTextLabel_u24lambda_u249.setBorder((Border)JBUI.Borders.empty((int)0, (int)5));
        $this$chevronTextLabel_u24lambda_u249.setForeground((Color)JBColor.GRAY);
        kubernetesContextLogsTabPanel.chevronTextLabel = editorFactory;
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup logFiltersActionGroup = new DefaultActionGroup();
        logFiltersActionGroup.add(this.chevronDownAction);
        logFiltersActionGroup.addSeparator();
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Change.Logs.Ordering.Action"));
        Editor $i$a$-apply-KubernetesContextLogsTabPanel$chevronTextLabel$22 = this.editor;
        logFiltersActionGroup.add((AnAction)new ScrollToTheEndToolbarAction($i$a$-apply-KubernetesContextLogsTabPanel$chevronTextLabel$22){

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.getEditor$intellij_clouds_kubernetes().getScrollingModel().scrollVertically(this.getEditor$intellij_clouds_kubernetes().getDocument().getText().length());
            }
        });
        $i$a$-apply-KubernetesContextLogsTabPanel$chevronTextLabel$22 = SoftWrapAppliancePlaces.MAIN_EDITOR;
        logFiltersActionGroup.add((AnAction)new ToggleUseSoftWrapsToolbarAction((SoftWrapAppliancePlaces)$i$a$-apply-KubernetesContextLogsTabPanel$chevronTextLabel$22){

            protected Editor getEditor(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.getEditor$intellij_clouds_kubernetes();
            }
        });
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Download.Filtered.Context.Logs.Action"));
        logFiltersActionGroup.addSeparator();
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Open.Pattern.Matching.Action"));
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Change.Logs.Sources"));
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Select.Date.Time.Action"));
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Edit.Log.Columns.Action"));
        logFiltersActionGroup.addSeparator();
        logFiltersActionGroup.add(actionManager.getAction("Kubernetes.Logs.Clear.Logs.Filters.Action"));
        ActionToolbar actionToolbar = actionManager.createActionToolbar(KubernetesLogFilterTabKt.getLogActionsToolbarPlaceName(), (ActionGroup)logFiltersActionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionsToolbar = actionToolbar;
        actionsToolbar.setTargetComponent((JComponent)this);
        this.textFilterField = KubernetesLogFilterTabKt.buildLogsFilterField(this.textFilterModel, this.logsManager);
        JComponent filter2 = (JComponent)new Wrapper(this.textFilterField.getComponent());
        filter2.getAccessibleContext().setAccessibleName(KubernetesBundle.message("k8s.logs.filter.logs.text", new Object[0]));
        this.progressBar.setIndeterminate(true);
        this.progressBar.setPreferredSize(new Dimension(this.getWidth(), 3));
        this.progressBar.setBackground((Color)Gray._238);
        this.progressBar.setForeground((Color)new JBColor(new Color(0, 122, 204), new Color(0, 122, 204)));
        this.progressBar.setBorder((Border)JBUI.Borders.empty());
        this.progressBar.setVisible(false);
        this.progressBar.setToolTipText(KubernetesBundle.message("k8s.logs.label.streaming.logs", new Object[0]));
        this.filterPanel.add((Component)actionsToolbar.getComponent(), "West");
        this.filterPanel.add((Component)filter2, "Center");
        this.filterPanel.add((Component)this.incompleteLogsPanel, "North");
        this.filterPanel.add((Component)this.chevronTextLabel, "East");
        JPanel $this$_init__u24lambda_u2410 = jPanel = new JPanel(new BorderLayout());
        boolean bl4 = false;
        $this$_init__u24lambda_u2410.add((Component)this.filterPanel, "North");
        $this$_init__u24lambda_u2410.add((Component)this.timePeriodAndSourceField, "Center");
        $this$_init__u24lambda_u2410.add((Component)this.progressBar, "South");
        JPanel toolbarPanel = jPanel;
        this.add((Component)toolbarPanel, "North");
        BuildersKt.launch$default((CoroutineScope)this.logsManager.getCoroutineScope$intellij_clouds_kubernetes(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ KubernetesContextLogsTabPanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.logsManager.getStreamingLogsStatusFlow$intellij_clouds_kubernetes()), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ boolean Z$0;
                            final /* synthetic */ KubernetesContextLogsTabPanel this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        boolean isLoading = this.Z$0;
                                        if (isLoading) {
                                            this.this$0.showProgressBar();
                                            this.this$0.showStreamingLogsText$intellij_clouds_kubernetes();
                                        } else {
                                            this.this$0.hideProgressBar();
                                            this.this$0.hideLogsStreamingProgressStatusText$intellij_clouds_kubernetes();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.Z$0 = (Boolean)value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.lastLogs = CollectionsKt.emptyList();
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    @NotNull
    public final Editor getEditor$intellij_clouds_kubernetes() {
        return this.editor;
    }

    @NotNull
    public final Document getDocument$intellij_clouds_kubernetes() {
        return this.document;
    }

    private final void setupEditor() {
        Editor editor = this.editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl $this$setupEditor_u24lambda_u240 = (EditorImpl)editor;
        boolean bl = false;
        $this$setupEditor_u24lambda_u240.getSettings().setLineNumbersShown(false);
        $this$setupEditor_u24lambda_u240.getGutterComponentEx().setPaintBackground(false);
        $this$setupEditor_u24lambda_u240.setViewer(true);
        $this$setupEditor_u24lambda_u240.getContentComponent().addMouseListener((MouseListener)this.createMouseListener());
        this.add((Component)$this$setupEditor_u24lambda_u240.getComponent(), "Center");
    }

    private final createMouseListener.1 createMouseListener() {
        return new MouseAdapter(this){
            final /* synthetic */ KubernetesContextLogsTabPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Point point = e.getPoint();
                LogicalPosition logicalPosition = this.this$0.getEditor$intellij_clouds_kubernetes().xyToLogicalPosition(point);
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
                LogicalPosition logicalPosition2 = logicalPosition;
                int offset = this.this$0.getEditor$intellij_clouds_kubernetes().logicalPositionToOffset(logicalPosition2);
                RangeHighlighter[] rangeHighlighterArray = DocumentMarkupModel.forDocument((Document)this.this$0.getDocument$intellij_clouds_kubernetes(), (Project)KubernetesContextLogsTabPanel.access$getProject$p(this.this$0), (boolean)false).getAllHighlighters();
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
                for (RangeHighlighter rangeHighlighter : rangeHighlighterArray) {
                    Intrinsics.checkNotNull((Object)rangeHighlighter);
                    RangeHighlighter highlighter = rangeHighlighter;
                    if (highlighter.getStartOffset() > offset || highlighter.getEndOffset() < offset) continue;
                    HyperlinkInfo hyperlinkInfo2 = (HyperlinkInfo)highlighter.getUserData(KubernetesContextLogsTabPanel.Companion.getHYPERLINK_INFO_KEY$intellij_clouds_kubernetes());
                    if (hyperlinkInfo2 == null) break;
                    hyperlinkInfo2.navigate(KubernetesContextLogsTabPanel.access$getProject$p(this.this$0));
                    break;
                }
            }
        };
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> KubernetesContextLogsTabPanel.dispose$lambda$1(this));
    }

    @NotNull
    public final KubernetesLogFilterModel getTextFilterModel() {
        return this.textFilterModel;
    }

    @NotNull
    public final JProgressBar getProgressBar() {
        return this.progressBar;
    }

    @NotNull
    public final JPanel getFilterPanel() {
        return this.filterPanel;
    }

    public final void hideIncompleteLogsPanel$intellij_clouds_kubernetes() {
        this.incompleteLogsPanel.setVisible(false);
    }

    public final void showIncompleteLogsPanel$intellij_clouds_kubernetes() {
        if (!this.canShowIncompleteLogsPanel) {
            return;
        }
        this.incompleteLogsPanel.setVisible(true);
    }

    private final EditorNotificationPanel createIncompleteLogsPanel() {
        EditorNotificationPanel editorNotificationPanel;
        EditorNotificationPanel $this$createIncompleteLogsPanel_u24lambda_u245 = editorNotificationPanel = new EditorNotificationPanel(EditorColors.GUTTER_BACKGROUND, EditorNotificationPanel.Status.Warning);
        boolean bl = false;
        $this$createIncompleteLogsPanel_u24lambda_u245.createActionLabel(KubernetesBundle.message("k8s.logs.large.logs.notification.panel.action.label.download", new Object[0]), () -> KubernetesContextLogsTabPanel.createIncompleteLogsPanel$lambda$5$lambda$2(this));
        $this$createIncompleteLogsPanel_u24lambda_u245.createActionLabel(EditorBundle.message((String)"notification.hide.message", (Object[])new Object[0]), () -> KubernetesContextLogsTabPanel.createIncompleteLogsPanel$lambda$5$lambda$3(this));
        $this$createIncompleteLogsPanel_u24lambda_u245.createActionLabel(KubernetesBundle.message("k8s.logs.link.label.settings", new Object[0]), () -> KubernetesContextLogsTabPanel.createIncompleteLogsPanel$lambda$5$lambda$4(this));
        $this$createIncompleteLogsPanel_u24lambda_u245.setText(KubernetesBundle.message("k8s.logs.large.logs.warning.panel.html.text", new Object[0]));
        $this$createIncompleteLogsPanel_u24lambda_u245.setVisible(false);
        return editorNotificationPanel;
    }

    private final void navigateToAdvancedSettings() {
        ShowSettingsUtil.getInstance().showSettingsDialog(this.project, KubernetesBundle.message("configurable.name.kubernetes", new Object[0]));
    }

    @NotNull
    public final AnAction getChevronDownAction() {
        return this.chevronDownAction;
    }

    public final void showStreamingLogsText$intellij_clouds_kubernetes() {
        this.chevronTextLabel.setVisible(true);
    }

    public final void hideLogsStreamingProgressStatusText$intellij_clouds_kubernetes() {
        this.chevronTextLabel.setVisible(false);
    }

    @NotNull
    public final MyK8sLogTextFilterField getTextFilterField() {
        return this.textFilterField;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTimePeriodAndSourcesFields$intellij_clouds_kubernetes(@NotNull TimeSlice timeSlice, @NotNull List<? extends KubernetesContainerObject> sources, boolean addEvents) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)timeSlice, (String)"timeSlice");
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        this.textTimeSliceLabel.setText(KubernetesLogsPresentableTextBuildersKt.getTimeSliceHtmlDescription(timeSlice));
        Iterable $this$groupBy$iv = sources;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            KubernetesContainerObject container = (KubernetesContainerObject)element$iv$iv;
            boolean bl = false;
            Object object2 = container.getParentPod().getMetadata();
            if (object2 == null || (object2 = ((V1ObjectMeta)object2).getName()) == null) {
                object2 = "Unknown Pod";
            }
            Object key$iv$iv = object2;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedByDescending$iv = MapsKt.toList((Map)destination$iv$iv);
        boolean $i$f$sortedByDescending = false;
        List podsByName = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((List)it.getSecond()).size());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((List)it.getSecond()).size()));
            }
        });
        String formattedSources = KubernetesLogsPresentableTextBuildersKt.getFormattedSourcesHtml(podsByName, addEvents);
        this.sourcesLabel.setText(formattedSources);
        this.timePeriodAndSourceField.repaint();
    }

    public final void showProgressBar() {
        this.progressBar.setVisible(true);
    }

    public final void hideProgressBar() {
        this.progressBar.setVisible(false);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public final Object updateTextAndHighlighting(@NotNull List<LogLineEntry> var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateTextAndHighlighting.1)) ** GOTO lbl-1000
        var19_3 = $completion;
        if ((var19_3.label & -2147483648) != 0) {
            var19_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ KubernetesContextLogsTabPanel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateTextAndHighlighting(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                markupModel = DocumentMarkupModel.forDocument((Document)this.document, (Project)this.apiModel.getProject(), (boolean)false);
                newCachedLogs = CollectionsKt.toMutableList((Collection)logsList);
                var8_8 = CollectionsKt.withIndex((Iterable)this.lastLogs);
                for (T var10_17 : var8_8) {
                    it /* !! */  = (IndexedValue)var10_17;
                    $i$a$-find-KubernetesContextLogsTabPanel$updateTextAndHighlighting$droppedPrefix$1 = false;
                    if (!Intrinsics.areEqual((Object)it /* !! */ .getValue(), (Object)CollectionsKt.firstOrNull((List)logsList))) continue;
                    v0 = var10_17;
                    ** GOTO lbl22
                }
                v0 = null;
lbl22:
                // 2 sources

                v1 = v0;
                droppedPrefix = v1 != null ? v1.getIndex() : 0;
                this.clearOldHighlighting(CollectionsKt.take((Iterable)this.lastLogs, (int)droppedPrefix));
                endDropOffset = this.document.getLineStartOffset(droppedPrefix);
                this.lastLogs = CollectionsKt.drop((Iterable)this.lastLogs, (int)droppedPrefix);
                commonPrefix = this.findCommonPrefix(newCachedLogs, this.lastLogs);
                var9_14 = commonPrefix;
                for (index = 0; index < var9_14; ++index) {
                    newCachedLogs.set(index, this.lastLogs.get(index));
                }
                this.clearOldHighlighting(CollectionsKt.drop((Iterable)this.lastLogs, (int)commonPrefix));
                $continuation.L$0 = this;
                $continuation.L$1 = logsList;
                $continuation.L$2 = markupModel;
                $continuation.L$3 = newCachedLogs;
                $continuation.I$0 = commonPrefix;
                $continuation.label = 1;
                v2 = this.removeAndReplaceLogTextWriteAction(endDropOffset, commonPrefix, logsList, (Continuation<? super Unit>)$continuation);
                ** if (v2 != var20_5) goto lbl45
lbl44:
                // 1 sources

                return var20_5;
lbl45:
                // 1 sources

                ** GOTO lbl56
            }
            case 1: {
                commonPrefix = $continuation.I$0;
                newCachedLogs = (List)$continuation.L$3;
                markupModel = (MarkupModel)$continuation.L$2;
                logsList = (List)$continuation.L$1;
                this = (KubernetesContextLogsTabPanel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl56:
                    // 2 sources

                    $this$flatMap$iv = logsList;
                    $i$f$flatMap = false;
                    it /* !! */  = $this$flatMap$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$flatMapTo = false;
                    for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                        it = (LogLineEntry)element$iv$iv;
                        $i$a$-flatMap-KubernetesContextLogsTabPanel$updateTextAndHighlighting$newText$1 = false;
                        list$iv$iv = it.getLogEntries();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    newText = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, updateTextAndHighlighting$lambda$15(com.intellij.kubernetes.logs.KubernetesContextLogsTabPanel$LogEntry ), (Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogEntry;)Ljava/lang/CharSequence;)(), (int)30, null);
                    if (!Intrinsics.areEqual((Object)this.document.getText(), (Object)newText)) {
                        $i$f$logger = false;
                        v3 = Logger.getInstance(KubernetesContextLogsManager.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getInstance(...)");
                        v3.error("Have to be the same");
                        return Unit.INSTANCE;
                    }
                    Intrinsics.checkNotNull((Object)markupModel);
                    this.highlightLogEntries(newCachedLogs, commonPrefix, markupModel);
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    $i$f$logger = false;
                    v4 = Logger.getInstance(LogLineEntry.class);
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getInstance(...)");
                    v4.error((Throwable)e);
                }
                this.lastLogs = newCachedLogs;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void highlightLogEntries(List<LogLineEntry> newCachedLogs, int commonPrefix, MarkupModel markupModel) {
        for (IndexedValue indexedValue : CollectionsKt.drop((Iterable)CollectionsKt.withIndex((Iterable)newCachedLogs), (int)commonPrefix)) {
            int lineIndex = indexedValue.component1();
            LogLineEntry logLine = (LogLineEntry)indexedValue.component2();
            int startOffset = this.document.getLineStartOffset(lineIndex);
            for (LogEntry entry : logLine.getLogEntries()) {
                entry.setHighlighter(markupModel.addRangeHighlighter(startOffset, startOffset + entry.getMessage().length(), 3000, ((ConsoleViewContentType)entry.getContentType().getValue()).getAttributes(), HighlighterTargetArea.EXACT_RANGE));
                if (entry.getHyperlinkInfo() != null) {
                    RangeHighlighter rangeHighlighter = entry.getHighlighter();
                    if (rangeHighlighter != null) {
                        rangeHighlighter.putUserData(HYPERLINK_INFO_KEY, (Object)entry.getHyperlinkInfo());
                    }
                }
                startOffset += entry.getMessage().length();
            }
        }
    }

    private final Object removeAndReplaceLogTextWriteAction(int endDropOffset, int commonPrefix, List<LogLineEntry> logsList, Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.writeAction(() -> KubernetesContextLogsTabPanel.removeAndReplaceLogTextWriteAction$lambda$20(this, commonPrefix, logsList, endDropOffset), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final int findCommonPrefix(List<LogLineEntry> logs1, List<LogLineEntry> logs2) {
        int commonPrefix = 0;
        while (CollectionsKt.getOrNull(logs2, (int)commonPrefix) != null && CollectionsKt.getOrNull(logs1, (int)commonPrefix) != null && Intrinsics.areEqual((Object)CollectionsKt.getOrNull(logs2, (int)commonPrefix), (Object)CollectionsKt.getOrNull(logs1, (int)commonPrefix))) {
            ++commonPrefix;
        }
        return commonPrefix;
    }

    private final void clearOldHighlighting(List<LogLineEntry> logLines) {
        for (LogLineEntry logLine : logLines) {
            for (LogEntry entry : logLine.getLogEntries()) {
                RangeHighlighter rangeHighlighter = entry.getHighlighter();
                if (rangeHighlighter == null) continue;
                rangeHighlighter.dispose();
            }
        }
    }

    private static final void dispose$lambda$1(KubernetesContextLogsTabPanel this$0) {
        EditorFactory.getInstance().releaseEditor(this$0.editor);
    }

    private static final void createIncompleteLogsPanel$lambda$5$lambda$2(KubernetesContextLogsTabPanel this$0) {
        this$0.logsManager.launchDownloadLogs$intellij_clouds_kubernetes();
    }

    private static final void createIncompleteLogsPanel$lambda$5$lambda$3(KubernetesContextLogsTabPanel this$0) {
        this$0.canShowIncompleteLogsPanel = false;
        this$0.hideIncompleteLogsPanel$intellij_clouds_kubernetes();
    }

    private static final void createIncompleteLogsPanel$lambda$5$lambda$4(KubernetesContextLogsTabPanel this$0) {
        this$0.navigateToAdvancedSettings();
    }

    private static final CharSequence updateTextAndHighlighting$lambda$15(LogEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final void removeAndReplaceLogTextWriteAction$lambda$20$lambda$16(KubernetesContextLogsTabPanel this$0, int $endDropOffset) {
        this$0.document.deleteString(0, $endDropOffset);
    }

    private static final CharSequence removeAndReplaceLogTextWriteAction$lambda$20$lambda$18(LogEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getMessage();
    }

    private static final void removeAndReplaceLogTextWriteAction$lambda$20$lambda$19(KubernetesContextLogsTabPanel this$0, Ref.IntRef $commonTextOffset, String $newTextForReplacement) {
        this$0.document.replaceString($commonTextOffset.element, this$0.document.getTextLength(), (CharSequence)$newTextForReplacement);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit removeAndReplaceLogTextWriteAction$lambda$20(KubernetesContextLogsTabPanel this$0, int $commonPrefix, List $logsList, int $endDropOffset) {
        void $this$flatMapTo$iv$iv;
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> KubernetesContextLogsTabPanel.removeAndReplaceLogTextWriteAction$lambda$20$lambda$16(this$0, $endDropOffset), "LogTextPrefixRemoving", (Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        Ref.IntRef commonTextOffset = new Ref.IntRef();
        commonTextOffset.element = this$0.document.getLineStartOffset($commonPrefix);
        Iterable $this$flatMap$iv = CollectionsKt.drop((Iterable)$logsList, (int)$commonPrefix);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            LogLineEntry it = (LogLineEntry)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getLogEntries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        String newTextForReplacement = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, KubernetesContextLogsTabPanel::removeAndReplaceLogTextWriteAction$lambda$20$lambda$18, (int)30, null);
        CommandProcessor.getInstance().executeCommand(this$0.project, () -> KubernetesContextLogsTabPanel.removeAndReplaceLogTextWriteAction$lambda$20$lambda$19(this$0, commonTextOffset, newTextForReplacement), "LogTextReplacement", (Object)UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION);
        return Unit.INSTANCE;
    }

    private static final ConsoleViewContentType LAZY_NORMAL$lambda$21() {
        return NORMAL_OUTPUT;
    }

    private static final ConsoleViewContentType LAZY_SOURCE$lambda$22() {
        return SOURCE_CONTENT_TYPE;
    }

    private static final ConsoleViewContentType LAZY_TIMESTAMP$lambda$23() {
        return TIMESTAMP_CONTENT_TYPE;
    }

    public static final /* synthetic */ Project access$getProject$p(KubernetesContextLogsTabPanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$removeAndReplaceLogTextWriteAction(KubernetesContextLogsTabPanel $this, int endDropOffset, int commonPrefix, List logsList, Continuation $completion) {
        return $this.removeAndReplaceLogTextWriteAction(endDropOffset, commonPrefix, logsList, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ JPanel access$getTimePeriodAndSourceField$p(KubernetesContextLogsTabPanel $this) {
        return $this.timePeriodAndSourceField;
    }

    static {
        Key key = Key.create((String)"HYPERLINK_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HYPERLINK_INFO_KEY = key;
        NORMAL_OUTPUT = ConsoleViewContentType.NORMAL_OUTPUT;
        TIMESTAMP_CONTENT_TYPE = new ConsoleViewContentType("KUBERNETES_TIMESTAMP", new TextAttributes((Color)JBColor.GRAY, null, null, null, 0));
        SOURCE_CONTENT_TYPE = new ConsoleViewContentType("KUBERNETES_SOURCE", new TextAttributes((Color)JBColor.namedColor((String)"Link.activeForeground", (Color)((Color)new JBColor(5807606, 5807606))), null, (Color)JBColor.namedColor((String)"Link.activeForeground", (Color)((Color)new JBColor(5807606, 5807606))), EffectType.LINE_UNDERSCORE, 0));
        LAZY_NORMAL = LazyKt.lazy(KubernetesContextLogsTabPanel::LAZY_NORMAL$lambda$21);
        LAZY_SOURCE = LazyKt.lazy(KubernetesContextLogsTabPanel::LAZY_SOURCE$lambda$22);
        LAZY_TIMESTAMP = LazyKt.lazy(KubernetesContextLogsTabPanel::LAZY_TIMESTAMP$lambda$23);
        OPENING_BRACKET_ENTRY = new LogEntry("(", LAZY_NORMAL, null, null, 12, null);
        CLOSING_BRACKET_TAB_ENTRY = new LogEntry(")\t", LAZY_NORMAL, null, null, 12, null);
        LINE_BREAK_ENTRY = new LogEntry("\n", LAZY_NORMAL, null, null, 12, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ5\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ8\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00152\n\u0010\u0018\u001a\u00060\u0019R\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0014H\u0002J\u001e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u00152\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0014H\u0002R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010#\u001a\n $*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%R\u000e\u0010&\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u0010\u0012\f\u0012\n $*\u0004\u0018\u00010\"0\"0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020\"0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$Companion;", "", "<init>", "()V", "HYPERLINK_INFO_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "getHYPERLINK_INFO_KEY$intellij_clouds_kubernetes", "()Lcom/intellij/openapi/util/Key;", "onContainerHyperlinkClick", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "container", "Lcom/intellij/kubernetes/view/KubernetesContainerObject;", "onEventHyperlinkClick", "buildLogEntriesList", "", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogLineEntry;", "logsList", "", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "presentationSettings", "Lcom/intellij/kubernetes/logs/KubernetesLogPresentationSettings;", "hyperLinkRegistry", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager$HyperLinkCachedCreator;", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsManager;", "buildLogEntriesList$intellij_clouds_kubernetes", "createLogEntry", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogEntry;", "log", "highlighters", "Lcom/intellij/kubernetes/api/settings/LogHighlightingPattern;", "determineContentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "NORMAL_OUTPUT", "kotlin.jvm.PlatformType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "TIMESTAMP_CONTENT_TYPE", "SOURCE_CONTENT_TYPE", "LAZY_NORMAL", "Lkotlin/Lazy;", "LAZY_SOURCE", "LAZY_TIMESTAMP", "OPENING_BRACKET_ENTRY", "CLOSING_BRACKET_TAB_ENTRY", "LINE_BREAK_ENTRY", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesLogFilterTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogFilterTab.kt\ncom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,726:1\n14#2:727\n295#3,2:728\n1#4:730\n*S KotlinDebug\n*F\n+ 1 KubernetesLogFilterTab.kt\ncom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$Companion\n*L\n455#1:727\n475#1:728,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<HyperlinkInfo> getHYPERLINK_INFO_KEY$intellij_clouds_kubernetes() {
            return HYPERLINK_INFO_KEY;
        }

        public final void onContainerHyperlinkClick(@NotNull KubernetesApiModel apiModel2, @NotNull KubernetesContainerObject container) {
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            KubernetesContextLogsManager logManager = new KubernetesContextLogsManager(apiModel2);
            logManager.getCurrentContainers$intellij_clouds_kubernetes().setValue((Object)CollectionsKt.listOf((Object)container));
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logManager.getApiModel().getProject(), "logs-highlight-navigation-action");
            KubernetesOpenLogsTabActionKt.openLogsInEditor(apiModel2.getProject(), apiModel2, (Disposable)apiModel2.getApiProvider$intellij_clouds_kubernetes(), logManager, this, container.getName() + " logs");
        }

        public final void onEventHyperlinkClick(@NotNull KubernetesApiModel apiModel2) {
            Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
            KubernetesContextLogsManager logManager = new KubernetesContextLogsManager(apiModel2);
            logManager.getCurrentContainers$intellij_clouds_kubernetes().setValue((Object)CollectionsKt.emptyList());
            logManager.getAddClusterEventsAsLogs$intellij_clouds_kubernetes().setValue((Object)true);
            KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logManager.getApiModel().getProject(), "logs-highlight-navigation-action");
            KubernetesOpenLogsTabActionKt.openLogsInEditor(apiModel2.getProject(), apiModel2, (Disposable)apiModel2.getApiProvider$intellij_clouds_kubernetes(), logManager, this, "Cluster events");
        }

        @NotNull
        public final List<LogLineEntry> buildLogEntriesList$intellij_clouds_kubernetes(@NotNull List<? extends KubernetesContextLog> logsList, @NotNull KubernetesLogPresentationSettings presentationSettings, @NotNull KubernetesContextLogsManager.HyperLinkCachedCreator hyperLinkRegistry) {
            Intrinsics.checkNotNullParameter(logsList, (String)"logsList");
            Intrinsics.checkNotNullParameter((Object)presentationSettings, (String)"presentationSettings");
            Intrinsics.checkNotNullParameter((Object)hyperLinkRegistry, (String)"hyperLinkRegistry");
            List logEntries = new ArrayList();
            List<LogHighlightingPattern> highlighters = KubernetesLogsGlobalSettings.Companion.getInstance().getLogsHighlighters$intellij_clouds_kubernetes();
            Iterator iterator = ((Iterable)logsList).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int lineIndex = n++;
                KubernetesContextLog log2 = (KubernetesContextLog)iterator.next();
                LogLineEntry logLineEntry = new LogLineEntry(lineIndex, this.createLogEntry(presentationSettings, log2, hyperLinkRegistry, highlighters), log2.getTimestamp());
                logEntries.add(logLineEntry);
            }
            return logEntries;
        }

        private final List<LogEntry> createLogEntry(KubernetesLogPresentationSettings presentationSettings, KubernetesContextLog log2, KubernetesContextLogsManager.HyperLinkCachedCreator hyperLinkRegistry, List<LogHighlightingPattern> highlighters) {
            List logLineEntries = new ArrayList();
            if (presentationSettings.getShowTimestamp()) {
                logLineEntries.add(new LogEntry("[" + log2.getPrettyTimestamp() + "]\t", LAZY_TIMESTAMP, null, null, 12, null));
            }
            if (presentationSettings.getShowSource()) {
                logLineEntries.add(OPENING_BRACKET_ENTRY);
                logLineEntries.add(new LogEntry(log2.getSource(), LAZY_SOURCE, hyperLinkRegistry.getHyperlinkInfoForLog$intellij_clouds_kubernetes(log2), null, 8, null));
                logLineEntries.add(CLOSING_BRACKET_TAB_ENTRY);
            }
            if (presentationSettings.getShowMessage()) {
                if (KubernetesLogAnsiSegmentKt.containsAnsi(log2.getMessage())) {
                    boolean ansiSegments22;
                    try {
                        List<AnsiSegment> ansiSegments22 = KubernetesLogAnsiSegmentKt.parseStringWithAnsi(log2.getMessage());
                        for (AnsiSegment it : ansiSegments22) {
                            logLineEntries.add(it.toLogEntry$intellij_clouds_kubernetes());
                        }
                        ansiSegments22 = logLineEntries.add(new LogEntry("\n", LAZY_NORMAL, null, null, 12, null));
                    }
                    catch (KubernetesAnsiParsingException e) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(AnsiSegment.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.warnWithDebug("Exception during log ANSI line parsing", (Throwable)e);
                        ansiSegments22 = logLineEntries.add(new LogEntry(KubernetesLogAnsiSegmentKt.stripAnsi(log2.getMessage()) + "\n", LAZY_NORMAL, null, null, 12, null));
                    }
                    v1 = ansiSegments22;
                } else {
                    ConsoleViewContentType logEntryContentType = this.determineContentType(log2, highlighters);
                    v1 = logLineEntries.add(new LogEntry(log2.getMessage() + "\n", LazyKt.lazy(() -> Companion.createLogEntry$lambda$0(logEntryContentType)), null, null, 12, null));
                }
            } else {
                v1 = logLineEntries.add(LINE_BREAK_ENTRY);
            }
            return logLineEntries;
        }

        /*
         * WARNING - void declaration
         */
        private final ConsoleViewContentType determineContentType(KubernetesContextLog log2, List<LogHighlightingPattern> highlighters) {
            ConsoleViewContentType consoleViewContentType;
            LogHighlightingPattern matchedHighlighter;
            Object v0;
            int n;
            block3: {
                String message2 = log2.getMessage();
                Iterable $this$firstOrNull$iv = highlighters;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    LogHighlightingPattern it = (LogHighlightingPattern)element$iv;
                    n = 0;
                    if (!(it.getEnabled() && new Regex(it.getPattern()).containsMatchIn((CharSequence)message2))) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            LogHighlightingPattern logHighlightingPattern = matchedHighlighter = (LogHighlightingPattern)v0;
            if (logHighlightingPattern != null) {
                void it;
                LogHighlightingPattern it2 = logHighlightingPattern;
                boolean bl = false;
                int fontStyle = it2.getBold() && it2.getItalic() ? 3 : (it2.getBold() ? 1 : (it2.getItalic() ? 2 : 0));
                n = it2.getFgRgb();
                String string = "KUBERNETES_LOG_ConsoleViewContentType";
                boolean bl2 = false;
                int n2 = fontStyle;
                EffectType effectType = null;
                Color color = null;
                Color color2 = null;
                Color color3 = (Color)new JBColor((int)it, (int)it);
                TextAttributes textAttributes = new TextAttributes(color3, color2, color, effectType, n2);
                String string2 = string;
                consoleViewContentType = new ConsoleViewContentType(string2, textAttributes);
            } else {
                ConsoleViewContentType consoleViewContentType2 = NORMAL_OUTPUT;
                consoleViewContentType = consoleViewContentType2;
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"access$getNORMAL_OUTPUT$cp(...)");
            }
            return consoleViewContentType;
        }

        private static final ConsoleViewContentType createLogEntry$lambda$0(ConsoleViewContentType $logEntryContentType) {
            return $logEntryContentType;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J;\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogEntry;", "", "message", "", "contentType", "Lkotlin/Lazy;", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "hyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfo;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "<init>", "(Ljava/lang/String;Lkotlin/Lazy;Lcom/intellij/execution/filters/HyperlinkInfo;Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "getMessage", "()Ljava/lang/String;", "getContentType", "()Lkotlin/Lazy;", "getHyperlinkInfo", "()Lcom/intellij/execution/filters/HyperlinkInfo;", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "setHighlighter", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)V", "equals", "", "other", "hashCode", "", "component1", "component2", "component3", "component4", "copy", "toString", "intellij.clouds.kubernetes"})
    public static final class LogEntry {
        @NotNull
        private final String message;
        @NotNull
        private final Lazy<ConsoleViewContentType> contentType;
        @Nullable
        private final HyperlinkInfo hyperlinkInfo;
        @Nullable
        private RangeHighlighter highlighter;

        public LogEntry(@NotNull String message2, @NotNull Lazy<? extends ConsoleViewContentType> contentType, @Nullable HyperlinkInfo hyperlinkInfo2, @Nullable RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter(contentType, (String)"contentType");
            this.message = message2;
            this.contentType = contentType;
            this.hyperlinkInfo = hyperlinkInfo2;
            this.highlighter = highlighter;
        }

        public /* synthetic */ LogEntry(String string, Lazy lazy, HyperlinkInfo hyperlinkInfo2, RangeHighlighter rangeHighlighter, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                hyperlinkInfo2 = null;
            }
            if ((n & 8) != 0) {
                rangeHighlighter = null;
            }
            this(string, (Lazy<? extends ConsoleViewContentType>)lazy, hyperlinkInfo2, rangeHighlighter);
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final Lazy<ConsoleViewContentType> getContentType() {
            return this.contentType;
        }

        @Nullable
        public final HyperlinkInfo getHyperlinkInfo() {
            return this.hyperlinkInfo;
        }

        @Nullable
        public final RangeHighlighter getHighlighter() {
            return this.highlighter;
        }

        public final void setHighlighter(@Nullable RangeHighlighter rangeHighlighter) {
            this.highlighter = rangeHighlighter;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LogEntry && Intrinsics.areEqual((Object)((LogEntry)other).message, (Object)this.message);
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final Lazy<ConsoleViewContentType> component2() {
            return this.contentType;
        }

        @Nullable
        public final HyperlinkInfo component3() {
            return this.hyperlinkInfo;
        }

        @Nullable
        public final RangeHighlighter component4() {
            return this.highlighter;
        }

        @NotNull
        public final LogEntry copy(@NotNull String message2, @NotNull Lazy<? extends ConsoleViewContentType> contentType, @Nullable HyperlinkInfo hyperlinkInfo2, @Nullable RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            Intrinsics.checkNotNullParameter(contentType, (String)"contentType");
            return new LogEntry(message2, contentType, hyperlinkInfo2, highlighter);
        }

        public static /* synthetic */ LogEntry copy$default(LogEntry logEntry, String string, Lazy lazy, HyperlinkInfo hyperlinkInfo2, RangeHighlighter rangeHighlighter, int n, Object object) {
            if ((n & 1) != 0) {
                string = logEntry.message;
            }
            if ((n & 2) != 0) {
                lazy = logEntry.contentType;
            }
            if ((n & 4) != 0) {
                hyperlinkInfo2 = logEntry.hyperlinkInfo;
            }
            if ((n & 8) != 0) {
                rangeHighlighter = logEntry.highlighter;
            }
            return logEntry.copy(string, lazy, hyperlinkInfo2, rangeHighlighter);
        }

        @NotNull
        public String toString() {
            return "LogEntry(message=" + this.message + ", contentType=" + this.contentType + ", hyperlinkInfo=" + this.hyperlinkInfo + ", highlighter=" + this.highlighter + ")";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogLineEntry;", "", "lineIndex", "", "logEntries", "", "Lcom/intellij/kubernetes/logs/KubernetesContextLogsTabPanel$LogEntry;", "timestamp", "Ljava/time/Instant;", "<init>", "(ILjava/util/List;Ljava/time/Instant;)V", "getLineIndex", "()I", "getLogEntries", "()Ljava/util/List;", "getTimestamp", "()Ljava/time/Instant;", "equals", "", "other", "hashCode", "component1", "component2", "component3", "copy", "toString", "", "intellij.clouds.kubernetes"})
    public static final class LogLineEntry {
        private final int lineIndex;
        @NotNull
        private final List<LogEntry> logEntries;
        @NotNull
        private final Instant timestamp;

        public LogLineEntry(int lineIndex, @NotNull List<LogEntry> logEntries, @NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter(logEntries, (String)"logEntries");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            this.lineIndex = lineIndex;
            this.logEntries = logEntries;
            this.timestamp = timestamp;
        }

        public final int getLineIndex() {
            return this.lineIndex;
        }

        @NotNull
        public final List<LogEntry> getLogEntries() {
            return this.logEntries;
        }

        @NotNull
        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof LogLineEntry && Intrinsics.areEqual(this.logEntries, ((LogLineEntry)other).logEntries) && Intrinsics.areEqual((Object)this.timestamp, (Object)((LogLineEntry)other).timestamp);
        }

        public int hashCode() {
            return ((Object)this.logEntries).hashCode() + 31 * this.timestamp.hashCode();
        }

        public final int component1() {
            return this.lineIndex;
        }

        @NotNull
        public final List<LogEntry> component2() {
            return this.logEntries;
        }

        @NotNull
        public final Instant component3() {
            return this.timestamp;
        }

        @NotNull
        public final LogLineEntry copy(int lineIndex, @NotNull List<LogEntry> logEntries, @NotNull Instant timestamp) {
            Intrinsics.checkNotNullParameter(logEntries, (String)"logEntries");
            Intrinsics.checkNotNullParameter((Object)timestamp, (String)"timestamp");
            return new LogLineEntry(lineIndex, logEntries, timestamp);
        }

        public static /* synthetic */ LogLineEntry copy$default(LogLineEntry logLineEntry, int n, List list2, Instant instant, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = logLineEntry.lineIndex;
            }
            if ((n2 & 2) != 0) {
                list2 = logLineEntry.logEntries;
            }
            if ((n2 & 4) != 0) {
                instant = logLineEntry.timestamp;
            }
            return logLineEntry.copy(n, list2, instant);
        }

        @NotNull
        public String toString() {
            return "LogLineEntry(lineIndex=" + this.lineIndex + ", logEntries=" + this.logEntries + ", timestamp=" + this.timestamp + ")";
        }
    }
}

