/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.KubernetesContextLog;
import io.kubernetes.client.openapi.models.CoreV1Event;
import io.kubernetes.client.openapi.models.V1EventSource;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.time.Instant;
import java.time.OffsetDateTime;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesEventLog;", "Lcom/intellij/kubernetes/logs/KubernetesContextLog;", "event", "Lio/kubernetes/client/openapi/models/CoreV1Event;", "<init>", "(Lio/kubernetes/client/openapi/models/CoreV1Event;)V", "getEvent", "()Lio/kubernetes/client/openapi/models/CoreV1Event;", "message", "", "getMessage", "()Ljava/lang/String;", "source", "getSource", "isEvent", "", "()Z", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesContextLogsModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesContextLogsModel.kt\ncom/intellij/kubernetes/logs/KubernetesEventLog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1#2:271\n*E\n"})
public final class KubernetesEventLog
extends KubernetesContextLog {
    @NotNull
    private final CoreV1Event event;
    @NotNull
    private final String source;
    private final boolean isEvent;

    /*
     * WARNING - void declaration
     */
    public KubernetesEventLog(@NotNull CoreV1Event event2) {
        void it;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Comparable<OffsetDateTime> comparable = event2.getEventTime();
        if (comparable == null || (comparable = comparable.toInstant()) == null) {
            OffsetDateTime offsetDateTime = event2.getLastTimestamp();
            comparable = offsetDateTime != null ? offsetDateTime.toInstant() : null;
            if (comparable == null) {
                comparable = Instant.now();
            }
        }
        Object[] objectArray = comparable;
        Intrinsics.checkNotNull((Object)objectArray);
        super((Instant)objectArray, "", null);
        this.event = event2;
        objectArray = new String[2];
        V1EventSource v1EventSource = this.event.getSource();
        objectArray[0] = v1EventSource != null ? v1EventSource.getComponent() : null;
        V1ObjectReference v1ObjectReference = this.event.getInvolvedObject();
        objectArray[1] = v1ObjectReference != null ? v1ObjectReference.getName() : null;
        String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        KubernetesEventLog kubernetesEventLog = this;
        boolean bl = false;
        kubernetesEventLog.source = ((CharSequence)it).length() > 0 ? it : "Cluster Event";
        this.isEvent = true;
    }

    @NotNull
    public final CoreV1Event getEvent() {
        return this.event;
    }

    @Override
    @NotNull
    public String getMessage() {
        return "Type: " + this.event.getType() + "\tReason: " + this.event.getReason() + "\tMessage: " + this.event.getMessage();
    }

    @Override
    @NotNull
    public String getSource() {
        return this.source;
    }

    @Override
    public boolean isEvent() {
        return this.isEvent;
    }
}

