/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.logs.KubernetesContextLogsManager;
import com.intellij.kubernetes.logs.KubernetesLogFilterModel;
import com.intellij.kubernetes.logs.KubernetesLogFilteringActionsKt;
import com.intellij.kubernetes.logs.TimeSlice;
import com.intellij.kubernetes.view.ui.actions.logs.KubernetesDateTimeFilterComponent;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.time.Instant;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/logs/KubernetesSelectDateTimeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesSelectDateTimeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesSelectDateTimeAction.kt\ncom/intellij/kubernetes/logs/KubernetesSelectDateTimeAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class KubernetesSelectDateTimeAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesContextLogsManager logsManager = KubernetesLogFilteringActionsKt.logManager(e);
        if (logsManager == null || logsManager.isJobManagerDisposed$intellij_clouds_kubernetes() || !logsManager.getApiModel().isConnected()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Instant it;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        KubernetesContextLogsManager kubernetesContextLogsManager = KubernetesLogFilteringActionsKt.logManager(e);
        if (kubernetesContextLogsManager == null) {
            return;
        }
        KubernetesContextLogsManager logsManager = kubernetesContextLogsManager;
        KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log(logsManager.getApiModel().getProject(), "logs-select-date-time-action");
        KubernetesDateTimeFilterComponent dateComponent = new KubernetesDateTimeFilterComponent(logsManager.getApiModel().getProject());
        KubernetesLogFilterModel currentFilter = logsManager.getFilterModel$intellij_clouds_kubernetes();
        Instant instant = currentFilter.getTimeSlice$intellij_clouds_kubernetes().getBeginTime();
        if (instant != null) {
            it = instant;
            boolean bl = false;
            dateComponent.setBeginDate(it);
        }
        dateComponent.setUseBeginDateFilter(currentFilter.getTimeSlice$intellij_clouds_kubernetes().getBeginTime() != null);
        Instant instant2 = currentFilter.getTimeSlice$intellij_clouds_kubernetes().getEndTime();
        if (instant2 != null) {
            it = instant2;
            boolean bl = false;
            dateComponent.setEndDate(it);
        }
        dateComponent.setUseEndDateFilter(currentFilter.getTimeSlice$intellij_clouds_kubernetes().getEndTime() != null);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)dateComponent.getPanel(), (JComponent)dateComponent.getPanel()).setTitle(KubernetesBundle.message("k8s.logs.select.date.time.action.popup.title.select.date.time", new Object[0])).setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelKeyEnabled(true).setModalContext(false).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup popup2 = jBPopup;
        dateComponent.getPanel().addKeyListener(new KeyAdapter(popup2){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    this.$popup.closeOk((InputEvent)e);
                }
            }
        });
        popup2.addListener(new JBPopupListener(dateComponent, currentFilter){
            final /* synthetic */ KubernetesDateTimeFilterComponent $dateComponent;
            final /* synthetic */ KubernetesLogFilterModel $currentFilter;
            {
                this.$dateComponent = $dateComponent;
                this.$currentFilter = $currentFilter;
            }

            public void onClosed(LightweightWindowEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                TimeSlice dateFilter = new TimeSlice(this.$dateComponent.getBeginDate(), this.$dateComponent.getEndDate());
                this.$currentFilter.setTimeSlice$intellij_clouds_kubernetes(dateFilter);
            }
        });
        InputEvent inputEvent = e.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup2.show(new RelativePoint((MouseEvent)inputEvent));
        }
    }
}

