/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.references.KubernetesLabelKeyFindUsagesHandlerFactory;
import com.intellij.kubernetes.references.LabelKeyReference;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/references/KubernetesLabelKeyFindUsagesHandlerFactory;", "Lcom/intellij/find/findUsages/FindUsagesHandlerFactory;", "<init>", "()V", "canFindUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "createFindUsagesHandler", "Lcom/intellij/find/findUsages/FindUsagesHandler;", "forHighlightUsages", "intellij.clouds.kubernetes"})
public final class KubernetesLabelKeyFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof YAMLKeyValue)) {
            return false;
        }
        return KubernetesLabelUtilKt.getLabel(element) != null;
    }

    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.canFindUsages(element)) {
            return null;
        }
        return new FindUsagesHandler(element){
            private final KubernetesResolver resolver;
            private boolean usagesFound;
            final /* synthetic */ PsiElement $element;
            {
                this.$element = $element;
                super($element);
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                this.resolver = (KubernetesResolver)object;
            }

            public final KubernetesResolver getResolver() {
                return this.resolver;
            }

            public PsiElement[] getPrimaryElements() {
                PsiElement[] psiElementArray;
                Pair<String, String> pair = KubernetesLabelUtilKt.getLabel(this.$element);
                if (pair == null) {
                    PsiElement[] psiElementArray2 = super.getPrimaryElements();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"getPrimaryElements(...)");
                    return psiElementArray2;
                }
                String name = (String)pair.component1();
                Collection<YAMLKeyValue> result2 = this.resolver.findTargetLabelDeclarationsForUsages(this.$element, name, null);
                if (!result2.isEmpty()) {
                    Collection<YAMLKeyValue> $this$toTypedArray$iv = result2;
                    boolean $i$f$toTypedArray = false;
                    Collection<YAMLKeyValue> thisCollection$iv = $this$toTypedArray$iv;
                    psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
                } else {
                    PsiElement[] psiElementArray3 = super.getPrimaryElements();
                    psiElementArray = psiElementArray3;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"getPrimaryElements(...)");
                }
                return psiElementArray;
            }

            public boolean processElementUsages(PsiElement element, Processor<? super UsageInfo> processor, FindUsagesOptions options) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter(processor, (String)"processor");
                Intrinsics.checkNotNullParameter((Object)options, (String)"options");
                if (!this.usagesFound) {
                    this.usagesFound = (Boolean)ReadAction.compute(() -> createFindUsagesHandler.1.processElementUsages$lambda$1(element, this, options, processor));
                }
                return this.usagesFound;
            }

            /*
             * WARNING - void declaration
             */
            public Collection<PsiReference> findReferencesToHighlight(PsiElement target, SearchScope searchScope) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
                Pair<String, String> pair = KubernetesLabelUtilKt.getLabel(target);
                if (pair == null) {
                    return new ArrayList<E>();
                }
                String labelName = (String)pair.component1();
                Iterable iterable = CollectionsKt.plus(this.resolver.findLabelReferrers(searchScope, this.$element, labelName, null), (Iterable)this.resolver.findTargetLabelDeclarationsForUsages(searchScope, this.$element, labelName, null));
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new LabelKeyReference((YAMLKeyValue)it));
                }
                return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            }

            protected boolean isSearchForTextOccurrencesAvailable(PsiElement psiElement, boolean isSingleFile) {
                Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            private static final Boolean processElementUsages$lambda$1(PsiElement $element, createFindUsagesHandler.1 this$0, FindUsagesOptions $options, Processor $processor) {
                void $this$forEach$iv;
                Pair<String, String> pair = KubernetesLabelUtilKt.getLabel($element);
                if (pair == null) {
                    return true;
                }
                String labelName = (String)pair.component1();
                KubernetesResolver kubernetesResolver = this$0.resolver;
                SearchScope searchScope = $options.searchScope;
                Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"searchScope");
                Iterable iterable = kubernetesResolver.findLabelReferrers(searchScope, $element, labelName, null);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    YAMLKeyValue value2;
                    YAMLKeyValue it = (YAMLKeyValue)element$iv;
                    boolean bl = false;
                    Object object = it instanceof YAMLKeyValue ? it : null;
                    if (object == null || $processor.process((Object)new UsageInfo((PsiElement)(value2 = object)))) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

