/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.references.LabelContainerNavigationHandler;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\t0\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/references/LabelContainerAnnotator;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "<init>", "()V", "getName", "", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "element", "Lcom/intellij/psi/PsiElement;", "collectSlowLineMarkers", "", "elements", "", "result", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nLabelContainerAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LabelContainerAnnotator.kt\ncom/intellij/kubernetes/references/LabelContainerAnnotator\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,72:1\n31#2,2:73\n*S KotlinDebug\n*F\n+ 1 LabelContainerAnnotator.kt\ncom/intellij/kubernetes/references/LabelContainerAnnotator\n*L\n41#1:73,2\n*E\n"})
public final class LabelContainerAnnotator
extends LineMarkerProviderDescriptor {
    @NotNull
    public String getName() {
        String string = KubernetesBundle.message("LabelContainerAnnotator.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = KubernetesIcons.LabelsGutter;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LabelsGutter");
        return icon;
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        PsiElement parent;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                parent = element.getParent();
                if (!(element instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)element).getElementType(), (Object)YAMLTokenTypes.SCALAR_KEY) || !(parent instanceof YAMLKeyValue) || !Intrinsics.areEqual((Object)((YAMLKeyValue)parent).getKey(), (Object)element) || !(((YAMLKeyValue)parent).getValue() instanceof YAMLMapping)) break block6;
                Object[] objectArray = new String[]{"matchLabels", "selector", "labels"};
                Set set = SetsKt.setOf((Object[])objectArray);
                String string = ((YAMLKeyValue)parent).getKeyText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
                if (set.contains(((Object)StringsKt.trim((CharSequence)string)).toString())) break block7;
            }
            return null;
        }
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy((YAMLKeyValue)parent);
        if (!(metaTypeProxy != null && (metaTypeProxy = metaTypeProxy.getMetaType()) != null ? KubernetesUtilKt.isKubernetesLabelContainer((YamlMetaType)metaTypeProxy) : false)) {
            return null;
        }
        Project project = ((LeafPsiElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        KubernetesResolver resolver = (KubernetesResolver)object;
        YamlMetaType yamlMetaType = KubernetesUtilKt.getK8sMetaType((YAMLPsiElement)parent);
        if (yamlMetaType == null) {
            return null;
        }
        boolean declaration = KubernetesUtilKt.isObjectMeta(yamlMetaType);
        Triple triple = declaration ? new Triple((Object)"LabelContainerAnnotator.targetList.selectors.title", (Object)KubernetesIcons.LabelsGutter, () -> LabelContainerAnnotator.getLineMarkerInfo$lambda$0(resolver, parent)) : new Triple((Object)"LabelContainerAnnotator.targetList.definitions.title", (Object)KubernetesIcons.SelectorGutter, () -> LabelContainerAnnotator.getLineMarkerInfo$lambda$2(resolver, parent));
        String objectsTitleKey = (String)triple.component1();
        Object object2 = triple.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"component2(...)");
        Icon gutterIcon = (Icon)object2;
        Function0 targetLoader = (Function0)triple.component3();
        String string = KubernetesBundle.message(objectsTitleKey, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String objectsTitle = string;
        Object[] objectArray = new Object[]{objectsTitle};
        String string2 = KubernetesBundle.message("LabelContainerAnnotator.targetList.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String title = string2;
        Object[] objectArray2 = new Object[]{objectsTitle};
        String string3 = KubernetesBundle.message("LabelContainerAnnotator.targetList.notFound", objectArray2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String notFoundMessage = string3;
        Project project2 = ((LeafPsiElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        LabelContainerNavigationHandler navHandler = new LabelContainerNavigationHandler(project2, title, notFoundMessage, (Function0<? extends Collection<? extends NavigatablePsiElement>>)targetLoader);
        return new LineMarkerInfo(element, ((LeafPsiElement)element).getTextRange(), gutterIcon, (Function)new ConstantFunction((Object)title), (GutterIconNavigationHandler)navHandler, GutterIconRenderer.Alignment.RIGHT, () -> LabelContainerAnnotator.getLineMarkerInfo$lambda$3(title));
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
    }

    private static final Collection getLineMarkerInfo$lambda$0(KubernetesResolver $resolver, PsiElement $parent) {
        YAMLValue yAMLValue = ((YAMLKeyValue)$parent).getValue();
        Intrinsics.checkNotNull((Object)yAMLValue, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLMapping");
        return $resolver.findAllMatchingSelectors((YAMLMapping)yAMLValue);
    }

    private static final boolean getLineMarkerInfo$lambda$2$lambda$1(PsiElement $parent, YAMLKeyValue targetLabels) {
        Intrinsics.checkNotNullParameter((Object)targetLabels, (String)"targetLabels");
        YAMLValue yAMLValue = targetLabels.getValue();
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return false;
        }
        YAMLMapping declaredLabels = yAMLMapping;
        YAMLValue yAMLValue2 = ((YAMLKeyValue)$parent).getValue();
        Intrinsics.checkNotNull((Object)yAMLValue2, (String)"null cannot be cast to non-null type org.jetbrains.yaml.psi.YAMLMapping");
        return KubernetesLabelUtilKt.labelsMatch((YAMLMapping)yAMLValue2, declaredLabels);
    }

    private static final List getLineMarkerInfo$lambda$2(KubernetesResolver $resolver, PsiElement $parent) {
        return $resolver.findTargetLabelContainers($parent, (Function1<? super YAMLKeyValue, Boolean>)((Function1)arg_0 -> LabelContainerAnnotator.getLineMarkerInfo$lambda$2$lambda$1($parent, arg_0)));
    }

    private static final String getLineMarkerInfo$lambda$3(String $title) {
        return $title;
    }
}

