/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.KubernetesSpecManager;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.config.ConfigScope;
import com.intellij.kubernetes.config.SpecSource;
import com.intellij.kubernetes.config.SpecSourceItem;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.SpecSourceTableView;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/ui/SpecSourceTableView;", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/kubernetes/config/SpecSourceItem;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/util/ui/ListTableModel;", "getModel", "()Lcom/intellij/util/ui/ListTableModel;", "addLocalPaths", "", "addUrl", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nSpecSourceTableView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecSourceTableView.kt\ncom/intellij/kubernetes/ui/SpecSourceTableView\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,223:1\n13409#2:224\n13410#2:226\n1#3:225\n1863#4,2:227\n19#5:229\n19#5:230\n*S KotlinDebug\n*F\n+ 1 SpecSourceTableView.kt\ncom/intellij/kubernetes/ui/SpecSourceTableView\n*L\n182#1:224\n182#1:226\n207#1:227,2\n218#1:229\n219#1:230\n*E\n"})
public final class SpecSourceTableView
extends TableView<SpecSourceItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final ListTableModel<SpecSourceItem> model;

    public SpecSourceTableView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ColumnInfo[] columnInfoArray = new ColumnInfo[3];
        Object[] objectArray = KubernetesBundle.message("KubernetesConfigurable.crdSpec.column.title", new Object[0]);
        columnInfoArray[0] = new ColumnInfo<SpecSourceItem, String>((String)objectArray){

            public TableCellEditor getEditor(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return (TableCellEditor)new LocalPathCellEditor(this.getProject()).fileChooserDescriptor(new FileChooserDescriptor(true, false, false, false, false, false));
            }

            public String valueOf(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return parameter.getSpecSource().getPathOrUrl();
            }

            public void setValue(SpecSourceItem parameter, String value2) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                parameter.getSpecSource().setPathOrUrl(StringUtil.trim((String)value2));
            }

            public boolean isCellEditable(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return true;
            }
        };
        objectArray = KubernetesBundle.message("KubernetesConfigurable.status.column.title", new Object[0]);
        columnInfoArray[1] = new ColumnInfo<SpecSourceItem, KubernetesSpecManager.AvailabilityInfo>((String)objectArray){

            public String getTooltipText() {
                String string = KubernetesBundle.message("KubernetesConfigurable.status.column.tooltip", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public KubernetesSpecManager.AvailabilityInfo valueOf(SpecSourceItem parameter) {
                KubernetesSpecManager.AvailabilityInfo availabilityInfo;
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                String string = parameter.getSpecSource().getPathOrUrl();
                if (string != null) {
                    String string2 = string;
                    SpecSourceTableView specSourceTableView = this;
                    String it = string2;
                    boolean bl = false;
                    availabilityInfo = KubernetesModelAccessor.Companion.getInstance(specSourceTableView.getProject()).getSpecManager().getSpecErrorStatus(it);
                } else {
                    availabilityInfo = null;
                }
                return availabilityInfo;
            }

            public TableCellRenderer getRenderer(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return (TableCellRenderer)new IconTableCellRenderer<KubernetesSpecManager.AvailabilityInfo>(){

                    protected Icon getIcon(KubernetesSpecManager.AvailabilityInfo value2, JTable table, int row) {
                        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                        return switch (getRenderer.WhenMappings.$EnumSwitchMapping$0[value2.getStatus().ordinal()]) {
                            case 1 -> {
                                this.setToolTipText(value2.getErrorMessage());
                                Icon var4_4 = AllIcons.General.BalloonWarning;
                                Intrinsics.checkNotNull((Object)var4_4);
                                yield var4_4;
                            }
                            case 2 -> {
                                this.setToolTipText(KubernetesBundle.message("KubernetesConfigurable.spec.status.available", new Object[0]));
                                Icon var4_5 = AllIcons.General.InspectionsOK;
                                Intrinsics.checkNotNull((Object)var4_5);
                                yield var4_5;
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        };
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value2, boolean selected, boolean focus, int row, int column) {
                        super.getTableCellRendererComponent(table, value2, selected, focus, row, column);
                        this.setText("");
                        return (Component)((Object)this);
                    }

                    protected boolean isCenterAlignment() {
                        return true;
                    }
                };
            }

            public String getMaxStringValue() {
                return "";
            }

            public int getAdditionalWidth() {
                return 0;
            }

            public int getWidth(JTable table) {
                return AllIcons.General.BalloonWarning.getIconWidth() + JBUIScale.scale((int)35);
            }
        };
        objectArray = KubernetesBundle.message("KubernetesConfigurable.scope.column.title", new Object[0]);
        columnInfoArray[2] = new ColumnInfo<SpecSourceItem, ConfigScope>((String)objectArray){
            private final ComboBoxTableRenderer<ConfigScope> renderer;
            {
                void $this$renderer_u24lambda_u240;
                ComboBoxTableRenderer comboBoxTableRenderer;
                ComboBoxTableRenderer comboBoxTableRenderer2 = comboBoxTableRenderer = new ComboBoxTableRenderer((Object[])ConfigScope.values());
                3 var5_4 = this;
                boolean bl = false;
                $this$renderer_u24lambda_u240.withClickCount(1);
                var5_4.renderer = comboBoxTableRenderer;
            }

            public TableCellEditor getEditor(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return (TableCellEditor)this.renderer;
            }

            public ConfigScope valueOf(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return parameter.getScope();
            }

            public void setValue(SpecSourceItem parameter, ConfigScope value2) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                parameter.setScope(value2);
            }

            public boolean isCellEditable(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return true;
            }

            public TableCellRenderer getRenderer(SpecSourceItem parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                return (TableCellRenderer)this.renderer;
            }

            /*
             * WARNING - void declaration
             */
            public String getMaxStringValue() {
                Enum enum_;
                ConfigScope[] $this$maxByOrNull$iv = ConfigScope.values();
                boolean $i$f$maxByOrNull = false;
                if ($this$maxByOrNull$iv.length == 0) {
                    enum_ = null;
                } else {
                    ConfigScope maxElem$iv = $this$maxByOrNull$iv[0];
                    int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$maxByOrNull$iv);
                    if (lastIndex$iv == 0) {
                        enum_ = maxElem$iv;
                    } else {
                        void var3_3;
                        ConfigScope it = maxElem$iv;
                        boolean bl = false;
                        int maxValue$iv = it.toString().length();
                        int i$iv = 1;
                        if (i$iv <= lastIndex$iv) {
                            while (true) {
                                ConfigScope e$iv;
                                ConfigScope it2 = e$iv = $this$maxByOrNull$iv[i$iv];
                                $i$a$-maxByOrNull-SpecSourceTableView$3$getMaxStringValue$1 = false;
                                int v$iv = it2.toString().length();
                                if (maxValue$iv < v$iv) {
                                    maxElem$iv = e$iv;
                                    maxValue$iv = v$iv;
                                }
                                if (i$iv == lastIndex$iv) break;
                                ++i$iv;
                            }
                        }
                        enum_ = var3_3;
                    }
                }
                return enum_ != null ? enum_.toString() : null;
            }

            public int getAdditionalWidth() {
                return JBUIScale.scale((int)24) + AllIcons.General.ArrowDown.getIconWidth();
            }
        };
        this.model = new ListTableModel(columnInfoArray);
        this.setModelAndUpdateColumns(this.model);
        Shortcut[] shortcutArray = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD).getShortcuts();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
        Shortcut it = (Shortcut)ArraysKt.firstOrNull((Object[])shortcutArray);
        boolean bl = false;
        Shortcut shortcut = it;
        Object shortcutText = shortcut != null ? "(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")" : "";
        objectArray = new Object[]{shortcutText};
        this.getEmptyText().setText(KubernetesBundle.message("KubernetesConfigurable.crdSpec.empty.text1", objectArray));
        this.getEmptyText().appendText(KubernetesBundle.message("KubernetesConfigurable.crdSpec.empty.text.files", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> SpecSourceTableView._init_$lambda$1(this, arg_0));
        this.getEmptyText().appendText(KubernetesBundle.message("KubernetesConfigurable.crdSpec.empty.text2", new Object[0]));
        this.getEmptyText().appendText(KubernetesBundle.message("KubernetesConfigurable.crdSpec.empty.text.url", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, arg_0 -> SpecSourceTableView._init_$lambda$2(this, arg_0));
        this.getEmptyText().appendSecondaryText(KubernetesBundle.message("KubernetesConfigurable.crdSpec.help.link.title", new Object[0]), SimpleTextAttributes.LINK_ATTRIBUTES, SpecSourceTableView::_init_$lambda$3);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ListTableModel<SpecSourceItem> getModel() {
        return this.model;
    }

    public final void addLocalPaths() {
        this.stopEditing();
        FileChooserDialogImpl chooser = new FileChooserDialogImpl(new FileChooserDescriptor(true, false, false, false, false, true), this.project);
        VirtualFile[] virtualFileArray = chooser.choose(this.project, new VirtualFile[0]);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"choose(...)");
        VirtualFile[] files = virtualFileArray;
        if (!(files.length == 0)) {
            VirtualFile[] $this$forEach$iv = files;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object v2;
                SpecSource specSource;
                block3: {
                    VirtualFile element$iv;
                    VirtualFile file = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    specSource = new SpecSource(PathUtil.toSystemDependentName((String)file.getPath()));
                    List list2 = this.model.getItems();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
                    Iterable iterable = list2;
                    for (Object t : iterable) {
                        SpecSourceItem it = (SpecSourceItem)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getSpecSource(), (Object)specSource)) continue;
                        v2 = t;
                        break block3;
                    }
                    v2 = null;
                }
                if (v2 != null) continue;
                this.model.addRow((Object)new SpecSourceItem(specSource, ConfigScope.PROJECT));
            }
            int index = this.model.getRowCount() - 1;
            this.setRowSelectionInterval(index, index);
            SwingUtilities.invokeLater(() -> SpecSourceTableView.addLocalPaths$lambda$6(this));
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void addUrl() {
        this.stopEditing();
        var2_1 = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (var2_1 == null) ** GOTO lbl-1000
        p0 = var2_1;
        $i$f$addUrl$stub_for_inlining = false;
        $i$a$-let-SpecSourceTableView$addUrl$urls$1 = false;
        var3_8 = MiscUtilKt.extractUrls((String)p0);
        if (var3_8 == null) ** GOTO lbl-1000
        it = p0 = var3_8;
        $i$a$-takeIf-SpecSourceTableView$addUrl$urls$2 = false;
        v0 = var4_10 = !it.isEmpty() != false ? p0 : null;
        if (var4_10 != null) {
            v1 = var4_10;
        } else lbl-1000:
        // 3 sources

        {
            v1 = CollectionsKt.listOf((Object)"https://");
        }
        urls = v1;
        $this$forEach$iv = urls;
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            $i$a$-forEach-SpecSourceTableView$addUrl$1 = false;
            this.model.addRow((Object)new SpecSourceItem(new SpecSource(it), ConfigScope.PROJECT));
        }
        index = this.model.getRowCount() - 1;
        this.setRowSelectionInterval(index, index);
        SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, addUrl$lambda$9(com.intellij.kubernetes.ui.SpecSourceTableView int ), ()V)((SpecSourceTableView)this, (int)index));
    }

    private static final void _init_$lambda$1(SpecSourceTableView this$0, ActionEvent it) {
        this$0.addLocalPaths();
    }

    private static final void _init_$lambda$2(SpecSourceTableView this$0, ActionEvent it) {
        this$0.addUrl();
    }

    private static final void _init_$lambda$3(ActionEvent it) {
        HelpManager.getInstance().invokeHelp("Kubernetes.crdSpecs");
    }

    private static final void addLocalPaths$lambda$6(SpecSourceTableView this$0) {
        TableUtil.scrollSelectionToVisible((JTable)((JTable)((Object)this$0)));
    }

    private static final void addUrl$lambda$9(SpecSourceTableView this$0, int $index) {
        JTextField jTextField;
        CellEditorComponentWithBrowseButton cellEditorComponentWithBrowseButton;
        TableUtil.scrollSelectionToVisible((JTable)((JTable)((Object)this$0)));
        TableUtil.editCellAt((JTable)((JTable)((Object)this$0)), (int)$index, (int)0);
        Component $this$asSafely$iv = this$0.getEditorComponent();
        boolean $i$f$asSafely = false;
        Component component2 = $this$asSafely$iv;
        if (!(component2 instanceof CellEditorComponentWithBrowseButton)) {
            component2 = null;
        }
        JComponent $this$asSafely$iv2 = (cellEditorComponentWithBrowseButton = (CellEditorComponentWithBrowseButton)component2) != null ? cellEditorComponentWithBrowseButton.getChildComponent() : null;
        boolean $i$f$asSafely2 = false;
        JComponent jComponent = $this$asSafely$iv2;
        if (!(jComponent instanceof JTextField)) {
            jComponent = null;
        }
        if ((jTextField = (JTextField)jComponent) != null) {
            jTextField.selectAll();
        }
    }
}

