/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.KubernetesResourceRefreshable;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesConsoleViewPanel;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.kubernetes.view.ui.KubernetesResourceInformationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.EdtNoGetDataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.JBUI;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.Container;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B;\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001fJ\b\u0010$\u001a\u00020\u001eH\u0016J!\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001a2\u000f\b\u0002\u0010'\u001a\t\u0018\u00010(\u00a2\u0006\u0002\b)H\u0004J>\u0010*\u001a\u00020&\"\b\b\u0001\u0010\u0001*\u00020+2\u0006\u0010,\u001a\u0002H\u00012\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00010.2\u000f\b\u0002\u0010'\u001a\t\u0018\u00010(\u00a2\u0006\u0002\b)H\u0005\u00a2\u0006\u0002\u0010/R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\"\u0010#\u00a8\u00060"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/kubernetes/view/KubernetesResourceRefreshable;", "resource", "parentDisposable", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/api/KubernetesApiModel;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/ui/content/ContentManager;", "getManager", "()Lcom/intellij/ui/content/ContentManager;", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "refresh", "", "(Lio/kubernetes/client/common/KubernetesObject;)V", "informationPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceInformationPanel;", "getInformationPanel$annotations", "()V", "dispose", "addTab", "Lcom/intellij/ui/content/Content;", "displayName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "addConsoleTab", "", "key", "panel", "Lcom/intellij/kubernetes/view/ui/KubernetesConsoleViewPanel;", "(Ljava/lang/Object;Lcom/intellij/kubernetes/view/ui/KubernetesConsoleViewPanel;Ljava/lang/String;)Lcom/intellij/ui/content/Content;", "intellij.clouds.kubernetes"})
public class KubernetesResourceContent<T extends KubernetesObject>
implements Disposable,
KubernetesResourceRefreshable<T> {
    @NotNull
    private final KubernetesApiModel apiModel;
    @Nullable
    private final ActionGroup toolbarActionGroup;
    @NotNull
    private final ContentManager manager;
    @NotNull
    private final KubernetesResourceInformationPanel<T> informationPanel;

    public KubernetesResourceContent(@NotNull T resource, @NotNull Disposable parentDisposable, @NotNull KubernetesApiModel apiModel2, @NotNull KubernetesResourceMapper<T, ?> mapper, @Nullable ActionGroup toolbarActionGroup) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        this.apiModel = apiModel2;
        this.toolbarActionGroup = toolbarActionGroup;
        ContentUI contentUI = ServiceViewUIUtils.getServicesAlignedTabbedPaneContentUI();
        Project project = this.getProject();
        this.manager = (ContentManager)new ContentManagerImpl(contentUI, project){
            {
                this.addDataProvider((DataProvider)((EdtNoGetDataProvider)manager.1::_init_$lambda$0));
            }

            public List<AnAction> getAdditionalPopupActions(Content content2) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                List list2 = super.getAdditionalPopupActions(content2);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAdditionalPopupActions(...)");
                return CollectionsKt.plus((Collection)list2, (Object)ActionManager.getInstance().getAction("Kubernetes.StopPortForwarding"));
            }

            private static final void _init_$lambda$0(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
                sink.set(dataKey, (Object)"services.tool.window.kubernetes");
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.informationPanel = new KubernetesResourceInformationPanel<T>(resource, this, mapper.getColumnDescriptors(this.apiModel));
        Content content2 = this.addTab(this.informationPanel, KubernetesBundle.message("KubernetesResourceContent.informationContent.displayName", new Object[0]));
        content2.getDisplayName();
        content2.setCloseable(false);
    }

    @NotNull
    protected final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    @NotNull
    protected final Project getProject() {
        return this.apiModel.getProject();
    }

    @NotNull
    protected final ContentManager getManager() {
        return this.manager;
    }

    @NotNull
    public final JComponent getComponent() {
        JComponent jComponent = this.manager.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    public void refresh(@NotNull T resource) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        this.informationPanel.refresh(resource);
    }

    private static /* synthetic */ void getInformationPanel$annotations() {
    }

    public void dispose() {
    }

    @NotNull
    protected final Content addTab(@NotNull JComponent component2, @Nullable String displayName) {
        Content content2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Content content3 = this.manager.getFactory().createContent(component2, displayName, true);
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"createContent(...)");
            content2 = content3;
            if (this.toolbarActionGroup != null) {
                content2.setActions(this.toolbarActionGroup, "ServicesToolbar", component2);
            }
            this.manager.addContent(content2);
            Container container = component2.getParent();
            JComponent jComponent = container instanceof JComponent ? (JComponent)container : null;
            if (jComponent == null) break block1;
            jComponent.setBorder((Border)JBUI.Borders.empty());
        }
        return content2;
    }

    public static /* synthetic */ Content addTab$default(KubernetesResourceContent kubernetesResourceContent, JComponent jComponent, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTab");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return kubernetesResourceContent.addTab(jComponent, string);
    }

    @RequiresEdt
    @NotNull
    protected final <T> Content addConsoleTab(@NotNull T key, @NotNull KubernetesConsoleViewPanel<T> panel2, @Nullable String displayName) {
        Content content2;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(panel2, (String)"panel");
            Content[] contentArray = this.manager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                KubernetesConsoleViewPanel kubernetesConsoleViewPanel = (KubernetesConsoleViewPanel)KClasses.safeCast((KClass)Reflection.getOrCreateKotlinClass(panel2.getClass()), (Object)it.getComponent());
                boolean bl2 = kubernetesConsoleViewPanel != null ? kubernetesConsoleViewPanel.supports(key) : false;
                if (!bl2) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Content existingContent = (Content)object;
        if (existingContent != null) {
            JComponent jComponent = existingContent.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.kubernetes.view.ui.KubernetesConsoleViewPanel<*>");
            Disposer.dispose((Disposable)((Disposable)((KubernetesConsoleViewPanel)jComponent)));
        }
        if ((content2 = existingContent) == null) {
            content2 = this.addTab(panel2, displayName);
        }
        Content content3 = content2;
        content3.setComponent((JComponent)panel2);
        if (this.toolbarActionGroup != null) {
            content3.setActions(this.toolbarActionGroup, "ServicesToolbar", this.getComponent());
        }
        this.manager.setSelectedContent(content3, true);
        return content3;
    }

    public static /* synthetic */ Content addConsoleTab$default(KubernetesResourceContent kubernetesResourceContent, Object object, KubernetesConsoleViewPanel kubernetesConsoleViewPanel, String string, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addConsoleTab");
        }
        if ((n & 4) != 0) {
            string = null;
        }
        return kubernetesResourceContent.addConsoleTab(object, kubernetesConsoleViewPanel, string);
    }
}

