/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceVirtualFileBasedActionBase;
import com.intellij.kubernetes.view.vfs.KubernetesVirtualDirectory;
import com.intellij.kubernetes.view.vfs.ResourceContext;
import com.intellij.kubernetes.view.vfs.ResourceContextKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00028\u00002\u0010\u0010\n\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u000bH\u0014\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0007H\u0015J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDescribeResourceAction;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesResourceVirtualFileBasedActionBase;", "<init>", "()V", "getContext", "Lcom/intellij/kubernetes/view/vfs/ResourceContext;", "Lio/kubernetes/client/common/KubernetesListObject;", "resource", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "(Lio/kubernetes/client/common/KubernetesObject;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;)Lcom/intellij/kubernetes/view/vfs/ResourceContext;", "actionPerformed", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getOrCreateVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "context", "saveText", "file", "text", "", "intellij.clouds.kubernetes"})
public final class KubernetesDescribeResourceAction<T extends KubernetesObject>
extends KubernetesResourceVirtualFileBasedActionBase<T> {
    public KubernetesDescribeResourceAction() {
        super(Reflection.getOrCreateKotlinClass(KubernetesObject.class));
    }

    @Override
    @NotNull
    protected ResourceContext<T, ? extends KubernetesListObject> getContext(@NotNull T resource, @NotNull KubernetesResourceMapper<T, ?> mapper) {
        Intrinsics.checkNotNullParameter(resource, (String)"resource");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        return new ResourceContext(resource, mapper, true);
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        KubernetesUsageTriggerCollector.KubernetesEventWrapper<String> kubernetesEventWrapper = KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT();
        Project project = event2.getProject();
        Intrinsics.checkNotNull((Object)project);
        kubernetesEventWrapper.log(project, "describe-resources");
        super.actionPerformed(apiModel2, event2);
    }

    @Override
    @RequiresWriteLock
    @NotNull
    protected VirtualFile getOrCreateVirtualFile(@NotNull Project project, @NotNull ResourceContext<T, ?> context) {
        LightVirtualFileBase lightVirtualFileBase;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        KubernetesVirtualDirectory kubernetesVirtualDirectory = ResourceContextKt.getRootDirectory(context, project);
        String string = context.getResourceName$intellij_clouds_kubernetes();
        PlainTextFileType plainTextFileType = PlainTextFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextFileType, (String)"INSTANCE");
        LightVirtualFileBase $this$getOrCreateVirtualFile_u24lambda_u240 = lightVirtualFileBase = kubernetesVirtualDirectory.touch(string, (LanguageFileType)plainTextFileType);
        boolean bl = false;
        $this$getOrCreateVirtualFile_u24lambda_u240.setWritable(false);
        ResourceContextKt.setResourceContext((VirtualFile)$this$getOrCreateVirtualFile_u24lambda_u240, context);
        return (VirtualFile)lightVirtualFileBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void saveText(@NotNull VirtualFile file, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            file.setWritable(true);
            super.saveText(file, text);
        }
        finally {
            file.setWritable(false);
        }
    }
}

