/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.google.common.net.InetAddresses;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesObjectInfo;
import com.intellij.kubernetes.view.execution.KubernetesPortForwardingService;
import com.intellij.kubernetes.view.execution.PortForwarding;
import com.intellij.kubernetes.view.execution.PortForwardingProcess;
import com.intellij.kubernetes.view.ui.ComponentsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesModelBasedDumbAwareAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesPodForwardPortsAction;
import com.intellij.kubernetes.view.ui.actions.KubernetesPortForwardingNotificationService;
import com.intellij.kubernetes.view.ui.actions.KubernetesResourceActionBaseKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.util.coroutines.CollectionsKt;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ValidationInfoBuilder;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesModelBasedDumbAwareAction;", "<init>", "()V", "update", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Dialog", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesPodForwardPortsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction\n+ 2 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,240:1\n19#2:241\n12#2:242\n31#3,2:243\n*S KotlinDebug\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction\n*L\n52#1:241\n52#1:242\n76#1:243,2\n*E\n"})
public final class KubernetesPodForwardPortsAction
extends KubernetesModelBasedDumbAwareAction {
    @Override
    protected void update(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        List list2;
        KubernetesObject pod;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, "pod-forward-ports");
        AnActionEvent $this$selectedItem$iv = event2;
        boolean $i$f$getSelectedItem = false;
        DataContext dataContext = $this$selectedItem$iv.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext $this$selectedItem$iv$iv = dataContext;
        boolean $i$f$getSelectedItem2 = false;
        Object object = $this$selectedItem$iv$iv.getData(PlatformDataKeys.SELECTED_ITEM);
        KubernetesObject kubernetesObject = pod = object != null ? KubernetesResourceActionBaseKt.getResource(object) : null;
        if (pod == null) {
            String string = KubernetesBundle.message("progress.title.loading.content", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            list2 = (List)TasksKt.runWithModalProgressBlocking((Project)project2, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends KubernetesObject>>, Object>(apiModel2, null){
                int label;
                final /* synthetic */ KubernetesApiModel $apiModel;
                {
                    this.$apiModel = $apiModel;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = new KubernetesEntity[]{KubernetesEntity.Pod, KubernetesEntity.Deployment, KubernetesEntity.ReplicaSet};
                            this.label = 1;
                            v0 = CollectionsKt.mapConcurrent$default((Collection)kotlin.collections.CollectionsKt.listOf((Object[])var2_3), (int)0, (Function2)((Function2)new Function2<KubernetesEntity<? extends KubernetesObject, ? extends KubernetesListObject>, Continuation<? super List<? extends KubernetesObject>>, Object>(this.$apiModel, null){
                                int label;
                                /* synthetic */ Object L$0;
                                final /* synthetic */ KubernetesApiModel $apiModel;
                                {
                                    this.$apiModel = $apiModel;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            KubernetesEntity it = (KubernetesEntity)this.L$0;
                                            this.label = 1;
                                            Object object3 = this.$apiModel.getResource$intellij_clouds_kubernetes(it).getValue((Continuation)this);
                                            if (object3 != object2) return object3;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return object3;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value2;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(KubernetesEntity<? extends KubernetesObject, ? extends KubernetesListObject> p1, Continuation<? super List<? extends KubernetesObject>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this), (int)1, null);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            $this$sortedBy$iv = kotlin.collections.CollectionsKt.flatten((Iterable)((Iterable)v0));
                            $i$f$sortedBy = false;
                            return kotlin.collections.CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                public final int compare(T a, T b) {
                                    KubernetesObject it = (KubernetesObject)a;
                                    boolean bl = false;
                                    Comparable comparable = (Comparable)((Object)it.getMetadata().getName());
                                    it = (KubernetesObject)b;
                                    Comparable comparable2 = comparable;
                                    bl = false;
                                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getMetadata().getName())));
                                }
                            });
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super List<? extends KubernetesObject>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else {
            list2 = null;
        }
        List services2 = list2;
        Dialog dialog2 = new Dialog(project2, pod, services2);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.saveHistory();
        PortForwarding portForwarding = dialog2.getPortForwardingSettings();
        PortForwardingProcess process = (PortForwardingProcess)ActionsKt.runWriteAction(() -> KubernetesPodForwardPortsAction.actionPerformed$lambda$0(apiModel2, portForwarding));
        ComponentManager $this$service$iv = (ComponentManager)apiModel2.getProject();
        boolean $i$f$service = false;
        Class<KubernetesPortForwardingNotificationService> serviceClass$iv = KubernetesPortForwardingNotificationService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((KubernetesPortForwardingNotificationService)object2).subscribeOnProcessAndNotifyErrors(process);
    }

    private static final PortForwardingProcess actionPerformed$lambda$0(KubernetesApiModel $apiModel, PortForwarding $portForwarding) {
        return KubernetesPortForwardingService.Companion.getInstance().getOrCreatePortForwarding($apiModel, $portForwarding, true);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00112\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001d\u001a\u00020\u0014R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction$Dialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lio/kubernetes/client/common/KubernetesObject;", "availableServices", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lio/kubernetes/client/common/KubernetesObject;Ljava/util/List;)V", "getTarget", "()Lio/kubernetes/client/common/KubernetesObject;", "getAvailableServices", "()Ljava/util/List;", "targetComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "addresses", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "ports", "setupFieldWithHistory", "", "field", "defaultValue", "", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getPortForwardingSettings", "Lcom/intellij/kubernetes/view/execution/PortForwarding;", "saveHistory", "Companion", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesPodForwardPortsAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction$Dialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,240:1\n1#2:241\n19#3:242\n*S KotlinDebug\n*F\n+ 1 KubernetesPodForwardPortsAction.kt\ncom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction$Dialog\n*L\n168#1:242\n*E\n"})
    private static final class Dialog
    extends DialogWrapper {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Nullable
        private final KubernetesObject target;
        @Nullable
        private final List<KubernetesObject> availableServices;
        @Nullable
        private final ComboBox<KubernetesObject> targetComboBox;
        @NotNull
        private final TextFieldWithStoredHistory addresses;
        @NotNull
        private final TextFieldWithStoredHistory ports;
        @NotNull
        private static final String PORT = "\\d{1,5}";
        @NotNull
        private static final String PORT_MAPPING = "\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5}";
        @NotNull
        private static final Regex PORTS_PATTERN = new Regex("(?:\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5})(?:\\h+(?:\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5}))*");
        @NotNull
        private static final Regex PORT_MAPPING_PATTERN = new Regex("\\d{1,5}:\\d{1,5}|:\\d{1,5}|\\d{1,5}");

        /*
         * WARNING - void declaration
         */
        public Dialog(@Nullable Project project, @Nullable KubernetesObject target, @Nullable List<? extends KubernetesObject> availableServices) {
            super(project);
            ComboBox comboBox;
            this.target = target;
            this.availableServices = availableServices;
            Dialog dialog2 = this;
            List<KubernetesObject> list2 = this.availableServices;
            if (list2 != null) {
                void it;
                List<KubernetesObject> list3 = list2;
                Dialog dialog3 = dialog2;
                boolean bl = false;
                comboBox = ComponentsKt.kubernetesObjectCombox$default((List)it, null, 2, null);
                dialog2 = dialog3;
            } else {
                comboBox = null;
            }
            dialog2.targetComboBox = comboBox;
            this.addresses = new TextFieldWithStoredHistory(Dialog.class.getCanonicalName() + ".addresses");
            this.ports = new TextFieldWithStoredHistory(Dialog.class.getCanonicalName() + ".ports");
            this.setupFieldWithHistory(this.addresses, "localhost");
            Dialog.setupFieldWithHistory$default(this, this.ports, null, 2, null);
            this.setTitle(KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.title", new Object[0]));
            this.setOKButtonText(KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.okButton.text", new Object[0]));
            this.init();
        }

        @Nullable
        public final KubernetesObject getTarget() {
            return this.target;
        }

        @Nullable
        public final List<KubernetesObject> getAvailableServices() {
            return this.availableServices;
        }

        private final void setupFieldWithHistory(TextFieldWithStoredHistory field2, String defaultValue) {
            block1: {
                field2.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

                    protected JTextField createEditorComponent() {
                        ExpandableTextField expandableTextField;
                        ExpandableTextField $this$createEditorComponent_u24lambda_u240 = expandableTextField = new ExpandableTextField();
                        boolean bl = false;
                        $this$createEditorComponent_u24lambda_u240.setBorder(null);
                        $this$createEditorComponent_u24lambda_u240.setColumns(40);
                        return (JTextField)expandableTextField;
                    }
                });
                field2.setHistorySize(-1);
                field2.reset();
                List list2 = field2.getHistory();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHistory(...)");
                String string = (String)kotlin.collections.CollectionsKt.firstOrNull((List)list2);
                if (string == null) {
                    string = defaultValue;
                }
                if (string == null) break block1;
                String it = string;
                boolean bl = false;
                field2.setSelectedItem((Object)it);
            }
        }

        static /* synthetic */ void setupFieldWithHistory$default(Dialog dialog2, TextFieldWithStoredHistory textFieldWithStoredHistory, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            dialog2.setupFieldWithHistory(textFieldWithStoredHistory, string);
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel(arg_0 -> Dialog.createCenterPanel$lambda$12(this, arg_0));
        }

        @NotNull
        public JComponent getPreferredFocusedComponent() {
            return (JComponent)this.ports;
        }

        @NotNull
        public final PortForwarding getPortForwardingSettings() {
            Object object;
            block5: {
                block4: {
                    object = this.targetComboBox;
                    if (object == null || (object = object.getSelectedItem()) == null) break block4;
                    Object $this$asSafely$iv = object;
                    boolean $i$f$asSafely = false;
                    Object object2 = $this$asSafely$iv;
                    if (!(object2 instanceof KubernetesObject)) {
                        object2 = null;
                    }
                    if ((object = (KubernetesObject)object2) != null) break block5;
                }
                KubernetesObject kubernetesObject = this.target;
                object = kubernetesObject;
                Intrinsics.checkNotNull((Object)kubernetesObject);
            }
            KubernetesObjectInfo kubernetesObjectInfo = new KubernetesObjectInfo((KubernetesObject)object);
            String string = this.addresses.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{","};
            List list2 = kotlin.collections.CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            String string2 = this.ports.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            return new PortForwarding(kubernetesObjectInfo, list2, SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)PORT_MAPPING_PATTERN, (CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (int)0, (int)2, null), (Function1)((Function1)getPortForwardingSettings.1.INSTANCE))));
        }

        public final void saveHistory() {
            this.addresses.addCurrentTextToHistory();
            this.ports.addCurrentTextToHistory();
        }

        private static final Unit createCenterPanel$lambda$12$lambda$2(Dialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.cell((JComponent)this$0.targetComboBox);
            return Unit.INSTANCE;
        }

        private static final ValidationInfo createCenterPanel$lambda$12$lambda$7$lambda$4(ValidationInfoBuilder $this$validationOnApply, TextFieldWithStoredHistory it) {
            ValidationInfo validationInfo;
            block3: {
                Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getTextEditor().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String[] stringArray = new String[]{","};
                for (String address : (Iterable)StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
                    ValidationInfo validationInfo2;
                    ValidationInfo validationInfo3;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)address, (Object)"localhost") && !InetAddresses.isInetAddress((String)address)) {
                        Object[] objectArray = new Object[]{address};
                        String string2 = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.addresses.incorrect.message", objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                        validationInfo3 = $this$validationOnApply.error(string2);
                    } else {
                        validationInfo3 = null;
                    }
                    if ((validationInfo2 = validationInfo3) == null) continue;
                    validationInfo = validationInfo2;
                    break block3;
                }
                validationInfo = null;
            }
            return validationInfo;
        }

        private static final void createCenterPanel$lambda$12$lambda$7$lambda$6$lambda$5(Function0 $validate, ItemEvent it) {
            $validate.invoke();
        }

        private static final Unit createCenterPanel$lambda$12$lambda$7$lambda$6(Dialog this$0, Function0 validate) {
            Intrinsics.checkNotNullParameter((Object)validate, (String)"validate");
            this$0.addresses.addItemListener(arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$7$lambda$6$lambda$5(validate, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$12$lambda$7(Dialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.addresses), (String)KubernetesBundle.message("action.KubernetesPod.ForwardPorts.Dialog.addresses.comment", new Object[0]), (int)0, null, (int)6, null).validationOnApply(Dialog::createCenterPanel$lambda$12$lambda$7$lambda$4).validationRequestor(arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$7$lambda$6(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final ValidationInfo createCenterPanel$lambda$12$lambda$11$lambda$8(ValidationInfoBuilder $this$validationOnApply, TextFieldWithStoredHistory it) {
            ValidationInfo validationInfo;
            Intrinsics.checkNotNullParameter((Object)$this$validationOnApply, (String)"$this$validationOnApply");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (!PORTS_PATTERN.matches((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString())) {
                String string2 = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.ports.incorrect.message", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                validationInfo = $this$validationOnApply.error(string2);
            } else {
                validationInfo = null;
            }
            return validationInfo;
        }

        private static final void createCenterPanel$lambda$12$lambda$11$lambda$10$lambda$9(Function0 $validate, ItemEvent it) {
            $validate.invoke();
        }

        private static final Unit createCenterPanel$lambda$12$lambda$11$lambda$10(Dialog this$0, Function0 validate) {
            Intrinsics.checkNotNullParameter((Object)validate, (String)"validate");
            this$0.ports.addItemListener(arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$11$lambda$10$lambda$9(validate, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$12$lambda$11(Dialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            Object[] objectArray = new Object[]{"<code>7070:8080 9090:9090</code>"};
            Cell.comment$default((Cell)$this$row.cell((JComponent)this$0.ports), (String)KubernetesBundle.message("action.KubernetesPod.ForwardPorts.Dialog.ports.comment.template", objectArray), (int)0, null, (int)6, null).validationOnApply(Dialog::createCenterPanel$lambda$12$lambda$11$lambda$8).validationRequestor(arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$11$lambda$10(this$0, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$12(Dialog this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            if (this$0.targetComboBox != null) {
                String string = KubernetesBundle.message("PortForwardingView.table.heading.resource", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$2(this$0, arg_0));
            }
            String string = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.addresses.labelText", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $this$panel.row(string, arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$7(this$0, arg_0));
            String string2 = KubernetesBundle.message("action.Kubernetes.PodForwardPorts.Dialog.ports.labelText", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            $this$panel.row(string2, arg_0 -> Dialog.createCenterPanel$lambda$12$lambda$11(this$0, arg_0));
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodForwardPortsAction$Dialog$Companion;", "", "<init>", "()V", "PORT", "", "PORT_MAPPING", "PORTS_PATTERN", "Lkotlin/text/Regex;", "PORT_MAPPING_PATTERN", "intellij.clouds.kubernetes"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

