/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions.logs;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010'\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010)\u001a\u00020\u00112\b\u0010(\u001a\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u0011H\u0002J\b\u0010.\u001a\u00020\u0011H\u0002J\u0010\u0010/\u001a\u00020 2\u0006\u00100\u001a\u00020,H\u0002J\u0010\u00101\u001a\u00020 2\u0006\u00100\u001a\u00020,H\u0002J\b\u00102\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u00020\u0011H\u0002J\b\u00104\u001a\u00020\u0011H\u0002J\b\u00105\u001a\u00020\u0011H\u0002J\u0010\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u000208H\u0002R*\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u00078F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/logs/KubernetesDateTimeFilterComponent;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "value", "Ljava/time/Instant;", "beginDate", "getBeginDate", "()Ljava/time/Instant;", "setBeginDate", "(Ljava/time/Instant;)V", "endDate", "getEndDate", "setEndDate", "setUseBeginDateFilter", "", "isSelected", "", "setUseEndDateFilter", "getPanel", "Ljavax/swing/JPanel;", "myDatePanel", "myUseBeginDateFilter", "Ljavax/swing/JCheckBox;", "myUseEndDateFilter", "myRootPanel", "dateFormatter", "Ljava/text/SimpleDateFormat;", "timeFormatter", "beginDateField", "Ljavax/swing/JFormattedTextField;", "beginTimeField", "endDateField", "endTimeField", "last1HourButton", "Ljavax/swing/JButton;", "last24HoursButton", "setBeginDateTime", "instant", "setEndDateTime", "parseDateTime", "dateTimeStr", "", "updateBeginFieldsState", "updateEndFieldsState", "createFormattedDateField", "format", "createFormattedTimeField", "setLast1Hour", "setLast24Hours", "resetButtonColors", "setupUI", "addDateAndTimeFields", "gbc", "Ljava/awt/GridBagConstraints;", "intellij.clouds.kubernetes"})
public final class KubernetesDateTimeFilterComponent {
    @Nullable
    private Instant beginDate;
    @Nullable
    private Instant endDate;
    @NotNull
    private JPanel myDatePanel;
    @NotNull
    private JCheckBox myUseBeginDateFilter;
    @NotNull
    private JCheckBox myUseEndDateFilter;
    @NotNull
    private JPanel myRootPanel;
    @NotNull
    private final SimpleDateFormat dateFormatter;
    @NotNull
    private final SimpleDateFormat timeFormatter;
    @NotNull
    private JFormattedTextField beginDateField;
    @NotNull
    private JFormattedTextField beginTimeField;
    @NotNull
    private JFormattedTextField endDateField;
    @NotNull
    private JFormattedTextField endTimeField;
    @NotNull
    private JButton last1HourButton;
    @NotNull
    private JButton last24HoursButton;

    /*
     * WARNING - void declaration
     */
    public KubernetesDateTimeFilterComponent(@NotNull Project project) {
        void $this$last24HoursButton_u24lambda_u243;
        JButton $this$last1HourButton_u24lambda_u241;
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.myDatePanel = new JPanel(new GridBagLayout());
        this.myUseBeginDateFilter = new JCheckBox("Use Begin Date Filter");
        this.myUseEndDateFilter = new JCheckBox("Use End Date Filter");
        this.myRootPanel = new JPanel(new GridBagLayout());
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.timeFormatter = new SimpleDateFormat("HH:mm");
        JButton jButton2 = jButton = new JButton("Last hour");
        KubernetesDateTimeFilterComponent kubernetesDateTimeFilterComponent = this;
        boolean bl = false;
        $this$last1HourButton_u24lambda_u241.addActionListener(arg_0 -> KubernetesDateTimeFilterComponent.last1HourButton$lambda$1$lambda$0(this, project, arg_0));
        kubernetesDateTimeFilterComponent.last1HourButton = jButton;
        $this$last1HourButton_u24lambda_u241 = jButton = new JButton("Last 24 hours");
        kubernetesDateTimeFilterComponent = this;
        boolean bl2 = false;
        $this$last24HoursButton_u24lambda_u243.addActionListener(arg_0 -> KubernetesDateTimeFilterComponent.last24HoursButton$lambda$3$lambda$2(this, project, arg_0));
        kubernetesDateTimeFilterComponent.last24HoursButton = jButton;
        this.beginDateField = this.createFormattedDateField("####-##-##");
        this.beginTimeField = this.createFormattedTimeField("##:##");
        this.endDateField = this.createFormattedDateField("####-##-##");
        this.endTimeField = this.createFormattedTimeField("##:##");
        this.updateBeginFieldsState();
        this.updateEndFieldsState();
        this.myUseBeginDateFilter.addActionListener(arg_0 -> KubernetesDateTimeFilterComponent._init_$lambda$4(this, arg_0));
        this.myUseEndDateFilter.addActionListener(arg_0 -> KubernetesDateTimeFilterComponent._init_$lambda$5(this, arg_0));
        KeyAdapter keyAdapterForTextField2 = new KeyAdapter(this){
            final /* synthetic */ KubernetesDateTimeFilterComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    KubernetesDateTimeFilterComponent.access$getMyRootPanel$p(this.this$0).dispatchEvent(e);
                }
                KubernetesDateTimeFilterComponent.access$resetButtonColors(this.this$0);
            }
        };
        KeyAdapter keyAdapterForButtons2 = new KeyAdapter(this){
            final /* synthetic */ KubernetesDateTimeFilterComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    KubernetesDateTimeFilterComponent.access$getMyRootPanel$p(this.this$0).dispatchEvent(e);
                }
            }
        };
        this.myUseBeginDateFilter.addKeyListener(keyAdapterForButtons2);
        this.myUseEndDateFilter.addKeyListener(keyAdapterForButtons2);
        this.beginDateField.addKeyListener(keyAdapterForTextField2);
        this.beginTimeField.addKeyListener(keyAdapterForTextField2);
        this.endDateField.addKeyListener(keyAdapterForTextField2);
        this.endTimeField.addKeyListener(keyAdapterForTextField2);
        this.last1HourButton.addKeyListener(keyAdapterForButtons2);
        this.last24HoursButton.addKeyListener(keyAdapterForButtons2);
        this.setupUI();
    }

    @Nullable
    public final Instant getBeginDate() {
        return this.myUseBeginDateFilter.isSelected() ? this.parseDateTime(this.beginDateField.getText() + " " + this.beginTimeField.getText()) : null;
    }

    public final void setBeginDate(@Nullable Instant value2) {
        this.beginDate = value2;
        this.setBeginDateTime(value2);
    }

    @Nullable
    public final Instant getEndDate() {
        return this.myUseEndDateFilter.isSelected() ? this.parseDateTime(this.endDateField.getText() + " " + this.endTimeField.getText()) : null;
    }

    public final void setEndDate(@Nullable Instant value2) {
        this.endDate = value2;
        this.setEndDateTime(value2);
    }

    public final void setUseBeginDateFilter(boolean isSelected) {
        this.myUseBeginDateFilter.setSelected(isSelected);
        this.updateBeginFieldsState();
    }

    public final void setUseEndDateFilter(boolean isSelected) {
        this.myUseEndDateFilter.setSelected(isSelected);
        this.updateEndFieldsState();
    }

    @NotNull
    public final JPanel getPanel() {
        return this.myRootPanel;
    }

    private final void setBeginDateTime(Instant instant) {
        block0: {
            Instant instant2 = instant;
            if (instant2 == null) break block0;
            Instant it = instant2;
            boolean bl = false;
            this.beginDateField.setText(this.dateFormatter.format(Date.from(it)));
            this.beginTimeField.setText(this.timeFormatter.format(Date.from(it)));
        }
    }

    private final void setEndDateTime(Instant instant) {
        block0: {
            Instant instant2 = instant;
            if (instant2 == null) break block0;
            Instant it = instant2;
            boolean bl = false;
            this.endDateField.setText(this.dateFormatter.format(Date.from(it)));
            this.endTimeField.setText(this.timeFormatter.format(Date.from(it)));
        }
    }

    private final Instant parseDateTime(String dateTimeStr) {
        Instant instant;
        try {
            Date parsedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(dateTimeStr);
            instant = parsedDate.toInstant();
        }
        catch (Exception e) {
            instant = null;
        }
        return instant;
    }

    private final void updateBeginFieldsState() {
        boolean isSelected = this.myUseBeginDateFilter.isSelected();
        this.beginDateField.setEditable(isSelected);
        this.beginTimeField.setEditable(isSelected);
        if (!isSelected) {
            this.beginDateField.setForeground((Color)JBColor.WHITE);
            this.beginTimeField.setForeground((Color)JBColor.WHITE);
            this.resetButtonColors();
        } else {
            this.beginDateField.setForeground((Color)JBColor.BLACK);
            this.beginTimeField.setForeground((Color)JBColor.BLACK);
        }
    }

    private final void updateEndFieldsState() {
        boolean isSelected = this.myUseEndDateFilter.isSelected();
        this.endDateField.setEditable(isSelected);
        this.endTimeField.setEditable(isSelected);
        if (!isSelected) {
            this.endDateField.setForeground((Color)JBColor.WHITE);
            this.endTimeField.setForeground((Color)JBColor.WHITE);
        } else {
            this.endDateField.setForeground((Color)JBColor.BLACK);
            this.endTimeField.setForeground((Color)JBColor.BLACK);
        }
    }

    private final JFormattedTextField createFormattedDateField(String format) {
        JFormattedTextField jFormattedTextField;
        try {
            MaskFormatter formatter = new MaskFormatter(format);
            formatter.setPlaceholderCharacter('_');
            jFormattedTextField = new JFormattedTextField(formatter);
        }
        catch (Exception e) {
            jFormattedTextField = new JFormattedTextField();
        }
        return jFormattedTextField;
    }

    private final JFormattedTextField createFormattedTimeField(String format) {
        JFormattedTextField jFormattedTextField;
        try {
            MaskFormatter formatter = new MaskFormatter(format);
            formatter.setPlaceholderCharacter('_');
            jFormattedTextField = new JFormattedTextField(formatter);
        }
        catch (Exception e) {
            jFormattedTextField = new JFormattedTextField();
        }
        return jFormattedTextField;
    }

    private final void setLast1Hour() {
        Instant now = Instant.now();
        Instant oneHourAgo = now.minusSeconds(3600L);
        this.setUseBeginDateFilter(true);
        this.setBeginDate(oneHourAgo);
        this.resetButtonColors();
        this.last1HourButton.setForeground((Color)JBColor.BLUE);
    }

    private final void setLast24Hours() {
        Instant now = Instant.now();
        Instant twentyFourHoursAgo = now.minusSeconds(86400L);
        this.setUseBeginDateFilter(true);
        this.setBeginDate(twentyFourHoursAgo);
        this.resetButtonColors();
        this.last24HoursButton.setForeground((Color)JBColor.BLUE);
    }

    private final void resetButtonColors() {
        this.last1HourButton.setForeground((Color)JBColor.BLACK);
        this.last24HoursButton.setForeground((Color)JBColor.BLACK);
    }

    private final void setupUI() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.myRootPanel.setLayout(new BoxLayout(this.myRootPanel, 1));
        this.myDatePanel.setLayout(new GridBagLayout());
        gbc.insets = (Insets)JBUI.insets((int)5);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 10;
        this.myDatePanel.add((Component)this.last1HourButton, gbc);
        gbc.gridx = 1;
        this.myDatePanel.add((Component)this.last24HoursButton, gbc);
        this.addDateAndTimeFields(gbc);
        this.myRootPanel.add(this.myDatePanel);
    }

    private final void addDateAndTimeFields(GridBagConstraints gbc) {
        Font consistentFont = new Font("Monospaced", 0, 13);
        gbc.gridx = 0;
        int n = gbc.gridy;
        gbc.gridy = n + 1;
        gbc.gridwidth = 2;
        this.myDatePanel.add((Component)this.myUseBeginDateFilter, gbc);
        n = gbc.gridy;
        gbc.gridy = n + 1;
        gbc.gridwidth = 1;
        this.myDatePanel.add((Component)new JLabel("Date (Begin):"), gbc);
        gbc.gridx = 1;
        this.beginDateField.setFont(consistentFont);
        this.myDatePanel.add((Component)this.beginDateField, gbc);
        gbc.gridx = 2;
        this.myDatePanel.add((Component)new JLabel("Time (Begin):"), gbc);
        gbc.gridx = 3;
        this.beginTimeField.setFont(consistentFont);
        this.myDatePanel.add((Component)this.beginTimeField, gbc);
        gbc.gridx = 0;
        n = gbc.gridy;
        gbc.gridy = n + 1;
        gbc.gridwidth = 2;
        this.myDatePanel.add((Component)this.myUseEndDateFilter, gbc);
        n = gbc.gridy;
        gbc.gridy = n + 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        this.myDatePanel.add((Component)new JLabel("Date (End):"), gbc);
        gbc.gridx = 1;
        this.endDateField.setFont(consistentFont);
        this.myDatePanel.add((Component)this.endDateField, gbc);
        gbc.gridx = 2;
        this.myDatePanel.add((Component)new JLabel("Time (End):"), gbc);
        gbc.gridx = 3;
        this.endTimeField.setFont(consistentFont);
        this.myDatePanel.add((Component)this.endTimeField, gbc);
    }

    private static final void last1HourButton$lambda$1$lambda$0(KubernetesDateTimeFilterComponent this$0, Project $project, ActionEvent it) {
        this$0.setLast1Hour();
        KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log($project, "logs-select-date-time-show-last-hour-action");
    }

    private static final void last24HoursButton$lambda$3$lambda$2(KubernetesDateTimeFilterComponent this$0, Project $project, ActionEvent it) {
        this$0.setLast24Hours();
        KubernetesUsageTriggerCollector.INSTANCE.getLOGS_API_ACTION_TRIGGERED().log($project, "logs-select-date-time-show-last-24-hours-action");
    }

    private static final void _init_$lambda$4(KubernetesDateTimeFilterComponent this$0, ActionEvent it) {
        this$0.updateBeginFieldsState();
        if (this$0.myUseBeginDateFilter.isSelected()) {
            this$0.setLast1Hour();
        }
    }

    private static final void _init_$lambda$5(KubernetesDateTimeFilterComponent this$0, ActionEvent it) {
        this$0.updateEndFieldsState();
        if (this$0.myUseEndDateFilter.isSelected()) {
            this$0.setEndDateTime(Instant.now());
        }
    }

    public static final /* synthetic */ JPanel access$getMyRootPanel$p(KubernetesDateTimeFilterComponent $this) {
        return $this.myRootPanel;
    }

    public static final /* synthetic */ void access$resetButtonColors(KubernetesDateTimeFilterComponent $this) {
        $this.resetButtonColors();
    }
}

