/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.postprocessors.methodinvoker;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.gsonfire.PostProcessor;
import io.gsonfire.annotations.ExposeMethodResult;
import io.gsonfire.gson.FireExclusionStrategy;
import io.gsonfire.gson.FireExclusionStrategyComposite;
import io.gsonfire.postprocessors.methodinvoker.MappedMethod;
import io.gsonfire.postprocessors.methodinvoker.MappedMethodInspector;
import java.lang.reflect.InvocationTargetException;

public final class MethodInvokerPostProcessor<T>
implements PostProcessor<T> {
    private static MappedMethodInspector methodInspector = new MappedMethodInspector();
    private final FireExclusionStrategy serializationExclusionStrategy;

    public MethodInvokerPostProcessor() {
        this(new FireExclusionStrategyComposite(new FireExclusionStrategy[0]));
    }

    public MethodInvokerPostProcessor(FireExclusionStrategy serializationExclusionStrategy) {
        this.serializationExclusionStrategy = serializationExclusionStrategy;
    }

    @Override
    public void postDeserialize(T result2, JsonElement src, Gson gson) {
    }

    @Override
    public void postSerialize(JsonElement result2, T src, Gson gson) {
        if (result2.isJsonObject()) {
            JsonObject jsonObject = result2.getAsJsonObject();
            for (MappedMethod m : methodInspector.getAnnotatedMembers(src.getClass(), ExposeMethodResult.class)) {
                if (this.serializationExclusionStrategy.shouldSkipMethod(m)) continue;
                try {
                    if (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.OVERWRITE && (m.getConflictResolutionStrategy() != ExposeMethodResult.ConflictResolutionStrategy.SKIP || jsonObject.has(m.getSerializedName()))) continue;
                    Object value2 = m.getMethod().invoke(src, new Object[0]);
                    jsonObject.add(m.getSerializedName(), gson.toJsonTree(value2));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

