/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.custom;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.QuantityFormatter;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.commons.lang3.ObjectUtils;

@JsonAdapter(value=QuantityAdapter.class)
public class Quantity {
    private final BigDecimal number;
    private Format format;

    public Quantity(BigDecimal number, Format format) {
        this.number = number;
        this.format = format;
    }

    public Quantity(String value2) {
        Quantity quantity = Quantity.fromString(value2);
        this.number = quantity.number;
        this.format = quantity.format;
    }

    public BigDecimal getNumber() {
        return this.number;
    }

    public Format getFormat() {
        return this.format;
    }

    public static Quantity fromString(String value2) {
        return new QuantityFormatter().parse(value2);
    }

    public String toSuffixedString() {
        return new QuantityFormatter().format(this);
    }

    public String toString() {
        return "Quantity{number=" + this.number + ", format=" + (Object)((Object)this.format) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Quantity otherQuantity = (Quantity)o;
        return ObjectUtils.compare((Comparable)this.number, (Comparable)otherQuantity.number) == 0;
    }

    public static enum Format {
        DECIMAL_EXPONENT(10),
        DECIMAL_SI(10),
        BINARY_SI(2);

        private int base;

        private Format(int base) {
            this.base = base;
        }

        public int getBase() {
            return this.base;
        }
    }

    public static class QuantityAdapter
    extends TypeAdapter<Quantity> {
        public void write(JsonWriter jsonWriter, Quantity quantity) throws IOException {
            jsonWriter.value(quantity != null ? quantity.toSuffixedString() : null);
        }

        public Quantity read(JsonReader jsonReader) throws IOException {
            return Quantity.fromString(jsonReader.nextString());
        }
    }
}

