/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.framework;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FileContentPattern;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.framework.JavaeeFrameworkDetector;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.facet.WebFacetConfiguration;
import com.intellij.javaee.web.facet.WebFacetType;
import com.intellij.javaee.web.facet.WebRootData;
import com.intellij.javaee.web.framework.WebFrameworkType;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ObjectPattern;
import com.intellij.util.indexing.FileContent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class WebFrameworkDetector
extends JavaeeFrameworkDetector<WebFacet, WebFacetConfiguration> {
    public WebFrameworkDetector() {
        super("web");
    }

    @NotNull
    public ElementPattern<FileContent> createSuitableFilePattern() {
        ObjectPattern objectPattern = FileContentPattern.fileContent().withName(DeploymentDescriptorsConstants.WEB_XML_META_DATA.getFileName()).andOr(new ElementPattern[]{FileContentPattern.fileContent().xmlWithRootTag("web-app"), FileContentPattern.fileContent().inDirectory("WEB-INF")});
        if (objectPattern == null) {
            WebFrameworkDetector.$$$reportNull$$$0(0);
        }
        return objectPattern;
    }

    @NotNull
    public WebFacetType getFacetType() {
        WebFacetType webFacetType = WebFacetType.getInstance();
        if (webFacetType == null) {
            WebFrameworkDetector.$$$reportNull$$$0(1);
        }
        return webFacetType;
    }

    @NotNull
    public FrameworkType getFrameworkType() {
        WebFrameworkType webFrameworkType = WebFrameworkType.getInstance();
        if (webFrameworkType == null) {
            WebFrameworkDetector.$$$reportNull$$$0(2);
        }
        return webFrameworkType;
    }

    public void setupFacet(@NotNull WebFacet facet, ModifiableRootModel model) {
        if (facet == null) {
            WebFrameworkDetector.$$$reportNull$$$0(3);
        }
        String[] sourceRootUrls = model.getSourceRootUrls(false);
        ((WebFacetConfiguration)facet.getConfiguration()).setSourceRoots(Arrays.asList(sourceRootUrls));
    }

    protected void setupConfiguration(WebFacetConfiguration configuration, VirtualFile file) {
        VirtualFile parent = file.getParent();
        if (parent != null) {
            VirtualFile grandParent = parent.getParent();
            String webInf = DeploymentDescriptorsConstants.WEB_XML_META_DATA.getDirectoryPath();
            WebRootData webRoot = grandParent != null && webInf.equals(parent.getName()) ? new WebRootData(grandParent.getUrl(), "/") : new WebRootData(parent.getUrl(), "/" + webInf);
            configuration.addWebRoot(webRoot);
        }
    }

    public List<? extends DetectedFrameworkDescription> detect(@NotNull Collection<? extends VirtualFile> newFiles, @NotNull FrameworkDetectionContext context) {
        Project project;
        if (newFiles == null) {
            WebFrameworkDetector.$$$reportNull$$$0(4);
        }
        if (context == null) {
            WebFrameworkDetector.$$$reportNull$$$0(5);
        }
        if ((project = context.getProject()) != null) {
            boolean isNewlyCreatedProject;
            boolean bl = isNewlyCreatedProject = project.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
            if (isNewlyCreatedProject) {
                return Collections.emptyList();
            }
        }
        return super.detect(newFiles, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/framework/WebFrameworkDetector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFiles";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuitableFilePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/framework/WebFrameworkDetector";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupFacet";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

