/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.validation;

import com.intellij.compiler.options.ValidationConfiguration;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.javaee.web.model.xml.WebAppVersion;
import com.intellij.javaee.web.validation.JasperArtifactValidator;
import com.intellij.javaee.web.validation.JasperVersion;
import com.intellij.lang.jsp.JspVersion;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.Validator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class JasperValidationPreparationTask
implements CompileTask {
    private static final Logger LOG = Logger.getInstance(JasperValidationPreparationTask.class);
    private static final Key<String> JASPER_VERSION_KEY = Key.create((String)"JASPER.VERSION");
    private static final Key<String> JASPER_CLASSPATH_KEY = Key.create((String)"JASPER.CLASSPATH");
    private static final Key<Boolean> JASPER_REQUIRES_JAVA_COMPILER_KEY = Key.create((String)"JASPER.REQUIRES.JAVA.COMPILER");

    public boolean execute(@NotNull CompileContext context) {
        JasperVersion jasperVersion;
        Project project;
        if (context == null) {
            JasperValidationPreparationTask.$$$reportNull$$$0(0);
        }
        if (!ValidationConfiguration.shouldValidate((Validator)JasperArtifactValidator.getInstance(project = context.getProject()), (Project)project) && !JasperArtifactValidator.shouldRunValidation(context.getCompileScope())) {
            return true;
        }
        ArrayList jdkUrls = new ArrayList();
        JasperVersion detectedVersion = (JasperVersion)((Object)ReadAction.compute(() -> {
            Set artifactsToBuild = ArtifactCompileScope.getArtifactsToBuild((Project)project, (CompileScope)context.getCompileScope(), (boolean)true);
            List explodedWebArtifacts = ContainerUtil.filter((Collection)artifactsToBuild, a -> a.getArtifactType().equals(WebArtifactUtil.getInstance().getExplodedWarArtifactType()));
            Set modules = ArtifactUtil.getModulesIncludedInArtifacts((Collection)explodedWebArtifacts, (Project)project);
            Sdk jdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
            if (jdk == null) {
                context.addMessage(CompilerMessageCategory.ERROR, WebBundle.message("cannot.run.jsp.validation.project.jdk.isn.t.specified", new Object[0]), null, -1, -1);
                return null;
            }
            JavaSdkVersion projectJdkVersion = JavaSdk.getInstance().getVersion(jdk);
            if (projectJdkVersion == null) {
                context.addMessage(CompilerMessageCategory.ERROR, WebBundle.message("cannot.run.jsp.validation.failed.to.determine.version.of.project.jdk.0", jdk.getHomePath()), null, -1, -1);
                return null;
            }
            jdkUrls.addAll(Arrays.asList(jdk.getRootProvider().getUrls(OrderRootType.CLASSES)));
            return JasperValidationPreparationTask.getJasperVersion(modules, projectJdkVersion);
        }));
        if (detectedVersion == null) {
            return true;
        }
        if (detectedVersion == JasperVersion.V20) {
            jasperVersion = JasperVersion.V21;
            context.addMessage(CompilerMessageCategory.WARNING, WebBundle.message("jsp.2.0.validation.is.not.supported.anymore.jsp.2.1.will.be.used.instead", new Object[0]), null, -1, -1);
        } else {
            jasperVersion = detectedVersion;
        }
        context.getCompileScope().putUserData(JASPER_VERSION_KEY, (Object)jasperVersion.getVersionString());
        context.getCompileScope().putUserData(JASPER_REQUIRES_JAVA_COMPILER_KEY, (Object)ApplicationManager.getApplication().isUnitTestMode());
        if (!JasperValidationPreparationTask.downloadJasperJars(context, jasperVersion)) {
            return true;
        }
        Object[] jars = JasperValidationPreparationTask.getDownloadedJasperJars(jasperVersion);
        PathsList classPath = new PathsList();
        Condition prependFilter = file -> file.getName().matches(".*-patch\\.jar");
        classPath.add(JasperValidationPreparationTask.getJasperRuntimeModulePath(jasperVersion));
        if (jasperVersion == JasperVersion.V23JAVA8) {
            classPath.add(JasperValidationPreparationTask.getJasperRuntimeModulePath(JasperVersion.V23JAVA7));
        }
        classPath.add(JasperValidationPreparationTask.getJasperRuntimeModulePath(JasperVersion.V20));
        classPath.addAllFiles(ContainerUtil.filter((Object[])jars, (Condition)Conditions.not((Condition)prependFilter)));
        for (String url : jdkUrls) {
            classPath.add(PathUtil.getLocalPath((String)VfsUtilCore.urlToPath((String)url)));
        }
        context.getCompileScope().putUserData(JASPER_CLASSPATH_KEY, (Object)classPath.getPathsString());
        return true;
    }

    @NotNull
    private static String getJasperRuntimeModulePath(JasperVersion jasperVersion) {
        File jasperJar;
        String moduleNameSuffix = jasperVersion.getModuleNameSuffix();
        File classesRoot = new File(PathUtil.getJarPathForClass(JasperValidationPreparationTask.class));
        if (classesRoot.isFile()) {
            String subDirectory = jasperVersion == JasperVersion.V20 ? "" : "rt/";
            jasperJar = new File(PathManager.getHomePath(), "plugins/JavaEE/lib/" + subDirectory + "jasper-" + moduleNameSuffix.replace('.', '-') + ".jar");
        } else {
            jasperJar = new File(classesRoot.getParentFile(), "intellij.javaee.jasper." + moduleNameSuffix);
        }
        LOG.assertTrue(jasperJar.exists(), (Object)("Jasper JAR file not found: " + jasperJar.getAbsolutePath()));
        String string = jasperJar.getAbsolutePath();
        if (string == null) {
            JasperValidationPreparationTask.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static File getJasperDownloadDir(JasperVersion version) {
        return new File(PathManager.getSystemPath(), "download-cache/jasper/" + version.getVersionString());
    }

    private static File[] getDownloadedJasperJars(JasperVersion version) {
        return (File[])ObjectUtils.notNull((Object)JasperValidationPreparationTask.getJasperDownloadDir(version).listFiles(FileFilters.filesWithExtension((String)"jar")), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
    }

    private static boolean downloadJasperJars(CompileContext context, JasperVersion version) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        File[] files = JasperValidationPreparationTask.getDownloadedJasperJars(version);
        if (files.length != 0) {
            return true;
        }
        File downloadDir = JasperValidationPreparationTask.getJasperDownloadDir(version);
        DownloadableFileService service = DownloadableFileService.getInstance();
        DownloadableFileSetVersions versions = service.createFileSetVersions(null, new URL[]{JasperValidationPreparationTask.class.getResource("/library/jasper.xml")});
        DownloadableFileSetDescription description = JasperValidationPreparationTask.findJasperJarsFileSet((DownloadableFileSetVersions<DownloadableFileSetDescription>)versions, version);
        if (description == null) {
            context.addMessage(CompilerMessageCategory.ERROR, WebBundle.message("cannot.find.jasper.validator.for.0", version.getVersionString()), null, -1, -1);
            return false;
        }
        try {
            List pairs = service.createDownloader(description).download(downloadDir);
            if (pairs.isEmpty() || JasperValidationPreparationTask.getDownloadedJasperJars(version).length == 0) {
                context.addMessage(CompilerMessageCategory.ERROR, WebBundle.message("jasper.validator.jars.not.downloaded", new Object[0]), null, -1, -1);
                return false;
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            context.addMessage(CompilerMessageCategory.ERROR, WebBundle.message("failed.to.download.jasper.validator.jars.0", e.getMessage()), null, -1, -1);
            return false;
        }
        return true;
    }

    private static DownloadableFileSetDescription findJasperJarsFileSet(DownloadableFileSetVersions<DownloadableFileSetDescription> versions, JasperVersion version) {
        List descriptions = versions.fetchVersions();
        for (DownloadableFileSetDescription description : descriptions) {
            if (!description.getVersionString().equals(version.getVersionString())) continue;
            return description;
        }
        return null;
    }

    @NotNull
    private static JasperVersion getJasperVersion(@NotNull Set<Module> modules, @NotNull JavaSdkVersion projectSdkVersion) {
        if (modules == null) {
            JasperValidationPreparationTask.$$$reportNull$$$0(2);
        }
        if (projectSdkVersion == null) {
            JasperValidationPreparationTask.$$$reportNull$$$0(3);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            JasperVersion jasperVersion = JasperVersion.V23JAVA8;
            if (jasperVersion == null) {
                JasperValidationPreparationTask.$$$reportNull$$$0(4);
            }
            return jasperVersion;
        }
        JspVersion jspVersion = JasperValidationPreparationTask.getJspVersion(modules);
        if (jspVersion == JspVersion.JSP_2_0 || !projectSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_5)) {
            JasperVersion jasperVersion = JasperVersion.V20;
            if (jasperVersion == null) {
                JasperValidationPreparationTask.$$$reportNull$$$0(5);
            }
            return jasperVersion;
        }
        if (projectSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_8)) {
            JasperVersion jasperVersion = JasperVersion.V23JAVA8;
            if (jasperVersion == null) {
                JasperValidationPreparationTask.$$$reportNull$$$0(6);
            }
            return jasperVersion;
        }
        if (jspVersion.betterThan(JspVersion.JSP_2_1) && projectSdkVersion.isAtLeast(JavaSdkVersion.JDK_1_7)) {
            JasperVersion jasperVersion = JasperVersion.V23JAVA7;
            if (jasperVersion == null) {
                JasperValidationPreparationTask.$$$reportNull$$$0(7);
            }
            return jasperVersion;
        }
        JasperVersion jasperVersion = JasperVersion.V21;
        if (jasperVersion == null) {
            JasperValidationPreparationTask.$$$reportNull$$$0(8);
        }
        return jasperVersion;
    }

    @NotNull
    private static JspVersion getJspVersion(Set<Module> modules) {
        JspVersion maxVersion = null;
        for (Module module : modules) {
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                WebAppVersion version;
                WebApp root = webFacet.getRoot();
                if (root == null || (version = (WebAppVersion)root.getVersion().getValue()) == null) continue;
                JspVersion jspVersion = version.getJspVersion();
                if (maxVersion != null && !jspVersion.betterThan(maxVersion)) continue;
                maxVersion = jspVersion;
            }
        }
        JspVersion jspVersion = maxVersion != null ? maxVersion : JspVersion.MAX_VERSION;
        if (jspVersion == null) {
            JasperValidationPreparationTask.$$$reportNull$$$0(9);
        }
        return jspVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/web/validation/JasperValidationPreparationTask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSdkVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/web/validation/JasperValidationPreparationTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getJasperRuntimeModulePath";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJasperVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJspVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJasperVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }
}

