/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.console;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.io.Serializable;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.console.GrSelectModuleAction;
import org.jetbrains.plugins.groovy.console.GroovyConsole;
import org.jetbrains.plugins.groovy.console.GroovyConsoleStateService;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtil;
import org.jetbrains.plugins.groovy.console.GroovyConsoleUtilKt;
import org.jetbrains.plugins.groovy.util.ModuleChooserUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/groovy/console/GrSelectModuleAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "consoleService", "Lorg/jetbrains/plugins/groovy/console/GroovyConsoleStateService;", "getConsoleService", "()Lorg/jetbrains/plugins/groovy/console/GroovyConsoleStateService;", "consoleService$delegate", "Lkotlin/Lazy;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "displayTextInToolbar", "", "actionPerformed", "moduleSelected", "module", "Lcom/intellij/openapi/module/Module;", "intellij.groovy"})
public final class GrSelectModuleAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @NotNull
    private final Lazy consoleService$delegate;

    public GrSelectModuleAction(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(GroovyBundle.message("select.module.action.text", new Object[0]), GroovyBundle.message("select.module.action.description", new Object[0]), AllIcons.Nodes.Module);
        this.project = project;
        this.file = file;
        this.consoleService$delegate = LazyKt.lazy(() -> GrSelectModuleAction.consoleService_delegate$lambda$0(this));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private final GroovyConsoleStateService getConsoleService() {
        Lazy lazy = this.consoleService$delegate;
        return (GroovyConsoleStateService)lazy.getValue();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Module module = this.getConsoleService().getSelectedModule(this.file);
        if (module == null || module.isDisposed()) {
            return;
        }
        e.getPresentation().setText(GroovyConsoleUtil.getTitle(module));
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Serializable serializable = e.getInputEvent();
        if (serializable == null || (serializable = serializable.getComponent()) == null) {
            return;
        }
        Serializable component = serializable;
        ListPopup popup2 = ModuleChooserUtil.createSelectModulePopup(this.project, GroovyConsoleUtilKt.getApplicableModules(this.project), (Function1<? super Module, String>)((Function1)actionPerformed.popup.1.INSTANCE), (Function1<? super Module, Unit>)((Function1)new Function1<Module, Unit>((Object)this){

            public final void invoke(Module p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                GrSelectModuleAction.access$moduleSelected((GrSelectModuleAction)((Object)this.receiver), p0);
            }
        }));
        popup2.showUnderneathOf((Component)component);
    }

    private final void moduleSelected(Module module) {
        if (Intrinsics.areEqual((Object)this.getConsoleService().getSelectedModule(this.file), (Object)module)) {
            return;
        }
        GroovyConsole.stopConsole(this.file);
        this.getConsoleService().setFileModule(this.file, module);
    }

    private static final GroovyConsoleStateService consoleService_delegate$lambda$0(GrSelectModuleAction this$0) {
        return GroovyConsoleStateService.Companion.getInstance(this$0.project);
    }

    public static final /* synthetic */ void access$moduleSelected(GrSelectModuleAction $this, Module module) {
        $this.moduleSelected(module);
    }
}

