/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.resolve.CompilationPhaseHint;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.FindFirstProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u001a2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f0\b\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/DuplicateVariableProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/FindFirstProcessor;", "Lorg/jetbrains/plugins/groovy/lang/resolve/ElementResolveResult;", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "variable", "<init>", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;)V", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/annotations/NotNull;", "hasVisibilityModifier", "", "result", "element", "Lcom/intellij/psi/PsiElement;", "state", "Lcom/intellij/psi/ResolveState;", "myBorderPassed", "handleEvent", "", "event", "Lcom/intellij/psi/scope/PsiScopeProcessor$Event;", "associated", "", "shouldStop", "Companion", "intellij.groovy.psi"})
public final class DuplicateVariableProcessor
extends FindFirstProcessor<ElementResolveResult<? extends GrVariable>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GrVariable variable;
    @NotNull
    private final String name;
    private final boolean hasVisibilityModifier;
    private boolean myBorderPassed;

    public DuplicateVariableProcessor(@NotNull GrVariable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        this.variable = variable;
        String string = this.variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        this.name = string;
        this.nameHint(this.name);
        this.hint(CompilationPhaseHint.HINT_KEY, DuplicateVariableProcessor::_init_$lambda$0);
        this.hasVisibilityModifier = DuplicateVariableProcessor.Companion.hasExplicitVisibilityModifiers(this.variable);
    }

    @Override
    @Nullable
    protected ElementResolveResult<GrVariable> result(@NotNull PsiElement element, @NotNull ResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!(element instanceof GrVariable) || element instanceof GrBindingVariable) {
            return null;
        }
        if (Intrinsics.areEqual((Object)element, (Object)this.variable)) {
            return null;
        }
        if (DuplicateVariableProcessor.Companion.hasExplicitVisibilityModifiers((GrVariable)element) != this.hasVisibilityModifier) {
            return null;
        }
        return new ElementResolveResult<PsiElement>(element);
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event, (Object)ResolveUtil.DECLARATION_SCOPE_PASSED) || !(associated instanceof PsiElement)) {
            return;
        }
        if (associated instanceof GrClosableBlock && Intrinsics.areEqual((Object)"owner", (Object)this.name) || associated instanceof PsiClass && !(associated instanceof PsiAnonymousClass) || associated instanceof GrMethod && ((GrMethod)associated).getParent() instanceof GroovyFile) {
            this.myBorderPassed = true;
        }
    }

    @Override
    protected boolean shouldStop() {
        return this.myBorderPassed;
    }

    private static final CompilationPhaseHint.Phase _init_$lambda$0() {
        return CompilationPhaseHint.Phase.CONVERSION;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/DuplicateVariableProcessor$Companion;", "", "<init>", "()V", "hasExplicitVisibilityModifiers", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/GrVariable;", "intellij.groovy.psi"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasExplicitVisibilityModifiers(GrVariable $this$hasExplicitVisibilityModifiers) {
            GrModifierList grModifierList = $this$hasExplicitVisibilityModifiers.getModifierList();
            return grModifierList != null ? grModifierList.hasExplicitVisibilityModifiers() : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

