/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.HttpMethod;
import io.ktor.http.HttpProtocolVersion;
import io.ktor.http.cio.ChunkedTransferEncodingKt;
import io.ktor.http.cio.ConnectionOptions;
import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.Request;
import io.ktor.http.cio.internals.CharsKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelJVMKt;
import io.ktor.utils.io.ByteWriteChannel;
import java.util.Locale;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001aG\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\u001a)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001b\u001a=\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001c\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"expectHttpBody", "", "method", "Lio/ktor/http/HttpMethod;", "contentLength", "", "transferEncoding", "", "connectionOptions", "Lio/ktor/http/cio/ConnectionOptions;", "contentType", "request", "Lio/ktor/http/cio/Request;", "expectHttpUpgrade", "upgrade", "isTransferEncodingChunked", "parseHttpBody", "", "version", "Lio/ktor/http/HttpProtocolVersion;", "input", "Lio/ktor/utils/io/ByteReadChannel;", "out", "Lio/ktor/utils/io/ByteWriteChannel;", "(Lio/ktor/http/HttpProtocolVersion;JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "headers", "Lio/ktor/http/cio/HttpHeadersMap;", "(Lio/ktor/http/cio/HttpHeadersMap;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(JLjava/lang/CharSequence;Lio/ktor/http/cio/ConnectionOptions;Lio/ktor/utils/io/ByteReadChannel;Lio/ktor/utils/io/ByteWriteChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-http-cio"})
@SourceDebugExtension(value={"SMAP\nHttpBody.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpBody.kt\nio/ktor/http/cio/HttpBodyKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1855#2,2:175\n*S KotlinDebug\n*F\n+ 1 HttpBody.kt\nio/ktor/http/cio/HttpBodyKt\n*L\n155#1:175,2\n*E\n"})
public final class HttpBodyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean expectHttpUpgrade(@NotNull HttpMethod method, @Nullable CharSequence upgrade, @Nullable ConnectionOptions connectionOptions) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet())) return false;
        if (upgrade == null) return false;
        ConnectionOptions connectionOptions2 = connectionOptions;
        if (connectionOptions2 == null) return false;
        if (!connectionOptions2.getUpgrade()) return false;
        return true;
    }

    public static final boolean expectHttpUpgrade(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return HttpBodyKt.expectHttpUpgrade(request.getMethod(), request.getHeaders().get("Upgrade"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")));
    }

    public static final boolean expectHttpBody(@NotNull HttpMethod method, long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @Nullable CharSequence contentType) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (transferEncoding != null) {
            HttpBodyKt.isTransferEncodingChunked(transferEncoding);
            return true;
        }
        if (contentLength != -1L) {
            return contentLength > 0L;
        }
        if (Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getGet()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getHead()) || Intrinsics.areEqual((Object)method, (Object)HttpMethod.Companion.getOptions())) {
            return false;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        return connectionOptions2 != null ? connectionOptions2.getClose() : false;
    }

    public static final boolean expectHttpBody(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        CharSequence charSequence = request.getHeaders().get("Content-Length");
        return HttpBodyKt.expectHttpBody(request.getMethod(), charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, request.getHeaders().get("Transfer-Encoding"), ConnectionOptions.Companion.parse(request.getHeaders().get("Connection")), request.getHeaders().get("Content-Type"));
    }

    @Nullable
    public static final Object parseHttpBody(@Nullable HttpProtocolVersion version, long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @NotNull ByteReadChannel input2, @NotNull ByteWriteChannel out, @NotNull Continuation<? super Unit> $completion) {
        if (transferEncoding != null && HttpBodyKt.isTransferEncodingChunked(transferEncoding)) {
            Object object = ChunkedTransferEncodingKt.decodeChunked(input2, out, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (contentLength != -1L) {
            Object object = ByteReadChannelJVMKt.copyTo((ByteReadChannel)input2, (ByteWriteChannel)out, (long)contentLength, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        ConnectionOptions connectionOptions2 = connectionOptions;
        boolean bl = connectionOptions2 != null ? connectionOptions2.getClose() : false;
        if (bl || connectionOptions == null && Intrinsics.areEqual((Object)version, (Object)HttpProtocolVersion.Companion.getHTTP_1_0())) {
            Object object = ByteReadChannelJVMKt.copyTo((ByteReadChannel)input2, (ByteWriteChannel)out, (long)Long.MAX_VALUE, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        IllegalStateException cause = new IllegalStateException("Failed to parse request body: request body length should be specified,\nchunked transfer encoding should be used or\nkeep-alive should be disabled (connection: close)");
        out.close((Throwable)cause);
        return Unit.INSTANCE;
    }

    @Deprecated(message="Please use method with version parameter")
    @Nullable
    public static final Object parseHttpBody(long contentLength, @Nullable CharSequence transferEncoding, @Nullable ConnectionOptions connectionOptions, @NotNull ByteReadChannel input2, @NotNull ByteWriteChannel out, @NotNull Continuation<? super Unit> $completion) {
        Object object = HttpBodyKt.parseHttpBody(null, contentLength, transferEncoding, connectionOptions, input2, out, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final Object parseHttpBody(@NotNull HttpHeadersMap headers2, @NotNull ByteReadChannel input2, @NotNull ByteWriteChannel out, @NotNull Continuation<? super Unit> $completion) {
        CharSequence charSequence = headers2.get("Content-Length");
        Object object = HttpBodyKt.parseHttpBody(null, charSequence != null ? CharsKt.parseDecLong(charSequence) : -1L, headers2.get("Transfer-Encoding"), ConnectionOptions.Companion.parse(headers2.get("Connection")), input2, out, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private static final boolean isTransferEncodingChunked(CharSequence transferEncoding) {
        if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "chunked", 3, null)) {
            return true;
        }
        if (CharsKt.equalsLowerCase$default(transferEncoding, 0, 0, "identity", 3, null)) {
            return false;
        }
        boolean chunked = false;
        String[] stringArray = new String[]{","};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)transferEncoding, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String name;
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)StringsKt.trim((CharSequence)it)).toString().toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (Intrinsics.areEqual((Object)name, (Object)"chunked")) {
                if (chunked) {
                    throw new IllegalArgumentException("Double-chunked TE is not supported: " + transferEncoding);
                }
                chunked = true;
                continue;
            }
            if (Intrinsics.areEqual((Object)name, (Object)"identity")) continue;
            throw new IllegalArgumentException("Unsupported transfer encoding " + name);
        }
        return chunked;
    }
}

