/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.codeInspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHolderUtilKt;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.execution.JUnitBundle;
import com.intellij.jvm.analysis.quickFix.ReplaceCallableExpressionQuickFix;
import com.intellij.jvm.analysis.refactoring.CallChainReplacementInfo;
import com.intellij.jvm.analysis.refactoring.CallReplacementInfo;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.siyeh.ig.testFrameworks.UAssertHint;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/execution/junit/codeInspection/JUnitAssertEqualsOnArrayVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastNonRecursiveVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitCallExpression", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "intellij.junit"})
@SourceDebugExtension(value={"SMAP\nJUnitAssertEqualsOnArrayInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitAssertEqualsOnArrayInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitAssertEqualsOnArrayVisitor\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,46:1\n37#2,2:47\n*S KotlinDebug\n*F\n+ 1 JUnitAssertEqualsOnArrayInspection.kt\ncom/intellij/execution/junit/codeInspection/JUnitAssertEqualsOnArrayVisitor\n*L\n43#1:47,2\n*E\n"})
final class JUnitAssertEqualsOnArrayVisitor
extends AbstractUastNonRecursiveVisitor {
    @NotNull
    private final ProblemsHolder holder;

    public JUnitAssertEqualsOnArrayVisitor(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        this.holder = holder;
    }

    public boolean visitCallExpression(@NotNull UCallExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UAssertHint assertHint = UAssertHint.Companion.createAssertEqualsHint(node);
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null || (psiMethod = psiMethod.getContainingClass()) == null) {
            return true;
        }
        PsiMethod containingClassForDecl = psiMethod;
        String string = containingClassForDecl.getQualifiedName();
        if (!(string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"junit", (boolean)false, (int)2, null) : false)) {
            return true;
        }
        UAssertHint uAssertHint = assertHint;
        if (uAssertHint == null || (uAssertHint = uAssertHint.getFirstArgument()) == null || (uAssertHint = uAssertHint.getExpressionType()) == null) {
            return true;
        }
        UAssertHint firstArgType = uAssertHint;
        PsiType psiType = assertHint.getSecondArgument().getExpressionType();
        if (psiType == null) {
            return true;
        }
        PsiType sectArgType = psiType;
        if (!(firstArgType instanceof PsiArrayType) || !(sectArgType instanceof PsiArrayType)) {
            return true;
        }
        String string2 = JUnitBundle.message("jvm.inspections.junit.assertequals.on.array.problem.descriptor", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
        CallReplacementInfo[] callReplacementInfoArray = new CallReplacementInfo[1];
        Collection $this$toTypedArray$iv = node.getValueArguments();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        UExpression[] uExpressionArray = thisCollection$iv.toArray(new UExpression[0]);
        callReplacementInfoArray[0] = new CallReplacementInfo("assertArrayEquals", null, Arrays.copyOf(uExpressionArray, uExpressionArray.length));
        localQuickFixArray[0] = new ReplaceCallableExpressionQuickFix(new CallChainReplacementInfo(null, callReplacementInfoArray));
        ProblemHolderUtilKt.registerUProblem$default((ProblemsHolder)this.holder, (UCallExpression)node, (String)message, (LocalQuickFix[])localQuickFixArray, null, (int)8, null);
        return true;
    }
}

