/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.startup;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.settings.ExternalSystemSettingsListenerEx;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ui.configuration.SdkListPresenter;
import com.intellij.openapi.roots.ui.configuration.SdkLookupBuilder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.lang.JavaVersion;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.project.GradleNotification;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u001a\u0010\b\u001a\u0016\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J*\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0011H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater;", "Lcom/intellij/openapi/externalSystem/settings/ExternalSystemSettingsListenerEx;", "<init>", "()V", "onProjectsLoaded", "", "project", "Lcom/intellij/openapi/project/Project;", "manager", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "settings", "", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "notifyGradleJvmChangeInfo", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "gradleJvm", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "showGradleProjectSettings", "externalProjectPath", "UpdatedSdkStatus", "Util", "intellij.gradle"})
public final class GradleProjectSettingsUpdater
implements ExternalSystemSettingsListenerEx {
    public void onProjectsLoaded(@NotNull Project project2, @NotNull ExternalSystemManager<?, ?, ?, ?, ?> manager, @NotNull Collection<? extends ExternalProjectSettings> settings) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(manager, (String)"manager");
        Intrinsics.checkNotNullParameter(settings, (String)"settings");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        if (Registry.Companion.is("gradle.auto.auto.jdk.fix.disabled")) {
            return;
        }
        if (!(manager instanceof GradleManager)) {
            return;
        }
        for (ExternalProjectSettings externalProjectSettings : settings) {
            if (!(externalProjectSettings instanceof GradleProjectSettings)) continue;
            CompletableFuture<UpdatedSdkStatus> statusFuture = Util.INSTANCE.updateGradleJvm(project2, (GradleProjectSettings)externalProjectSettings);
            statusFuture.thenAccept(arg_0 -> GradleProjectSettingsUpdater.onProjectsLoaded$lambda$1(arg_0 -> GradleProjectSettingsUpdater.onProjectsLoaded$lambda$0(this, project2, externalProjectSettings, arg_0), arg_0));
        }
    }

    private final void notifyGradleJvmChangeInfo(Project project2, GradleProjectSettings projectSettings, String gradleJvm, Sdk sdk) {
        if (sdk == null) {
            return;
        }
        String string = sdk.getVersionString();
        if (string == null) {
            return;
        }
        String versionString = string;
        String string2 = sdk.getHomePath();
        if (string2 == null) {
            return;
        }
        String homePath = string2;
        String string3 = projectSettings.getExternalProjectPath();
        if (string3 == null) {
            return;
        }
        String externalProjectPath2 = string3;
        String string4 = SdkListPresenter.presentDetectedSdkPath((String)homePath);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"presentDetectedSdkPath(...)");
        String presentablePath = string4;
        String notificationTitle = GradleBundle.message("gradle.notifications.java.home.change.title", new Object[0]);
        Object[] objectArray = new Object[]{gradleJvm, versionString, presentablePath};
        String notificationContent = GradleBundle.message("gradle.notifications.java.home.change.content", objectArray);
        NotificationGroup notificationGroup = GradleNotification.getGradleNotificationGroup();
        Intrinsics.checkNotNull((Object)notificationTitle);
        Intrinsics.checkNotNull((Object)notificationContent);
        Notification notification = notificationGroup.createNotification(notificationTitle, notificationContent, NotificationType.INFORMATION);
        notification.setDisplayId("gradle.jvm.configured");
        notification.addAction((AnAction)NotificationAction.createSimple((String)GradleBundle.message("gradle.open.gradle.settings", new Object[0]), () -> GradleProjectSettingsUpdater.notifyGradleJvmChangeInfo$lambda$2(this, project2, externalProjectPath2)));
        notification.notify(project2);
    }

    private final void showGradleProjectSettings(Project project2, String externalProjectPath2) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        Intrinsics.checkNotNull((Object)manager, (String)"null cannot be cast to non-null type com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware");
        Configurable configurable = ((ExternalSystemConfigurableAware)manager).getConfigurable(project2);
        Intrinsics.checkNotNullExpressionValue((Object)configurable, (String)"getConfigurable(...)");
        Configurable configurable2 = configurable;
        if (configurable2 instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil settingsUtil = ShowSettingsUtil.getInstance();
            settingsUtil.editConfigurable(project2, configurable2, () -> GradleProjectSettingsUpdater.showGradleProjectSettings$lambda$3(configurable2, externalProjectPath2));
        }
    }

    private static final Unit onProjectsLoaded$lambda$0(GradleProjectSettingsUpdater this$0, Project $project, ExternalProjectSettings $projectSettings, UpdatedSdkStatus it) {
        if (it.getUpdated() && it.getSdkName() != null) {
            this$0.notifyGradleJvmChangeInfo($project, (GradleProjectSettings)$projectSettings, it.getSdkName(), it.getSdk());
        }
        return Unit.INSTANCE;
    }

    private static final void onProjectsLoaded$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void notifyGradleJvmChangeInfo$lambda$2(GradleProjectSettingsUpdater this$0, Project $project, String $externalProjectPath) {
        this$0.showGradleProjectSettings($project, $externalProjectPath);
    }

    private static final void showGradleProjectSettings$lambda$3(Configurable $configurable, String $externalProjectPath) {
        ((AbstractExternalSystemConfigurable)$configurable).selectProject($externalProjectPath);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$UpdatedSdkStatus;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdkName", "", "updated", "", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Z)V", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "getSdkName", "()Ljava/lang/String;", "getUpdated", "()Z", "intellij.gradle"})
    public static final class UpdatedSdkStatus {
        @Nullable
        private final Sdk sdk;
        @Nullable
        private final String sdkName;
        private final boolean updated;

        public UpdatedSdkStatus(@Nullable Sdk sdk, @Nullable String sdkName, boolean updated) {
            this.sdk = sdk;
            this.sdkName = sdkName;
            this.updated = updated;
        }

        @Nullable
        public final Sdk getSdk() {
            return this.sdk;
        }

        @Nullable
        public final String getSdkName() {
            return this.sdkName;
        }

        public final boolean getUpdated() {
            return this.updated;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0016\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R4\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$Util;", "", "<init>", "()V", "NOT_UPDATED_STATUS", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$UpdatedSdkStatus;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/CompletableFuture;", "updateGradleJvm", "project", "Lcom/intellij/openapi/project/Project;", "projectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "fixupInternalJdk", "fixupUnknownSdk", "isUnknownSdk", "", "sdkName", "", "isSdkName", "jdkReference", "isInternalSdk", "findRegisteredSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "sdk", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nGradleProjectSettingsUpdater.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleProjectSettingsUpdater.kt\norg/jetbrains/plugins/gradle/startup/GradleProjectSettingsUpdater$Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    public static final class Util {
        @NotNull
        public static final Util INSTANCE = new Util();
        private static final CompletableFuture<UpdatedSdkStatus> NOT_UPDATED_STATUS = CompletableFuture.completedFuture(new UpdatedSdkStatus(null, null, false));

        private Util() {
        }

        @NotNull
        public final CompletableFuture<UpdatedSdkStatus> updateGradleJvm(@NotNull Project project2, @NotNull GradleProjectSettings projectSettings) {
            CompletableFuture<UpdatedSdkStatus> completableFuture;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)projectSettings), (String)"projectSettings");
            String string = projectSettings.getGradleJvm();
            if (string == null) {
                CompletableFuture<UpdatedSdkStatus> completableFuture2 = NOT_UPDATED_STATUS;
                Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"NOT_UPDATED_STATUS");
                return completableFuture2;
            }
            String gradleJvm = string;
            if (this.isInternalSdk(gradleJvm)) {
                completableFuture = this.fixupInternalJdk(project2, projectSettings);
            } else if (this.isSdkName(gradleJvm) && this.isUnknownSdk(gradleJvm)) {
                completableFuture = this.fixupUnknownSdk(project2, projectSettings);
            } else {
                CompletableFuture<UpdatedSdkStatus> completableFuture3 = NOT_UPDATED_STATUS;
                completableFuture = completableFuture3;
                Intrinsics.checkNotNullExpressionValue(completableFuture3, (String)"NOT_UPDATED_STATUS");
            }
            return completableFuture;
        }

        private final CompletableFuture<UpdatedSdkStatus> fixupInternalJdk(Project project2, GradleProjectSettings projectSettings) {
            ExternalSystemJdkProvider jdkProvider = ExternalSystemJdkProvider.getInstance();
            Sdk sdk = jdkProvider.getInternalJdk();
            Intrinsics.checkNotNullExpressionValue((Object)sdk, (String)"getInternalJdk(...)");
            Sdk internalSdk = sdk;
            projectSettings.setGradleJvm(internalSdk.getName());
            return this.fixupUnknownSdk(project2, projectSettings);
        }

        private final CompletableFuture<UpdatedSdkStatus> fixupUnknownSdk(Project project2, GradleProjectSettings projectSettings) {
            String string = projectSettings.getGradleJvm();
            if (string == null) {
                CompletableFuture<UpdatedSdkStatus> completableFuture = NOT_UPDATED_STATUS;
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"NOT_UPDATED_STATUS");
                return completableFuture;
            }
            String gradleJvm = string;
            GradleVersion gradleVersion = projectSettings.resolveGradleVersion();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"resolveGradleVersion(...)");
            GradleVersion gradleVersion2 = gradleVersion;
            CompletableFuture<UpdatedSdkStatus> future = new CompletableFuture<UpdatedSdkStatus>();
            projectSettings.setGradleJvm(null);
            SdkLookupBuilder sdkLookupBuilder = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project2, projectSettings).newLookupBuilder().withSdkName(gradleJvm).withVersionFilter(arg_0 -> Util.fixupUnknownSdk$lambda$0(gradleVersion2, arg_0));
            SdkType sdkType = ExternalSystemJdkUtil.getJavaSdkType();
            Intrinsics.checkNotNullExpressionValue((Object)sdkType, (String)"getJavaSdkType(...)");
            sdkLookupBuilder.withSdkType(sdkType).withSdkHomeFilter(Util::fixupUnknownSdk$lambda$1).onSdkNameResolved(arg_0 -> Util.fixupUnknownSdk$lambda$2(projectSettings, arg_0)).onSdkResolved(arg_0 -> Util.fixupUnknownSdk$lambda$3(projectSettings, gradleJvm, future, arg_0)).executeLookup();
            return future;
        }

        private final boolean isUnknownSdk(String sdkName) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            Sdk sdk = projectJdkTable.findJdk(sdkName);
            return sdk == null;
        }

        private final boolean isSdkName(String jdkReference) {
            return jdkReference != null && !StringsKt.startsWith$default((CharSequence)jdkReference, (char)'#', (boolean)false, (int)2, null);
        }

        private final boolean isInternalSdk(String jdkReference) {
            return Intrinsics.areEqual((Object)jdkReference, (Object)"#JAVA_INTERNAL");
        }

        private final Sdk findRegisteredSdk(Sdk sdk) {
            return (Sdk)ActionsKt.runReadAction(() -> Util.findRegisteredSdk$lambda$4(sdk));
        }

        private static final boolean fixupUnknownSdk$lambda$0(GradleVersion $gradleVersion, String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            JavaVersion javaVersion = JavaVersion.tryParse((String)it);
            return javaVersion != null && GradleJvmSupportMatrix.Companion.isJavaSupportedByIdea(javaVersion) && GradleJvmSupportMatrix.Companion.isSupported($gradleVersion, javaVersion);
        }

        private static final boolean fixupUnknownSdk$lambda$1(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return ExternalSystemJdkUtil.isValidJdk((String)it);
        }

        private static final Unit fixupUnknownSdk$lambda$2(GradleProjectSettings $projectSettings, Sdk sdk) {
            Sdk fakeSdk;
            Sdk sdk2 = sdk;
            if (sdk2 != null) {
                Sdk sdk3 = sdk2;
                Util util = INSTANCE;
                Sdk p0 = sdk3;
                boolean bl = false;
                boolean $i$f$fixupUnknownSdk$lambda$2$stub_for_inlining = false;
                v1 = util.findRegisteredSdk(p0);
            } else {
                v1 = fakeSdk = null;
            }
            if (fakeSdk != null && $projectSettings.getGradleJvm() == null) {
                $projectSettings.setGradleJvm(fakeSdk.getName());
            }
            return Unit.INSTANCE;
        }

        private static final Unit fixupUnknownSdk$lambda$3(GradleProjectSettings $projectSettings, String $gradleJvm, CompletableFuture $future, Sdk sdk) {
            if ($projectSettings.getGradleJvm() == null) {
                Object object = sdk;
                if (object == null || (object = object.getName()) == null) {
                    object = $gradleJvm;
                }
                $projectSettings.setGradleJvm((String)object);
            }
            $future.complete(new UpdatedSdkStatus(sdk, $gradleJvm, true));
            return Unit.INSTANCE;
        }

        private static final Sdk findRegisteredSdk$lambda$4(Sdk $sdk) {
            ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
            return projectJdkTable.findJdk($sdk.getName(), $sdk.getSdkType().getName());
        }
    }
}

