/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.index;

import com.intellij.jsp.index.JspDirectiveProcessor;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;

public class JspDirectiveCollector
extends JspDirectiveProcessor {
    private final JspDirectiveKind myDirectiveKind;
    private final Collection<XmlTag> myDirectives = new ArrayList<XmlTag>();

    public JspDirectiveCollector(BaseJspFile original, JspDirectiveKind directiveKind) {
        super(original);
        this.myDirectiveKind = directiveKind;
    }

    @Override
    protected void processDirective(XmlTag directive, JspDirectiveKind directiveKind, int offset) {
        if (directiveKind == this.myDirectiveKind) {
            this.myDirectives.add(directive);
        }
    }

    public Collection<XmlTag> getDirectives() {
        return this.myDirectives;
    }

    public static Collection<XmlTag> collectDirectives(BaseJspFile jspFile, JspDirectiveKind directiveKind) {
        JspDirectiveCollector collector = new JspDirectiveCollector(jspFile, directiveKind);
        collector.processDirectives(jspFile.getText());
        return collector.getDirectives();
    }
}

