/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web;

import com.intellij.jsp.JspContextManager;
import com.intellij.jsp.javaee.web.JspFileIndex;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="JspContextManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class JspContextManagerImpl
extends JspContextManager
implements PersistentStateComponent<JspContextManagerState> {
    private final PsiManager myPsiManager;
    private final JspFileIndex myJspFileIndex;
    private final BidirectionalMap<String, String> myFileUrlToContextUrl;
    private static final ThreadLocal<Set<PsiFile>> myProcessedContexts = ThreadLocal.withInitial(() -> new HashSet());

    public JspContextManagerImpl(@NotNull Project project) {
        if (project == null) {
            JspContextManagerImpl.$$$reportNull$$$0(0);
        }
        this.myFileUrlToContextUrl = new BidirectionalMap();
        this.myPsiManager = PsiManager.getInstance((Project)project);
        this.myJspFileIndex = JspFileIndex.getInstance(project);
    }

    void handleFileDeleted(String fileUrl) {
        this.myFileUrlToContextUrl.remove((Object)fileUrl);
        List list = this.myFileUrlToContextUrl.getKeysByValue((Object)fileUrl);
        if (list != null) {
            String[] toRemove;
            for (String s : toRemove = ArrayUtilRt.toStringArray((Collection)list)) {
                this.myFileUrlToContextUrl.remove((Object)s);
            }
        }
    }

    public boolean hasContextMappings() {
        return !this.myFileUrlToContextUrl.isEmpty();
    }

    @NotNull
    public static JspContextManagerImpl getInstance(@NotNull Project project) {
        if (project == null) {
            JspContextManagerImpl.$$$reportNull$$$0(1);
        }
        JspContextManagerImpl jspContextManagerImpl = (JspContextManagerImpl)JspContextManager.getInstance((Project)project);
        if (jspContextManagerImpl == null) {
            JspContextManagerImpl.$$$reportNull$$$0(2);
        }
        return jspContextManagerImpl;
    }

    @TestOnly
    public void clearState() {
        this.myFileUrlToContextUrl.clear();
    }

    public void loadState(@NotNull JspContextManagerState state) {
        if (state == null) {
            JspContextManagerImpl.$$$reportNull$$$0(3);
        }
        for (JspContextMappingState mapping : state.getMappings()) {
            String contextFileUrl;
            String fileUrl = mapping.getAFileUrl();
            if (fileUrl == null || (contextFileUrl = mapping.getContextFileUrl()) == null) continue;
            this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)contextFileUrl);
        }
    }

    public JspContextManagerState getState() {
        JspContextManagerState state = new JspContextManagerState();
        if (!this.myFileUrlToContextUrl.isEmpty()) {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            for (Map.Entry entry : this.myFileUrlToContextUrl.entrySet()) {
                String fileUrl = (String)entry.getKey();
                String contextUrl = (String)entry.getValue();
                JspContextManagerImpl.writeFile(state, fileUrl, contextUrl, virtualFileManager);
            }
        }
        return state;
    }

    private static void writeFile(@NotNull JspContextManagerState state, String fileUrl, @Nullable String contextUrl, @NotNull VirtualFileManager virtualFileManager) {
        if (state == null) {
            JspContextManagerImpl.$$$reportNull$$$0(4);
        }
        if (virtualFileManager == null) {
            JspContextManagerImpl.$$$reportNull$$$0(5);
        }
        if (virtualFileManager.findFileByUrl(fileUrl) != null && contextUrl != null && virtualFileManager.findFileByUrl(contextUrl) != null) {
            JspContextMappingState mapping = new JspContextMappingState();
            mapping.setAFileUrl(fileUrl);
            mapping.setContextFileUrl(contextUrl);
            state.getMappings().add(mapping);
        }
    }

    @Nullable
    private BaseJspFile findAndSetFirstSuitableContext(PsiFile file) {
        return this.myJspFileIndex.getFirstIncludingFile(file);
    }

    @Nullable
    public JspFile getConfiguredContextFile(@NotNull PsiFile file) {
        PsiFile psiFile;
        VirtualFile contextVirtualFile;
        VirtualFile virtualFile;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(6);
        }
        if ((virtualFile = JspContextManagerImpl.getVirtualFile(file)) == null) {
            return null;
        }
        String fileUrl = virtualFile.getUrl();
        String contextUrl = (String)this.myFileUrlToContextUrl.get((Object)fileUrl);
        if (contextUrl != null && (contextVirtualFile = VirtualFileManager.getInstance().findFileByUrl(contextUrl)) != null && (psiFile = this.myPsiManager.findFile(contextVirtualFile)) instanceof JspFile) {
            return (JspFile)psiFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getVirtualFile(PsiFile file) {
        return file.getOriginalFile().getVirtualFile();
    }

    public void setContextFile(@NotNull PsiFile file, @Nullable BaseJspFile contextFile) {
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(7);
        }
        this.setContextInternal(file, contextFile);
        this.myPsiManager.dropPsiCaches();
    }

    private void setContextInternal(@NotNull PsiFile file, @Nullable BaseJspFile contextFile) {
        VirtualFile virtualFile;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(8);
        }
        if ((virtualFile = file.getVirtualFile()) != null) {
            String fileUrl = virtualFile.getUrl();
            if (contextFile != null) {
                VirtualFile contextVirtualFile = contextFile.getVirtualFile();
                if (contextVirtualFile != null) {
                    this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)contextVirtualFile.getUrl());
                }
            } else {
                this.myFileUrlToContextUrl.remove((Object)fileUrl);
            }
        }
    }

    @Nullable
    public BaseJspFile getContextFile(@NotNull PsiFile file) {
        JspFile contextFile;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(9);
        }
        if ((contextFile = this.getConfiguredContextFile(file)) == null) {
            contextFile = this.findAndSetFirstSuitableContext(file);
        }
        return contextFile;
    }

    public BaseJspFile[] getSuitableContextFiles(@NotNull PsiFile file) {
        Object[] files;
        int index;
        if (file == null) {
            JspContextManagerImpl.$$$reportNull$$$0(10);
        }
        if ((index = ArrayUtil.find((Object[])(files = this.myJspFileIndex.getIncludingFiles(file)), (Object)file)) != -1) {
            return (BaseJspFile[])ArrayUtil.remove((Object[])files, (int)index);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processContextElements(@NotNull FileViewProvider fileViewProvider, PsiScopeProcessor processor) {
        JspFile initialFile;
        if (fileViewProvider == null) {
            JspContextManagerImpl.$$$reportNull$$$0(11);
        }
        if ((initialFile = (JspFile)fileViewProvider.getPsi(fileViewProvider.getBaseLanguage())) == null) {
            return true;
        }
        Set<PsiFile> recursionGuard = myProcessedContexts.get();
        if (recursionGuard.contains(initialFile)) {
            return true;
        }
        JspFile realInitialFile = initialFile;
        recursionGuard.add((PsiFile)realInitialFile);
        try {
            BaseJspFile context;
            initialFile = (JspFile)initialFile.getOriginalFile();
            HashSet<JspFile> files = new HashSet<JspFile>(4);
            JspFile currentFile = initialFile;
            do {
                files.add(currentFile);
                context = this.getContextFile((PsiFile)currentFile);
                PsiElement element = this.findFirstIncludeElementForFile(context, (BaseJspFile)currentFile);
                if (element == null && (element = this.findFirstIncludeElementForFile(context = this.getConfiguredContextFile((PsiFile)currentFile), (BaseJspFile)currentFile)) == null) {
                    context = this.findAndSetFirstSuitableContext((PsiFile)currentFile);
                    element = this.findFirstIncludeElementForFile(context, (BaseJspFile)currentFile);
                }
                if (context == null) break;
                if (element == null) {
                    break;
                }
                if (context instanceof JspFile && !PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)element, (PsiElement)((JspFile)context).getJavaClass())) {
                    boolean bl = false;
                    return bl;
                }
                PsiFile javaFile = context.getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
                if (javaFile == null) continue;
                javaFile.processDeclarations(processor, ResolveState.initial(), (PsiElement)currentFile, element);
            } while (!files.contains(currentFile = context));
        }
        finally {
            recursionGuard.remove(realInitialFile);
        }
        return true;
    }

    @Nullable
    private PsiElement findFirstIncludeElementForFile(@Nullable BaseJspFile file, @NotNull BaseJspFile referencedFile) {
        if (referencedFile == null) {
            JspContextManagerImpl.$$$reportNull$$$0(12);
        }
        if (file == null || !file.isValid()) {
            return null;
        }
        int minOffset = this.myJspFileIndex.getFirstIncludeElementForFile(file, referencedFile);
        if (minOffset == -1) {
            VirtualFile virtualFile = referencedFile.getVirtualFile();
            if (virtualFile != null) {
                minOffset = file.getTextLength() - 1;
            } else {
                return null;
            }
        }
        return file.getViewProvider().findElementAt(minOffset, (Language)JavaLanguage.INSTANCE);
    }

    void changeContext(String oldUrl, String newUrl) {
        List fileUrls;
        String oldContext = (String)this.myFileUrlToContextUrl.get((Object)oldUrl);
        if (oldContext != null) {
            this.myFileUrlToContextUrl.remove((Object)oldUrl);
            this.myFileUrlToContextUrl.put((Object)newUrl, (Object)oldContext);
        }
        if ((fileUrls = this.myFileUrlToContextUrl.getKeysByValue((Object)oldUrl)) != null) {
            String[] urls;
            for (String fileUrl : urls = ArrayUtilRt.toStringArray((Collection)fileUrls)) {
                this.myFileUrlToContextUrl.put((Object)fileUrl, (Object)newUrl);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/JspContextManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileManager";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileViewProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/JspContextManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguredContextFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setContextFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setContextInternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getContextFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableContextFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processContextElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFirstIncludeElementForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class JspContextManagerState {
        private List<JspContextMappingState> myMappings = new ArrayList<JspContextMappingState>();

        @Property(surroundWithTag=false)
        @XCollection
        public List<JspContextMappingState> getMappings() {
            return this.myMappings;
        }

        public void setMappings(List<JspContextMappingState> mappings) {
            this.myMappings = mappings;
        }
    }

    @Tag(value="jsp-to-context")
    public static class JspContextMappingState {
        private String myAFileUrl;
        private String myContextFileUrl;

        @Attribute(value="jsp-file")
        public String getAFileUrl() {
            return this.myAFileUrl;
        }

        public void setAFileUrl(String AFileUrl) {
            this.myAFileUrl = AFileUrl;
        }

        @Attribute(value="context-file")
        public String getContextFileUrl() {
            return this.myContextFileUrl;
        }

        public void setContextFileUrl(String contextFileUrl) {
            this.myContextFileUrl = contextFileUrl;
        }
    }
}

