/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.codeInsight.intentions;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JspCommentIntention
extends AbstractIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            JspCommentIntention.$$$reportNull$$$0(0);
        }
        return JspCommentIntention.getXmlComment(editor, file) != null;
    }

    @Nullable
    private static XmlComment getXmlComment(Editor editor, PsiFile file) {
        PsiFile psiFile;
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        if (jspFile != null && (psiFile = jspFile.getBaseLanguageRoot()).getLanguage().equals(HTMLLanguage.INSTANCE)) {
            PsiElement element = psiFile.findElementAt(editor.getCaretModel().getOffset());
            return (XmlComment)PsiTreeUtil.getParentOfType((PsiElement)element, XmlComment.class, (boolean)false);
        }
        return null;
    }

    @NotNull
    public String getText() {
        String string = JavaeeJspBundle.message("replace.with.jsp.comment.intention", new Object[0]);
        if (string == null) {
            JspCommentIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        XmlComment comment;
        if (project == null) {
            JspCommentIntention.$$$reportNull$$$0(2);
        }
        if ((comment = JspCommentIntention.getXmlComment(editor, file)) != null) {
            String text = comment.getCommentText();
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> {
                TextRange range = comment.getTextRange();
                editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)("<%--" + text + "--%>"));
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/codeInsight/intentions/JspCommentIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/codeInsight/intentions/JspCommentIntention";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

