/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.beans.toolWindow;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.beans.toolWindow.MicronautBeanStereotype;
import com.intellij.micronaut.beans.toolWindow.MnBeanItem;
import com.intellij.micronaut.beans.toolWindow.MnBeansProviderKt;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnBeansModel;
import com.intellij.microservices.jvm.beans.BeanPresentation;
import com.intellij.microservices.jvm.beans.BeanStereotype;
import com.intellij.microservices.jvm.beans.BeansFilter;
import com.intellij.microservices.jvm.beans.BeansProvider;
import com.intellij.microservices.jvm.beans.FrameworkBeansPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J$\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00142\u0006\u0010\u001b\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/intellij/micronaut/beans/toolWindow/MnBeansProvider;", "Lcom/intellij/microservices/jvm/beans/BeansProvider;", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/micronaut/beans/toolWindow/MnBeanItem;", "<init>", "()V", "stereotypes", "", "Lcom/intellij/microservices/jvm/beans/BeanStereotype;", "getStereotypes", "()Ljava/util/Collection;", "presentation", "Lcom/intellij/microservices/jvm/beans/FrameworkBeansPresentation;", "getPresentation", "()Lcom/intellij/microservices/jvm/beans/FrameworkBeansPresentation;", "getStatus", "Lcom/intellij/microservices/jvm/beans/BeansProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getBeanGroups", "", "filter", "Lcom/intellij/microservices/jvm/beans/BeansFilter;", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getBeanPresentation", "Lcom/intellij/microservices/jvm/beans/BeanPresentation;", "group", "bean", "isValidBean", "", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getBeans", "", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnBeansProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnBeansProvider.kt\ncom/intellij/micronaut/beans/toolWindow/MnBeansProvider\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n19#2:126\n808#3,11:127\n1755#3,3:138\n*S KotlinDebug\n*F\n+ 1 MnBeansProvider.kt\ncom/intellij/micronaut/beans/toolWindow/MnBeansProvider\n*L\n98#1:126\n113#1:127,11\n118#1:138,3\n*E\n"})
public final class MnBeansProvider
implements BeansProvider<Module, MnBeanItem> {
    @NotNull
    public Collection<BeanStereotype> getStereotypes() {
        Object[] objectArray = new BeanStereotype[]{MnBeansProviderKt.getMN_BEAN_STEREOTYPE(), MnBeansProviderKt.getMN_CONTROLLER_STEREOTYPE(), MnBeansProviderKt.getMN_REPOSITORY_STEREOTYPE(), MnBeansProviderKt.getMN_CONFIGURATION_STEREOTYPE()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public FrameworkBeansPresentation getPresentation() {
        return MnBeansProviderKt.access$getMN_PRESENTATION$p();
    }

    @NotNull
    public BeansProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MicronautUtils.hasMicronautLibrary(project) ? BeansProvider.Status.AVAILABLE : BeansProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<Module> getBeanGroups(@NotNull Project project, @NotNull BeansFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Set<Module> set = Collections.singleton(filter.getModule());
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        return set;
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ModificationTracker modificationTracker = OuterModelsModificationTrackerManager.getTracker((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"getTracker(...)");
        return modificationTracker;
    }

    @NotNull
    public BeanPresentation getBeanPresentation(@NotNull Module group, @NotNull MnBeanItem bean) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        PsiElement element = bean.getDefiningPsi();
        PsiFile containingFile = element.getContainingFile();
        PsiElement $this$asSafely$iv = element;
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiNamedElement)) {
            psiElement = null;
        }
        if ((object = (PsiNamedElement)psiElement) == null || (object = object.getName()) == null) {
            String string = containingFile.getName();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        }
        Object beanName = object;
        PresentationData presentation = new PresentationData((String)beanName, containingFile.getName(), JavaUltimateIcons.Cdi.Bean, null);
        return new BeanPresentation((ItemPresentation)presentation, "", null);
    }

    public boolean isValidBean(@NotNull Module group, @NotNull MnBeanItem bean) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getDefiningPsi().isValid();
    }

    @NotNull
    public PsiElement getDocumentationElement(@NotNull Module group, @NotNull MnBeanItem bean) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getDefiningPsi();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<MnBeanItem> getBeans(@NotNull Module group, @NotNull List<? extends BeanStereotype> stereotypes) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter(stereotypes, (String)"stereotypes");
        Iterable $this$filterIsInstance$iv = stereotypes;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MicronautBeanStereotype)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List micronautStereotypes = (List)destination$iv$iv;
        List<MnBeanItem> list = MnBeansModel.getAllBeans(group).filter(arg_0 -> MnBeansProvider.getBeans$lambda$2(arg_0 -> MnBeansProvider.getBeans$lambda$1(stereotypes, micronautStereotypes, arg_0), arg_0)).map(arg_0 -> MnBeansProvider.getBeans$lambda$4(MnBeansProvider::getBeans$lambda$3, arg_0)).toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"toList(...)");
        return list;
    }

    private static final boolean getBeans$lambda$1(List $stereotypes, List $micronautStereotypes, MnBeanDefinition definition) {
        boolean bl;
        block4: {
            if ($stereotypes.isEmpty()) {
                return true;
            }
            Iterable $this$any$iv = $micronautStereotypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MicronautBeanStereotype stereotype = (MicronautBeanStereotype)((Object)element$iv);
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)definition);
                    if (!stereotype.accept(definition)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean getBeans$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final MnBeanItem getBeans$lambda$3(MnBeanDefinition beanDefinition) {
        PsiElement psiElement = beanDefinition.getDefiningPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getDefiningPsiElement(...)");
        return new MnBeanItem(psiElement);
    }

    private static final MnBeanItem getBeans$lambda$4(Function1 $tmp0, Object p0) {
        return (MnBeanItem)$tmp0.invoke(p0);
    }
}

