/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.micronaut.config.MnParametrizedConfigKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u00070\u0001\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/micronaut/config/MnParametrizedConfigKeyPrefixMatcher;", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "", "delegate", "<init>", "(Ljava/lang/String;Lcom/intellij/codeInsight/completion/PrefixMatcher;)V", "(Lcom/intellij/codeInsight/completion/PrefixMatcher;)V", "Lorg/jetbrains/annotations/NotNull;", "prefixMatches", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "name", "cloneWithPrefix", "Companion", "intellij.micronaut"})
public final class MnParametrizedConfigKeyPrefixMatcher
extends PrefixMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrefixMatcher delegate;
    @NotNull
    private static final Key<String> PARAMETER_KEY;

    public MnParametrizedConfigKeyPrefixMatcher(@NotNull String prefix, @NotNull PrefixMatcher delegate) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(prefix);
        PrefixMatcher prefixMatcher = delegate.cloneWithPrefix(prefix);
        Intrinsics.checkNotNullExpressionValue((Object)prefixMatcher, (String)"cloneWithPrefix(...)");
        this.delegate = prefixMatcher;
    }

    public MnParametrizedConfigKeyPrefixMatcher(@NotNull PrefixMatcher delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        String string = delegate.getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        this(string, delegate);
    }

    public boolean prefixMatches(@NotNull LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Iterator iterator = element.getAllLookupStrings().iterator();
        while (iterator.hasNext()) {
            TextRange parameterRange;
            MnParametrizedConfigKey parametrizedConfigKey;
            String s;
            String string = s = (String)iterator.next();
            Intrinsics.checkNotNull((Object)string);
            MnParametrizedConfigKey mnParametrizedConfigKey = parametrizedConfigKey = MnParametrizedConfigKey.Companion.getParametrizedConfigKey(string);
            if (mnParametrizedConfigKey != null) {
                String string2 = this.getPrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPrefix(...)");
                v3 = mnParametrizedConfigKey.getParameterRange(string2);
            } else {
                v3 = parameterRange = null;
            }
            if (parameterRange != null) {
                String parameter;
                Intrinsics.checkNotNullExpressionValue((Object)parameterRange.substring(this.getPrefix()), (String)"substring(...)");
                String convertedName = parametrizedConfigKey.getPrefix() + "." + parameter + "." + parametrizedConfigKey.getSuffix();
                if (!this.delegate.prefixMatches(convertedName)) continue;
                element.putUserData(PARAMETER_KEY, (Object)parameter);
                return true;
            }
            if (!this.delegate.prefixMatches(s)) continue;
            return true;
        }
        return false;
    }

    public boolean prefixMatches(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.delegate.prefixMatches(name);
    }

    @NotNull
    public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return Intrinsics.areEqual((Object)prefix, (Object)this.myPrefix) ? (PrefixMatcher)this : (PrefixMatcher)new MnParametrizedConfigKeyPrefixMatcher(prefix, this.delegate);
    }

    static {
        Key key = Key.create((String)"PARAMETER_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PARAMETER_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/micronaut/config/MnParametrizedConfigKeyPrefixMatcher$Companion;", "", "<init>", "()V", "PARAMETER_KEY", "Lcom/intellij/openapi/util/Key;", "", "getPARAMETER_KEY$intellij_micronaut", "()Lcom/intellij/openapi/util/Key;", "intellij.micronaut"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<String> getPARAMETER_KEY$intellij_micronaut() {
            return PARAMETER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

