/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.datasource;

import com.intellij.micronaut.config.datasource.DatasourcesKt;
import com.intellij.micronaut.config.datasource.MnDataSourceWithRegexp;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.persistence.database.KeyPrefixInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0017\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/config/datasource/MnDataSourceConfigType;", "Lcom/intellij/persistence/database/DataSourceConfigType;", "", "prefixes", "", "Lcom/intellij/micronaut/config/datasource/MnDataSourceWithRegexp;", "<init>", "(Ljava/lang/String;ILjava/util/List;)V", "getPrefixes", "()Ljava/util/List;", "MN_DATA_SOURCES", "MN_MONGO", "MN_REDIS", "MN_R2DBC", "tryToRetrieveApplicablePrefixRegexp", "Lcom/intellij/persistence/database/KeyPrefixInfo;", "key", "", "tryToGetDatabaseName", "matchResult", "Lkotlin/text/MatchResult;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nDatasources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Datasources.kt\ncom/intellij/micronaut/config/datasource/MnDataSourceConfigType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1368#2:65\n1454#2,5:66\n*S KotlinDebug\n*F\n+ 1 Datasources.kt\ncom/intellij/micronaut/config/datasource/MnDataSourceConfigType\n*L\n26#1:65\n26#1:66,5\n*E\n"})
public final class MnDataSourceConfigType
extends Enum<MnDataSourceConfigType>
implements DataSourceConfigType {
    @NotNull
    private final List<MnDataSourceWithRegexp> prefixes;
    public static final /* enum */ MnDataSourceConfigType MN_DATA_SOURCES = new MnDataSourceConfigType(CollectionsKt.listOf((Object)((Object)new MnDataSourceWithRegexp("datasources"))));
    public static final /* enum */ MnDataSourceConfigType MN_MONGO;
    public static final /* enum */ MnDataSourceConfigType MN_REDIS;
    public static final /* enum */ MnDataSourceConfigType MN_R2DBC;
    private static final /* synthetic */ MnDataSourceConfigType[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private MnDataSourceConfigType(List<MnDataSourceWithRegexp> prefixes) {
        this.prefixes = prefixes;
    }

    @NotNull
    public List<MnDataSourceWithRegexp> getPrefixes() {
        return this.prefixes;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final KeyPrefixInfo tryToRetrieveApplicablePrefixRegexp(@NotNull String key) {
        Iterable iterable;
        block4: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Iterable $this$flatMap$iv = this.getPrefixes();
            boolean $i$f$flatMap = false;
            Iterable iterable2 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                MnDataSourceWithRegexp it = (MnDataSourceWithRegexp)((Object)element$iv$iv);
                boolean bl = false;
                Iterable list$iv$iv = it.getRegexps();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            for (Regex regex : (Iterable)((List)destination$iv$iv)) {
                KeyPrefixInfo keyPrefixInfo;
                boolean bl = false;
                if (Regex.find$default((Regex)regex, (CharSequence)key, (int)0, (int)2, null) == null) {
                    keyPrefixInfo = null;
                } else {
                    MatchResult matchResult;
                    String databaseName = this.tryToGetDatabaseName(matchResult);
                    keyPrefixInfo = new KeyPrefixInfo(matchResult.getValue(), databaseName);
                }
                if ((iterable2 = keyPrefixInfo) == null) continue;
                iterable = iterable2;
                break block4;
            }
            iterable = null;
        }
        return iterable;
    }

    private final String tryToGetDatabaseName(MatchResult matchResult) {
        String string;
        try {
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)matchResult.getGroups(), (String)"databaseName");
            string = matchGroup != null ? matchGroup.getValue() : null;
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    public static MnDataSourceConfigType[] values() {
        return (MnDataSourceConfigType[])$VALUES.clone();
    }

    public static MnDataSourceConfigType valueOf(String value) {
        return Enum.valueOf(MnDataSourceConfigType.class, value);
    }

    @NotNull
    public static EnumEntries<MnDataSourceConfigType> getEntries() {
        return $ENTRIES;
    }

    static {
        Object[] objectArray = new Regex[]{DatasourcesKt.access$toPrefixRegexpWithDatabaseName("mongodb.servers"), new Regex("mongodb\\.")};
        MN_MONGO = new MnDataSourceConfigType(CollectionsKt.listOf((Object)((Object)new MnDataSourceWithRegexp("mongodb", CollectionsKt.listOf((Object[])objectArray)))));
        objectArray = new Regex[]{DatasourcesKt.access$toPrefixRegexpWithDatabaseName("redis.servers"), new Regex("redis\\.")};
        MN_REDIS = new MnDataSourceConfigType(CollectionsKt.listOf((Object)((Object)new MnDataSourceWithRegexp("redis", CollectionsKt.listOf((Object[])objectArray)))));
        MN_R2DBC = new MnDataSourceConfigType(CollectionsKt.listOf((Object)((Object)new MnDataSourceWithRegexp("r2dbc.datasources"))));
        $VALUES = mnDataSourceConfigTypeArray = new MnDataSourceConfigType[]{MnDataSourceConfigType.MN_DATA_SOURCES, MnDataSourceConfigType.MN_MONGO, MnDataSourceConfigType.MN_REDIS, MnDataSourceConfigType.MN_R2DBC};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
    }
}

