/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.config.yaml;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.micronaut.config.MnConfigFileContributor;
import com.intellij.micronaut.config.MnConfigValueSearcher;
import com.intellij.micronaut.config.MnMetaConfigKeyManager;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlAccessor;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00150\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/micronaut/config/yaml/MnYamlConfigFileContributor;", "Lcom/intellij/micronaut/config/MnConfigFileContributor;", "<init>", "()V", "findKey", "Lcom/intellij/psi/PsiElement;", "psiFile", "Lcom/intellij/psi/PsiFile;", "key", "", "findMatchingKeys", "", "prefix", "getKeyVariants", "Lcom/intellij/codeInsight/lookup/LookupElement;", "processConfigValues", "", "params", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueSearchParams;", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/micronaut/config/MnConfigValueSearcher$MnConfigValueResult;", "intellij.micronaut"})
public final class MnYamlConfigFileContributor
extends MnConfigFileContributor {
    public MnYamlConfigFileContributor() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
        super((FileType)yAMLFileType);
    }

    @Override
    @Nullable
    public PsiElement findKey(@NotNull PsiFile psiFile, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!(psiFile instanceof YAMLFile)) {
            return null;
        }
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            YAMLKeyValue existingKey = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.Companion.getInstance()).findExistingKey(key);
            if (existingKey == null) continue;
            return (PsiElement)existingKey;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiElement> findMatchingKeys(@NotNull PsiFile psiFile, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            YAMLKeyValue existingKey = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.Companion.getInstance()).findExistingKey(prefix);
            if (existingKey == null) continue;
            return CollectionsKt.listOf((Object)existingKey);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Collection<LookupElement> getKeyVariants(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!(psiFile instanceof YAMLFile)) {
            return CollectionsKt.emptyList();
        }
        ArrayList<LookupElementBuilder> result = new ArrayList<LookupElementBuilder>();
        for (YAMLDocument document : ((YAMLFile)psiFile).getDocuments()) {
            ConfigYamlAccessor accessor = new ConfigYamlAccessor(document, (MetaConfigKeyManager)MnMetaConfigKeyManager.Companion.getInstance());
            for (YAMLKeyValue yamlKeyValue : accessor.getAllKeys()) {
                String qualifiedKey;
                YAMLValue yamlValue = yamlKeyValue.getValue();
                if (!(yamlValue instanceof YAMLScalar) && !(yamlValue instanceof YAMLSequence)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue), (String)"getQualifiedConfigKeyName(...)");
                result.add(LookupElementBuilder.create((Object)yamlKeyValue, (String)qualifiedKey).withRenderer(ConfigYamlUtils.getYamlPlaceholderLookupRenderer()));
            }
        }
        return result;
    }

    @Override
    public boolean processConfigValues(@NotNull MnConfigValueSearcher.MnConfigValueSearchParams params, @NotNull Processor<? super MnConfigValueSearcher.MnConfigValueResult> processor2) {
        YAMLDocument specifiedDocument;
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter(processor2, (String)"processor");
        PsiFile psiFile = params.getConfigFile();
        YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
        if (yAMLFile == null) {
            return true;
        }
        YAMLFile yamlFile = yAMLFile;
        MetaConfigKeyManager.ConfigKeyNameBinder binder = MnMetaConfigKeyManager.Companion.getInstance().getConfigKeyNameBinder(params.getModule());
        List list = yamlFile.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDocuments(...)");
        YAMLDocument yAMLDocument = specifiedDocument = (YAMLDocument)CollectionsKt.getOrNull((List)list, (int)params.getDocumentId());
        List documents = yAMLDocument == null ? yamlFile.getDocuments() : CollectionsKt.listOf((Object)yAMLDocument);
        Processor keyValueProcessor = arg_0 -> MnYamlConfigFileContributor.processConfigValues$lambda$1(params, binder, processor2, arg_0);
        Intrinsics.checkNotNull((Object)documents);
        for (YAMLDocument document : CollectionsKt.asReversed((List)documents)) {
            if (ConfigYamlAccessor.processAllKeysReversed((YAMLPsiElement)((YAMLPsiElement)document), (Processor)keyValueProcessor)) continue;
            return false;
        }
        return true;
    }

    private static final PsiType processConfigValues$lambda$1$lambda$0(MnConfigValueSearcher.MnConfigValueSearchParams $params) {
        return $params.getKey().getConfigKey().getEffectiveValueElementType();
    }

    private static final boolean processConfigValues$lambda$1(MnConfigValueSearcher.MnConfigValueSearchParams $params, MetaConfigKeyManager.ConfigKeyNameBinder $binder, Processor $processor, YAMLKeyValue yamlKeyValue) {
        Intrinsics.checkNotNullParameter((Object)yamlKeyValue, (String)"yamlKeyValue");
        ProgressManager.checkCanceled();
        String string = ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQualifiedConfigKeyName(...)");
        String qualifiedKeyName = string;
        if ($params.matches(qualifiedKeyName, $binder)) {
            PsiElement psiElement = yamlKeyValue.getKey();
            if (psiElement == null) {
                return true;
            }
            PsiElement keyElement = psiElement;
            YAMLValue valueElement = yamlKeyValue.getValue();
            if (valueElement instanceof YAMLSequence || valueElement instanceof YAMLMapping) {
                return true;
            }
            String string2 = yamlKeyValue.getValueText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getValueText(...)");
            String valueText = string2;
            String string3 = ConfigYamlUtils.sanitizeNumberValueIfNeeded((String)valueText, () -> MnYamlConfigFileContributor.processConfigValues$lambda$1$lambda$0($params));
            if (string3 == null) {
                string3 = valueText;
            }
            String sanitizedValueText = string3;
            return $processor.process((Object)new MnConfigValueSearcher.MnConfigValueResult(keyElement, (PsiElement)valueElement, sanitizedValueText, $params));
        }
        return true;
    }
}

