/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.mongodb.json;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.persistence.mongodb.json.highlighting.MongoDBJsonSyntaxHighlighterFactoryKt;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonParameterLiteral;
import com.intellij.persistence.mongodb.json.psi.MongoDBJsonStringLiteral;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/micronaut/data/mongodb/json/MnDataMongoDbJsonQueryAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "parameterRegex", "Lkotlin/text/Regex;", "annotate", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "textRange", "isSuitableElement", "", "element", "intellij.micronaut"})
public final class MnDataMongoDbJsonQueryAnnotator
implements Annotator {
    @NotNull
    private final Regex parameterRegex = new Regex(":\\w+");

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.isBatchMode() || !this.isSuitableElement(psiElement) || !psiElement.textContains(':')) {
            return;
        }
        TextRange textRange = this.getTextRange(psiElement);
        if (textRange == null) {
            return;
        }
        TextRange textRange2 = textRange;
        this.annotate(textRange2, holder);
    }

    private final TextRange getTextRange(PsiElement psiElement) {
        Object object;
        PsiElement psiElement2 = psiElement;
        if (psiElement2 instanceof MongoDBJsonParameterLiteral) {
            object = ((MongoDBJsonParameterLiteral)psiElement).getTextRange();
        } else if (psiElement2 instanceof MongoDBJsonStringLiteral) {
            String string = ((MongoDBJsonStringLiteral)psiElement).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            object = this.parameterRegex.matches((CharSequence)string) ? new TextRange(((MongoDBJsonStringLiteral)psiElement).getTextRange().getStartOffset() + 1, ((MongoDBJsonStringLiteral)psiElement).getTextRange().getEndOffset() - 1) : null;
        } else {
            object = null;
        }
        return object;
    }

    private final void annotate(TextRange textRange, AnnotationHolder holder) {
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(textRange).textAttributes(MongoDBJsonSyntaxHighlighterFactoryKt.getMONGODB_JSON_PARAMETER()).create();
    }

    private final boolean isSuitableElement(PsiElement element) {
        return element instanceof MongoDBJsonStringLiteral || element instanceof MongoDBJsonParameterLiteral;
    }
}

