/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.events;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.jvm.JvmClassKind;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.events.EventSubscription;
import com.intellij.micronaut.events.PublishEventPoint;
import com.intellij.micronaut.jam.beans.MnEventListener;
import com.intellij.micronaut.jam.beans.MnTransactionalEventListener;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.semantic.SemService;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a#\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001b\u001a&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0002\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\"\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"getEventPublishPoints", "", "Lcom/intellij/micronaut/events/PublishEventPoint;", "module", "Lcom/intellij/openapi/module/Module;", "eventType", "Lcom/intellij/psi/PsiType;", "getEventListeners", "Lcom/intellij/micronaut/events/EventSubscription;", "APPLICATION_EVENT_PUBLISH_EVENT_METHOD_NAME", "", "", "isPublishEventExpression", "", "uMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "isEventListenerMethod", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "isEventClass", "psiClass", "Lcom/intellij/psi/PsiClass;", "hasSuperClassEventListener", "getPublishMethods", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/psi/PsiMethod;", "fillPublishPoints", "", "publishMethod", "collector", "", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnEventUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnEventUtils.kt\ncom/intellij/micronaut/events/MnEventUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,159:1\n774#2:160\n865#2,2:161\n774#2:163\n865#2,2:164\n207#3:166\n*S KotlinDebug\n*F\n+ 1 MnEventUtils.kt\ncom/intellij/micronaut/events/MnEventUtilsKt\n*L\n26#1:160\n26#1:161,2\n33#1:163\n33#1:164,2\n113#1:166\n*E\n"})
public final class MnEventUtilsKt {
    @NotNull
    private static final List<String> APPLICATION_EVENT_PUBLISH_EVENT_METHOD_NAME = CollectionsKt.listOf((Object)"publishEvent");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<PublishEventPoint> getEventPublishPoints(@NotNull Module module, @NotNull PsiType eventType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Iterable $this$filter$iv = MnEventUtilsKt.getEventPublishPoints(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PublishEventPoint p = (PublishEventPoint)element$iv$iv;
            boolean bl = false;
            PsiType pointType = p.getEventType();
            if (!(pointType != null && eventType.isAssignableFrom(pointType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<EventSubscription> getEventListeners(@NotNull Module module, @NotNull PsiType eventType) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Iterable $this$filter$iv = MnEventUtilsKt.getEventListeners(module);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            EventSubscription l = (EventSubscription)element$iv$iv;
            boolean bl = false;
            PsiType handlerType = l.getEventType();
            if (!(handlerType != null && eventType.isAssignableFrom(handlerType))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isPublishEventExpression(@NotNull UCallExpression uMethodCall) {
        PsiMethod psiMethod;
        Intrinsics.checkNotNullParameter((Object)uMethodCall, (String)"uMethodCall");
        if (uMethodCall.isMethodNameOneOf((Collection)APPLICATION_EVENT_PUBLISH_EVENT_METHOD_NAME) && (psiMethod = uMethodCall.resolve()) != null) {
            PsiClass targetClass = psiMethod.getContainingClass();
            return targetClass != null && InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"io.micronaut.context.event.ApplicationEventPublisher");
        }
        return false;
    }

    public static final boolean isEventListenerMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        if (psiMethod.getParameterList().getParametersCount() == 1 && psiMethod.getParameterList().getParameters()[0].getType() instanceof PsiClassType) {
            PsiClass containingClass;
            MnEventListener mnListener = (MnEventListener)SemService.getSemService((Project)psiMethod.getProject()).getSemElement(MnEventListener.LISTENER_JAM_KEY, (PsiElement)psiMethod);
            if (mnListener != null && !psiMethod.hasModifier(JvmModifier.PRIVATE)) {
                return true;
            }
            if (Intrinsics.areEqual((Object)psiMethod.getName(), (Object)"onApplicationEvent") && (containingClass = psiMethod.getContainingClass()) != null && MnEventUtilsKt.hasSuperClassEventListener(containingClass)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isEventClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return psiClass.getClassKind() == JvmClassKind.CLASS && !psiClass.hasModifier(JvmModifier.ABSTRACT) && InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"io.micronaut.context.event.ApplicationEvent");
    }

    private static final boolean hasSuperClassEventListener(PsiClass psiClass) {
        return psiClass.getQualifiedName() != null && InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"io.micronaut.context.event.ApplicationEventListener");
    }

    private static final Collection<PublishEventPoint> getEventPublishPoints(Module module) {
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)module.getProject());
        Object object = cacheManager.getCachedValue((UserDataHolder)module, () -> MnEventUtilsKt.getEventPublishPoints$lambda$2(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Collection)object;
    }

    private static final PsiMethod[] getPublishMethods(Module module, GlobalSearchScope scope) {
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        PsiClass psiClass = javaPsiFacade.findClass("io.micronaut.context.event.ApplicationEventPublisher", scope);
        if (psiClass == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiMethod.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiMethod.EMPTY_ARRAY;
        }
        PsiClass publisherClass = psiClass;
        PsiMethod[] psiMethodArray = publisherClass.findMethodsByName("publishEvent", false);
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findMethodsByName(...)");
        return psiMethodArray;
    }

    private static final void fillPublishPoints(PsiMethod publishMethod, GlobalSearchScope scope, List<PublishEventPoint> collector) {
        Query query = MethodReferencesSearch.search((PsiMethod)publishMethod, (SearchScope)((SearchScope)scope), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
        Query entries = query;
        Iterator iterator = entries.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            PsiReference reference = (PsiReference)iterator2.next();
            PsiElement $this$getUastParentOfType_u24default$iv = reference.getElement();
            boolean strict$iv = false;
            boolean $i$f$getUastParentOfType = false;
            UCallExpression expression = (UCallExpression)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UCallExpression.class, (boolean)strict$iv);
            if (expression == null || expression.getValueArgumentCount() != 1) continue;
            UExpression arg = (UExpression)expression.getValueArguments().get(0);
            collector.add(new PublishEventPoint(arg));
        }
    }

    private static final Collection<EventSubscription> getEventListeners(Module module) {
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> MnEventUtilsKt.getEventListeners$lambda$3(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Collection)object;
    }

    private static final CachedValueProvider.Result getEventPublishPoints$lambda$2(Module $module) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)$module);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        SmartList points = new SmartList();
        for (PsiMethod publishMethod : MnEventUtilsKt.getPublishMethods($module, scope)) {
            MnEventUtilsKt.fillPublishPoints(publishMethod, scope, (List)points);
        }
        Object[] objectArray = new Object[1];
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = UastModificationTracker.Companion.getInstance(project);
        return CachedValueProvider.Result.create((Object)points, (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getEventListeners$lambda$3(Module $module) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)$module);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"moduleWithDependenciesAndLibrariesScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        JamService jamService = JamService.getJamService((Project)$module.getProject());
        List list = ContainerUtil.concat((List)jamService.getJamMethodElements((JamMemberMeta)MnEventListener.META, "io.micronaut.runtime.event.annotation.EventListener", scope), (List)jamService.getJamMethodElements((JamMemberMeta)MnTransactionalEventListener.META, "io.micronaut.transaction.annotation.TransactionalEventListener", scope));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"concat(...)");
        List listenerElements = list;
        ArrayList<EventSubscription> listeners = new ArrayList<EventSubscription>(listenerElements.size());
        for (MnEventListener element : listenerElements) {
            PsiElement psiElement = element.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
            listeners.add(new EventSubscription((PsiMethod)psiElement));
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)$module.getProject());
        PsiClass listenerInterface = javaPsiFacade.findClass("io.micronaut.context.event.ApplicationEventListener", scope);
        if (listenerInterface != null) {
            Query query = ClassInheritorsSearch.search((PsiClass)listenerInterface, (SearchScope)((SearchScope)scope), (boolean)true, (boolean)true, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)query, (String)"search(...)");
            Query entries = query;
            Iterator iterator = entries.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                PsiMethod[] onEventMethods;
                PsiClass entry = (PsiClass)iterator2.next();
                if (!MicronautBeanUtilsKt.isBeanMappedClass(entry)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)entry.findMethodsByName("onApplicationEvent", false), (String)"findMethodsByName(...)");
                for (PsiMethod method : onEventMethods) {
                    if (method.getParameterList().getParametersCount() != 1 || !(method.getParameters()[0].getType() instanceof PsiClassType)) continue;
                    Intrinsics.checkNotNull((Object)method);
                    listeners.add(new EventSubscription(method));
                }
            }
        }
        Object[] objectArray = new Object[2];
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = UastModificationTracker.Companion.getInstance(project);
        objectArray[1] = JavaLibraryModificationTracker.getInstance((Project)$module.getProject());
        return CachedValueProvider.Result.create(listeners, (Object[])objectArray);
    }
}

