/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.highlighting.beans;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnBeansModel;
import com.intellij.micronaut.jam.beans.MnInjectionPoint;
import com.intellij.micronaut.provider.beans.MicronautBeanUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0013J-\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/intellij/micronaut/highlighting/beans/MnInjectionPointsInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkField", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uField", "Lorg/jetbrains/uast/UField;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lorg/jetbrains/uast/UField;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkInjectionPoint", "", "uVariable", "Lorg/jetbrains/uast/UVariable;", "problemsHolder", "ignoreInjectionPoint", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnInjectionPointsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnInjectionPointsInspection.kt\ncom/intellij/micronaut/highlighting/beans/MnInjectionPointsInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n2632#2,3:79\n*S KotlinDebug\n*F\n+ 1 MnInjectionPointsInspection.kt\ncom/intellij/micronaut/highlighting/beans/MnInjectionPointsInspection\n*L\n62#1:79,3\n*E\n"})
public final class MnInjectionPointsInspection
extends AbstractBaseUastLocalInspectionTool {
    public MnInjectionPointsInspection() {
        Class[] classArray = new Class[]{UDeclaration.class};
        super(classArray);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null || !MicronautUtils.hasMicronautLibrary(module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly, session);
        Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"buildVisitor(...)");
        return psiElementVisitor;
    }

    @Nullable
    public ProblemDescriptor[] checkField(@NotNull UField uField, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(uField instanceof UFieldEx) || !MicronautBeanUtilsKt.isInjectionPoint((UFieldEx)uField)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement psiElement = uField.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement containingFile = psiElement;
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)containingFile, isOnTheFly);
        this.checkInjectionPoint((UVariable)uField, holder);
        return holder.getResultsArray();
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod uMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        PsiElement psiElement = uMethod.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        PsiElement containingFile = psiElement;
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)containingFile, isOnTheFly);
        for (UParameter uParameter : uMethod.getUastParameters()) {
            if (!MicronautBeanUtilsKt.isInjectionPoint(uParameter)) continue;
            this.checkInjectionPoint((UVariable)uParameter, holder);
        }
        return holder.getResultsArray();
    }

    private final void checkInjectionPoint(UVariable uVariable, ProblemsHolder problemsHolder) {
        if (this.ignoreInjectionPoint(uVariable)) {
            return;
        }
        PsiElement psiElement = uVariable.getJavaPsi();
        PsiModifierListOwner psiModifierListOwner = psiElement instanceof PsiModifierListOwner ? (PsiModifierListOwner)psiElement : null;
        if (psiModifierListOwner == null) {
            return;
        }
        PsiModifierListOwner psiModifierListOwner2 = psiModifierListOwner;
        PsiElement psiElement2 = UElementKt.getSourcePsiElement((UElement)uVariable.getUastAnchor());
        if (psiElement2 == null) {
            return;
        }
        PsiElement identifier = psiElement2;
        Collection<MnBeanDefinition> collection = MnBeansModel.findAutowiredDependencies(new MnInjectionPoint(psiModifierListOwner2));
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findAutowiredDependencies(...)");
        Collection<MnBeanDefinition> injectionCandidates = collection;
        if (injectionCandidates.isEmpty()) {
            problemsHolder.registerProblem(identifier, MicronautBundle.message("micronaut.inspection.beans.unsatisfied.dependency", new Object[0]), new LocalQuickFix[0]);
        } else if (injectionCandidates.size() > 1) {
            boolean bl;
            block10: {
                Iterable $this$none$iv = injectionCandidates;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        MnBeanDefinition it = (MnBeanDefinition)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!MicronautBeanUtilsKt.hasBeanRequirements(it)) continue;
                        bl = false;
                        break block10;
                    }
                    bl = true;
                }
            }
            if (bl) {
                problemsHolder.registerProblem(identifier, MicronautBundle.message("micronaut.inspection.beans.ambiguous.dependency", new Object[0]), new LocalQuickFix[0]);
            }
        }
    }

    private final boolean ignoreInjectionPoint(UVariable uVariable) {
        boolean bl;
        if (uVariable.findAnnotation("io.micronaut.context.annotation.Value") != null || uVariable.findAnnotation("io.micronaut.context.annotation.Parameter") != null) {
            return true;
        }
        PsiType ipPsiType = uVariable.getType();
        if (ipPsiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)ipPsiType).resolve();
            bl = Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"io.micronaut.context.event.ApplicationEventPublisher");
        } else {
            bl = false;
        }
        return bl;
    }
}

