/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.base;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.utils.MnLineMarkerBuilder;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\nH\u0014J&\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J&\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014J:\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\b\b\u0001\u0010\"\u001a\u00020#2\u0010\b\u0002\u0010$\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010%H\u0004\u00a8\u0006&"}, d2={"Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerProvider;", "<init>", "()V", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "element", "annotateClass", "uClass", "Lorg/jetbrains/uast/UClass;", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "annotateMethodParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "annotateField", "uField", "Lorg/jetbrains/uast/UFieldEx;", "annotateMethodCall", "uMethodCall", "Lorg/jetbrains/uast/UCallExpression;", "marker", "identifier", "icon", "Ljavax/swing/Icon;", "tooltipText", "", "navigationHandler", "Lcom/intellij/codeInsight/daemon/GutterIconNavigationHandler;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnLineMarkerProvider.kt\ncom/intellij/micronaut/provider/base/MnLineMarkerProvider\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,66:1\n171#2:67\n*S KotlinDebug\n*F\n+ 1 MnLineMarkerProvider.kt\ncom/intellij/micronaut/provider/base/MnLineMarkerProvider\n*L\n37#1:67\n*E\n"})
public abstract class MnLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement first = psiElement;
        Project project = first.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        boolean isDumb = DumbService.Companion.isDumb(project);
        Module module = DumbAwareLineMarkerUtilsKt.findModuleForElement((PsiElement)first, (boolean)isDumb);
        if (module == null) {
            return;
        }
        Module module2 = module;
        if (!MicronautUtils.hasMicronautLibrary(module2)) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        UElement uParent = UastUtils.getUParentForIdentifier((PsiElement)element);
        if (uParent instanceof UClass) {
            this.annotateClass((UClass)uParent, result);
        } else if (uParent instanceof UMethod) {
            this.annotateMethod((UMethod)uParent, result);
        } else if (uParent instanceof UParameter) {
            if (((UParameter)uParent).getUastParent() instanceof UMethod) {
                this.annotateMethodParameter((UParameter)uParent, result);
            }
        } else if (uParent instanceof UFieldEx) {
            this.annotateField((UFieldEx)uParent, result);
        } else {
            UCallExpression uCallExpression;
            PsiElement $this$toUElementOfType$iv = element;
            boolean $i$f$toUElementOfType = false;
            UCallExpression uCallExpression2 = uCallExpression = (UCallExpression)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UCallExpression.class);
            if (Intrinsics.areEqual((Object)(uCallExpression2 != null ? uCallExpression2.getKind() : null), (Object)UastCallKind.METHOD_CALL)) {
                this.annotateMethodCall(uCallExpression, result);
            }
        }
    }

    protected void annotateClass(@NotNull UClass uClass, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateMethodParameter(@NotNull UParameter uParameter, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateField(@NotNull UFieldEx uField, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    protected void annotateMethodCall(@NotNull UCallExpression uMethodCall, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethodCall, (String)"uMethodCall");
        Intrinsics.checkNotNullParameter(result, (String)"result");
    }

    @NotNull
    protected final RelatedItemLineMarkerInfo<PsiElement> marker(@NotNull PsiElement identifier, @NotNull Icon icon, @NlsContexts.Tooltip @NotNull String tooltipText, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)tooltipText, (String)"tooltipText");
        RelatedItemLineMarkerInfo relatedItemLineMarkerInfo = MnLineMarkerBuilder.create(icon).setTooltipText(tooltipText).setTargets((Collection)CollectionsKt.emptyList()).createLineMarkerInfo(identifier, navigationHandler);
        Intrinsics.checkNotNullExpressionValue((Object)relatedItemLineMarkerInfo, (String)"createLineMarkerInfo(...)");
        return relatedItemLineMarkerInfo;
    }

    public static /* synthetic */ RelatedItemLineMarkerInfo marker$default(MnLineMarkerProvider mnLineMarkerProvider, PsiElement psiElement, Icon icon, String string, GutterIconNavigationHandler gutterIconNavigationHandler, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: marker");
        }
        if ((n & 8) != 0) {
            gutterIconNavigationHandler = null;
        }
        return mnLineMarkerProvider.marker(psiElement, icon, string, (GutterIconNavigationHandler<PsiElement>)gutterIconNavigationHandler);
    }
}

