/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.beans;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.jam.beans.JamPsiMemberMicronautBean;
import com.intellij.micronaut.jam.beans.JamPsiMethodMicronautBean;
import com.intellij.micronaut.jam.beans.MnBeanDefinition;
import com.intellij.micronaut.jam.beans.MnBeansConstants;
import com.intellij.micronaut.jam.beans.MnFactory;
import com.intellij.micronaut.jam.beans.MnFactoryMethodBean;
import com.intellij.micronaut.jam.beans.MnFieldBean;
import com.intellij.micronaut.jam.beans.MnInject;
import com.intellij.micronaut.jam.beans.MnValue;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.patterns.uast.UExpressionPattern;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFieldEx;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0012\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0012\u0010\u0004\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0018\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0012\u0010\u0007\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u001a\u0016\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0000\u001a\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a-\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020#0\"0!2\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020&\u0012\u0002\b\u00030%H\u0000\u00a2\u0006\u0002\u0010'\u001a-\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020#0\"0!2\u0010\u0010$\u001a\f\u0012\u0004\u0012\u00020&\u0012\u0002\b\u00030%H\u0000\u00a2\u0006\u0002\u0010'\u001a\u0010\u0010)\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0000\u001a\u0010\u0010,\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0000\u001a\u0010\u0010-\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0000\u001a\u0010\u0010.\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0010\u0010/\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0010\u00100\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0010\u00101\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0014H\u0002\u001a\u0010\u00103\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0014H\u0002\u001a\u0010\u00104\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0002\u001a\u0010\u00105\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u0014H\u0002\u001a\u0010\u00106\u001a\u00020\u00012\u0006\u0010*\u001a\u00020+H\u0002\u001a\u001e\u00107\u001a\u00020\u00012\u0006\u0010*\u001a\u00020\u00142\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09H\u0002\u001a\u0010\u0010;\u001a\u00020\u00012\u0006\u00102\u001a\u00020\u0014H\u0002\u001a\u0010\u0010<\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\u001bH\u0002\u00a8\u0006>"}, d2={"isBeanCandidateClass", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "isBeanMappedClass", "getBeanMapping", "Lcom/intellij/micronaut/jam/beans/JamPsiMemberMicronautBean;", "isMicronautTest", "isInjectionPoint", "uParameter", "Lorg/jetbrains/uast/UParameter;", "uField", "Lorg/jetbrains/uast/UFieldEx;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "isFactoryClass", "containingClass", "getMethodBeanJam", "Lcom/intellij/micronaut/jam/beans/JamPsiMethodMicronautBean;", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "getFieldBeanJam", "Lcom/intellij/micronaut/jam/beans/MnFieldBean;", "psiField", "Lcom/intellij/psi/PsiField;", "getPsiMemberBeanJam", "psiMember", "Lcom/intellij/psi/PsiMember;", "hasBeanRequirements", "beanDefinition", "Lcom/intellij/micronaut/jam/beans/MnBeanDefinition;", "isStereotypeComponentOrMeta", "getBeansPropertyPatterns", "", "Lcom/intellij/patterns/ElementPattern;", "Lorg/jetbrains/uast/UElement;", "injection", "Lcom/intellij/patterns/uast/UExpressionPattern;", "Lorg/jetbrains/uast/UExpression;", "(Lcom/intellij/patterns/uast/UExpressionPattern;)[Lcom/intellij/patterns/ElementPattern;", "getRetryPropertyPatterns", "hasBeansImplicitRead", "element", "Lcom/intellij/psi/PsiElement;", "hasBeansImplicitWrite", "hasBeansImplicitUsage", "isImplicitMethodUsage", "isScheduledMethod", "hasWriteAnnotation", "isLifeCycleMethod", "method", "isEventListenerAnnotatedMethod", "isEventListenerParameter", "isFactoryBeanMethod", "isFieldBeanDeclaration", "isAnnotatedBeanMethod", "annotations", "", "", "isConfigSetterMethod", "isDeclaredInConfigPropertiesBean", "member", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMicronautBeanUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MicronautBeanUtils.kt\ncom/intellij/micronaut/provider/beans/MicronautBeanUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,364:1\n1755#2,3:365\n12574#3,2:368\n12574#3,2:370\n12574#3,2:373\n1#4:372\n*S KotlinDebug\n*F\n+ 1 MicronautBeanUtils.kt\ncom/intellij/micronaut/provider/beans/MicronautBeanUtilsKt\n*L\n138#1:365,3\n225#1:368,2\n227#1:370,2\n353#1:373,2\n*E\n"})
public final class MicronautBeanUtilsKt {
    @Contract(value="null->false")
    public static final boolean isBeanCandidateClass(@Nullable PsiClass psiClass) {
        return psiClass != null && !(psiClass instanceof PsiTypeParameter) && !psiClass.hasModifierProperty("private") && !psiClass.isAnnotationType() && !psiClass.isEnum() && psiClass.getQualifiedName() != null && !PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass);
    }

    @Contract(value="null->false")
    public static final boolean isBeanMappedClass(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass)) {
            return false;
        }
        Project project = psiClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!MicronautUtils.hasMicronautLibrary(project)) {
            return false;
        }
        return MicronautBeanUtilsKt.isStereotypeComponentOrMeta(psiClass);
    }

    @Nullable
    public static final JamPsiMemberMicronautBean<?> getBeanMapping(@Nullable PsiClass psiClass) {
        if (psiClass == null || !MicronautBeanUtilsKt.isBeanCandidateClass(psiClass)) {
            return null;
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        return (JamPsiMemberMicronautBean)jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiClass);
    }

    @Contract(value="null->false")
    public static final boolean isMicronautTest(@Nullable PsiClass psiClass) {
        PsiClass psiClass2 = psiClass;
        return psiClass2 != null ? psiClass2.hasAnnotation("io.micronaut.test.extensions.junit5.annotation.MicronautTest") : false;
    }

    public static final boolean isInjectionPoint(@NotNull UParameter uParameter) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        UElement uElement = uParameter.getUastParent();
        if (uElement == null) {
            return false;
        }
        UElement parent = uElement;
        if (!(parent instanceof UMethod)) {
            return false;
        }
        PsiElement psiParameter = uParameter.getJavaPsi();
        if (!(psiParameter instanceof PsiParameter)) {
            return false;
        }
        PsiMethod psiMethod = ((UMethod)parent).getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass == null || psiMethod.hasModifierProperty("static") || psiMethod.hasModifierProperty("abstract") || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass) && !MicronautBeanUtilsKt.isMicronautTest(containingClass) || ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)containingClass)) == null) {
            return false;
        }
        return psiMethod.isConstructor() || MnInject.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod) != null || MnValue.PARAMETER_META.getJamElement((PsiModifierListOwner)psiParameter) != null || MicronautBeanUtilsKt.getMethodBeanJam(psiMethod) != null && MicronautBeanUtilsKt.isFactoryClass(containingClass);
    }

    public static final boolean isInjectionPoint(@NotNull UFieldEx uField) {
        Intrinsics.checkNotNullParameter((Object)uField, (String)"uField");
        PsiField psiField = uField.getJavaPsi();
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass == null || !MicronautBeanUtilsKt.isBeanMappedClass(containingClass) && !MicronautBeanUtilsKt.isMicronautTest(containingClass) || ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiField)) == null) {
            return false;
        }
        return MnInject.FIELD_META.getJamElement((PsiModifierListOwner)psiField) != null || MnValue.FIELD_META.getJamElement((PsiModifierListOwner)psiField) != null;
    }

    public static final boolean isInjectionPoint(@NotNull UMethod uMethod) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass containingClass = psiMethod.getContainingClass();
        if (!MicronautBeanUtilsKt.isBeanMappedClass(containingClass) && !MicronautBeanUtilsKt.isMicronautTest(containingClass) || ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)psiMethod)) == null) {
            return false;
        }
        return MnInject.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod) != null || MnValue.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod) != null;
    }

    public static final boolean isFactoryClass(@NotNull PsiClass containingClass) {
        Intrinsics.checkNotNullParameter((Object)containingClass, (String)"containingClass");
        return MnFactory.META.getJamElement((PsiModifierListOwner)containingClass) != null;
    }

    @Nullable
    public static final JamPsiMethodMicronautBean getMethodBeanJam(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkNotNullParameter((Object)psiMethod, (String)"psiMethod");
        JamPsiMemberMicronautBean<?> beanJam = MicronautBeanUtilsKt.getPsiMemberBeanJam((PsiMember)psiMethod);
        return beanJam instanceof JamPsiMethodMicronautBean ? (JamPsiMethodMicronautBean)beanJam : null;
    }

    @Nullable
    public static final MnFieldBean getFieldBeanJam(@NotNull PsiField psiField) {
        Intrinsics.checkNotNullParameter((Object)psiField, (String)"psiField");
        JamPsiMemberMicronautBean<?> jamPsiMemberMicronautBean = MicronautBeanUtilsKt.getPsiMemberBeanJam((PsiMember)psiField);
        return jamPsiMemberMicronautBean instanceof MnFieldBean ? (MnFieldBean)jamPsiMemberMicronautBean : null;
    }

    private static final JamPsiMemberMicronautBean<?> getPsiMemberBeanJam(PsiMember psiMember) {
        JamService jamService = JamService.getJamService((Project)psiMember.getProject());
        return (JamPsiMemberMicronautBean)jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiMember);
    }

    public static final boolean hasBeanRequirements(@NotNull MnBeanDefinition beanDefinition) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)beanDefinition, (String)"beanDefinition");
            UAnnotated uAnnotated = (UAnnotated)UastContextKt.toUElement((PsiElement)beanDefinition.getDefiningPsiElement(), UAnnotated.class);
            if (uAnnotated == null) {
                return false;
            }
            UAnnotated uBeanDefinition = uAnnotated;
            Iterable $this$any$iv = uBeanDefinition.getUAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UAnnotation uAnno = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)uAnno.getQualifiedName(), (Object)"io.micronaut.context.annotation.Requires") || Intrinsics.areEqual((Object)uAnno.getQualifiedName(), (Object)"io.micronaut.context.annotation.Requirements"))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isStereotypeComponentOrMeta(PsiClass psiClass) {
        if (!MicronautBeanUtilsKt.isBeanCandidateClass(psiClass)) {
            return false;
        }
        JamService jamService = JamService.getJamService((Project)psiClass.getProject());
        return jamService.getJamElement(JamPsiMemberMicronautBean.PSI_MEMBER_BEAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getBeansPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[3];
        elementPatternArray[0] = injection.annotationParam("io.micronaut.context.annotation.Value", "value");
        String[] stringArray = new String[]{"value", "defaultValue", "pattern"};
        StringPattern stringPattern = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"oneOf(...)");
        elementPatternArray[1] = injection.annotationParams("io.micronaut.context.annotation.Requires", (ElementPattern)stringPattern);
        stringArray = new String[]{"cron", "fixedDelay", "initialDelay", "fixedRate"};
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"oneOf(...)");
        elementPatternArray[2] = injection.annotationParams("io.micronaut.scheduling.annotation.Scheduled", (ElementPattern)stringPattern2);
        return elementPatternArray;
    }

    @NotNull
    public static final ElementPattern<? extends UElement>[] getRetryPropertyPatterns(@NotNull UExpressionPattern<UExpression, ?> injection) {
        Intrinsics.checkNotNullParameter(injection, (String)"injection");
        ElementPattern[] elementPatternArray = new ElementPattern[2];
        String[] stringArray = new String[]{"attempts", "delay", "maxDelay", "multiplier"};
        StringPattern stringPattern = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern, (String)"oneOf(...)");
        elementPatternArray[0] = injection.annotationParams("io.micronaut.retry.annotation.Retryable", (ElementPattern)stringPattern);
        stringArray = new String[]{"attempts", "delay", "maxDelay", "multiplier", "reset"};
        StringPattern stringPattern2 = StandardPatterns.string().oneOf(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringPattern2, (String)"oneOf(...)");
        elementPatternArray[1] = injection.annotationParams("io.micronaut.retry.annotation.CircuitBreaker", (ElementPattern)stringPattern2);
        return elementPatternArray;
    }

    public static final boolean hasBeansImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof PsiMethod && MicronautBeanUtilsKt.isFactoryBeanMethod((PsiMethod)element);
    }

    public static final boolean hasBeansImplicitWrite(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (MicronautBeanUtilsKt.hasWriteAnnotation(element)) {
            return true;
        }
        return element instanceof PsiMethod && !((PsiMethod)element).hasModifier(JvmModifier.STATIC) && (MicronautBeanUtilsKt.isLifeCycleMethod((PsiMethod)element) || MicronautBeanUtilsKt.isEventListenerAnnotatedMethod((PsiMethod)element));
    }

    public static final boolean hasBeansImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (MicronautBeanUtilsKt.hasWriteAnnotation(element)) {
            return true;
        }
        if (element instanceof PsiClass && MicronautBeanUtilsKt.isBeanMappedClass((PsiClass)element)) {
            boolean bl;
            block13: {
                boolean bl2;
                PsiElement p0;
                boolean $i$f$any;
                Object[] $this$any$iv;
                block12: {
                    if (((PsiClass)element).isInterface() || ((PsiClass)element).isEnum() || PsiUtil.isLocalOrAnonymousClass((PsiClass)((PsiClass)element))) {
                        return false;
                    }
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                    if (module != null && !MicronautUtils.hasMicronautLibrary(module)) {
                        return false;
                    }
                    for (PsiClass superClass : ((PsiClass)element).getSupers()) {
                        if (superClass == null || Intrinsics.areEqual((Object)"java.lang.Record", (Object)superClass.getQualifiedName()) || Intrinsics.areEqual((Object)"java.lang.Object", (Object)superClass.getQualifiedName())) continue;
                        return true;
                    }
                    if (MnFactory.META.getJamElement((PsiModifierListOwner)element) != null) {
                        return true;
                    }
                    PsiClass[] psiClassArray = ((PsiClass)element).getAllMethods();
                    int n = psiClassArray.length;
                    for (int i = 0; i < n; ++i) {
                        PsiClass psiMethod = psiClassArray[i];
                        if (psiMethod.isConstructor() || psiMethod.hasModifier(JvmModifier.ABSTRACT) || psiMethod.hasModifier(JvmModifier.STATIC)) continue;
                        Intrinsics.checkNotNull((Object)psiMethod);
                        if (!MicronautBeanUtilsKt.isEventListenerAnnotatedMethod((PsiMethod)psiMethod) && !MicronautBeanUtilsKt.isScheduledMethod((PsiMethod)psiMethod)) continue;
                        return true;
                    }
                    PsiMethod[] psiMethodArray = ((PsiClass)element).getMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"getMethods(...)");
                    $this$any$iv = psiMethodArray;
                    $i$f$any = false;
                    for (Object element$iv : $this$any$iv) {
                        p0 = (PsiElement)element$iv;
                        boolean $i$f$hasBeansImplicitUsage$stub_for_inlining = false;
                        boolean bl3 = false;
                        if (!MicronautBeanUtilsKt.isImplicitMethodUsage(p0)) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
                if (bl2) {
                    return true;
                }
                PsiField[] psiFieldArray = ((PsiClass)element).getFields();
                Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                $this$any$iv = psiFieldArray;
                $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    p0 = (PsiElement)element$iv;
                    boolean $i$f$hasBeansImplicitUsage$stub_for_inlining$1 = false;
                    boolean bl4 = false;
                    if (!MicronautBeanUtilsKt.isFieldBeanDeclaration(p0)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
            return bl;
        }
        if (MicronautBeanUtilsKt.isImplicitMethodUsage(element)) {
            return true;
        }
        if (MicronautBeanUtilsKt.isFieldBeanDeclaration(element)) {
            return true;
        }
        return MicronautBeanUtilsKt.isEventListenerParameter(element);
    }

    private static final boolean isImplicitMethodUsage(PsiElement element) {
        if (element instanceof PsiMethod) {
            if (((PsiMethod)element).isConstructor()) {
                PsiClass containingClass = ((PsiMethod)element).getContainingClass();
                return MicronautBeanUtilsKt.isBeanMappedClass(containingClass);
            }
            if (!((PsiMethod)element).isConstructor() && !((PsiMethod)element).hasModifier(JvmModifier.STATIC) && !((PsiMethod)element).hasModifier(JvmModifier.ABSTRACT) && (MicronautBeanUtilsKt.isLifeCycleMethod((PsiMethod)element) || MicronautBeanUtilsKt.isEventListenerAnnotatedMethod((PsiMethod)element) || MicronautBeanUtilsKt.isFactoryBeanMethod((PsiMethod)element) || MicronautBeanUtilsKt.isConfigSetterMethod((PsiMethod)element))) {
                return true;
            }
        }
        return false;
    }

    private static final boolean isScheduledMethod(PsiMethod psiMethod) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiMethod), (String)"io.micronaut.scheduling.annotation.Scheduled", (int)0);
    }

    private static final boolean hasWriteAnnotation(PsiElement element) {
        block7: {
            block6: {
                if (!(element instanceof PsiModifierListOwner)) {
                    return false;
                }
                if (element instanceof PsiParameter || element instanceof PsiLocalVariable) {
                    return false;
                }
                PsiModifierList modifierList = ((PsiModifierListOwner)element).getModifierList();
                if (modifierList == null) break block6;
                PsiAnnotation[] psiAnnotationArray = modifierList.getAnnotations();
                Intrinsics.checkNotNullExpressionValue((Object)psiAnnotationArray, (String)"getAnnotations(...)");
                if (!(((Object[])psiAnnotationArray).length == 0)) break block7;
            }
            return false;
        }
        Project project = ((PsiModifierListOwner)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!MicronautUtils.hasMicronautLibrary(project)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)MnBeansConstants.getBEANS_IMPLICIT_WRITE_ANNOTATIONS(), (int)0);
    }

    private static final boolean isLifeCycleMethod(PsiMethod method) {
        int parametersCount = method.getParameterList().getParametersCount();
        if (parametersCount > 0) {
            return false;
        }
        return MicronautBeanUtilsKt.isAnnotatedBeanMethod(method, MnBeansConstants.getBEANS_EVENT_BASED_METHODS());
    }

    private static final boolean isEventListenerAnnotatedMethod(PsiMethod method) {
        int parametersCount = method.getParameterList().getParametersCount();
        if (parametersCount != 1) {
            return false;
        }
        return MicronautBeanUtilsKt.isAnnotatedBeanMethod(method, MnBeansConstants.getBEANS_LISTENER_ANNOTATIONS());
    }

    private static final boolean isEventListenerParameter(PsiElement element) {
        PsiElement parentMethod;
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiElement psiElement = ((PsiParameter)element).getParent();
        Object object = parentMethod = psiElement != null ? psiElement.getParent() : null;
        if (!(parentMethod instanceof PsiMethod)) {
            return false;
        }
        if (!MicronautBeanUtilsKt.isEventListenerAnnotatedMethod((PsiMethod)parentMethod)) {
            return false;
        }
        PsiTypeElement typeElement = ((PsiParameter)element).getTypeElement();
        return typeElement != null && typeElement.getType() instanceof PsiClassType;
    }

    private static final boolean isFactoryBeanMethod(PsiMethod element) {
        PsiType returnType = element.getReturnType();
        if (!(returnType instanceof PsiClassType) || element.hasModifier(JvmModifier.PRIVATE)) {
            return false;
        }
        JamService jamService = JamService.getJamService((Project)element.getProject());
        return jamService.getJamElement(MnFactoryMethodBean.FACTORY_BEAN_JAM_KEY, (PsiElement)element) != null;
    }

    private static final boolean isFieldBeanDeclaration(PsiElement element) {
        if (!(element instanceof PsiField)) {
            return false;
        }
        PsiType psiType = ((PsiField)element).getType();
        Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getType(...)");
        PsiType returnType = psiType;
        if (!(returnType instanceof PsiClassType) || ((PsiField)element).hasModifier(JvmModifier.PRIVATE)) {
            return false;
        }
        JamService jamService = JamService.getJamService((Project)((PsiField)element).getProject());
        return jamService.getJamElement(MnFieldBean.JAM_KEY, element) != null;
    }

    private static final boolean isAnnotatedBeanMethod(PsiMethod element, List<String> annotations) {
        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), (Collection)annotations, (int)0)) {
            return false;
        }
        return MicronautBeanUtilsKt.isBeanMappedClass(element.getContainingClass());
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean isConfigSetterMethod(PsiMethod method) {
        boolean bl;
        block6: {
            String string;
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string2, (String)"set", (boolean)false, (int)2, null)) {
                return false;
            }
            int parametersCount = method.getParameterList().getParametersCount();
            if (parametersCount != 1) {
                return false;
            }
            PsiClass psiClass = method.getContainingClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass containingClass = psiClass;
            String string3 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            String string4 = StringsKt.replaceFirst$default((String)string3, (String)"set", (String)"", (boolean)false, (int)4, null);
            if (((CharSequence)string4).length() > 0) {
                void it22;
                char c = string4.charAt(0);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl2 = false;
                String string5 = String.valueOf((char)it22);
                Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type java.lang.String");
                String string6 = string5.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
                StringBuilder stringBuilder2 = stringBuilder.append((Object)string6);
                String it22 = string4;
                int n = 1;
                String string7 = it22.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"substring(...)");
                string = stringBuilder2.append(string7).toString();
            } else {
                string = string4;
            }
            String fieldName = string;
            PsiField[] psiFieldArray = containingClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
            Object[] $this$any$iv = psiFieldArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiField it = (PsiField)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                bl = true;
                break block6;
            }
            bl = false;
        }
        return bl && MicronautBeanUtilsKt.isDeclaredInConfigPropertiesBean((PsiMember)method);
    }

    private static final boolean isDeclaredInConfigPropertiesBean(PsiMember member) {
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass containingClass = psiClass;
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)containingClass), (String)"io.micronaut.context.annotation.ConfigurationProperties", (int)0)) {
            return true;
        }
        PsiElement classParent = containingClass.getParent();
        return classParent instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)classParent), (String)"io.micronaut.context.annotation.ConfigurationProperties", (int)0);
    }
}

