/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.MicronautIcons;
import com.intellij.micronaut.jam.http.MnClient;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.MnHttpModel;
import com.intellij.micronaut.provider.http.MnHttpClientFramework;
import com.intellij.micronaut.provider.http.MnHttpUrlTargetInfo;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.micronaut.provider.url.MnUrlPathEscapeUtilsKt;
import com.intellij.microservices.endpoints.EndpointType;
import com.intellij.microservices.endpoints.EndpointTypes;
import com.intellij.microservices.endpoints.EndpointsFilter;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.endpoints.EndpointsUrlTargetProvider;
import com.intellij.microservices.endpoints.FrameworkPresentation;
import com.intellij.microservices.endpoints.ModuleEndpointsFilter;
import com.intellij.microservices.endpoints.presentation.HttpMethodPresentation;
import com.intellij.microservices.jvm.cache.SourceTestLibSearcher;
import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.uast.UastModificationTracker;
import icons.JavaUltimateIcons;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00152\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpClientFramework;", "Lcom/intellij/microservices/endpoints/EndpointsUrlTargetProvider;", "Lcom/intellij/micronaut/jam/http/MnClient;", "Lcom/intellij/micronaut/jam/http/MnHttpMappingInfo;", "<init>", "()V", "clientsSearcher", "Lcom/intellij/microservices/jvm/cache/SourceTestLibSearcher;", "endpointType", "Lcom/intellij/microservices/endpoints/EndpointType;", "getEndpointType", "()Lcom/intellij/microservices/endpoints/EndpointType;", "presentation", "Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getPresentation", "()Lcom/intellij/microservices/endpoints/FrameworkPresentation;", "getStatus", "Lcom/intellij/microservices/endpoints/EndpointsProvider$Status;", "project", "Lcom/intellij/openapi/project/Project;", "getEndpointGroups", "", "filter", "Lcom/intellij/microservices/endpoints/EndpointsFilter;", "getEndpoints", "group", "getEndpointPresentation", "Lcom/intellij/navigation/ItemPresentation;", "endpoint", "getDocumentationElement", "Lcom/intellij/psi/PsiElement;", "getUrlTargetInfo", "Lcom/intellij/microservices/url/UrlTargetInfo;", "isValidEndpoint", "", "getModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "intellij.micronaut"})
@SourceDebugExtension(value={"SMAP\nMnHttpClientFramework.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnHttpClientFramework.kt\ncom/intellij/micronaut/provider/http/MnHttpClientFramework\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,77:1\n1557#2:78\n1628#2,3:79\n1#3:82\n*S KotlinDebug\n*F\n+ 1 MnHttpClientFramework.kt\ncom/intellij/micronaut/provider/http/MnHttpClientFramework\n*L\n67#1:78\n67#1:79,3\n*E\n"})
public final class MnHttpClientFramework
implements EndpointsUrlTargetProvider<MnClient, MnHttpMappingInfo> {
    @NotNull
    private final SourceTestLibSearcher<MnClient> clientsSearcher = new SourceTestLibSearcher("MN_CLIENTS", (Function2)clientsSearcher.1.INSTANCE);
    @NotNull
    private final FrameworkPresentation presentation = new FrameworkPresentation("Micronaut-HTTP-Client", MicronautBundle.message("micronaut.http.client.framework.title", new Object[0]), MicronautIcons.MicronautLogo);

    @NotNull
    public EndpointType getEndpointType() {
        return EndpointTypes.HTTP_CLIENT_TYPE;
    }

    @NotNull
    public FrameworkPresentation getPresentation() {
        return this.presentation;
    }

    @NotNull
    public EndpointsProvider.Status getStatus(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return MnHttpUtils.hasHttpClientLibrary(project) ? EndpointsProvider.Status.AVAILABLE : EndpointsProvider.Status.UNAVAILABLE;
    }

    @NotNull
    public Iterable<MnClient> getEndpointGroups(@NotNull Project project, @NotNull EndpointsFilter filter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        if (!(filter instanceof ModuleEndpointsFilter)) {
            return CollectionsKt.emptyList();
        }
        if (!MnHttpUtils.hasHttpClientLibrary(((ModuleEndpointsFilter)filter).getModule())) {
            return CollectionsKt.emptyList();
        }
        return this.clientsSearcher.iterable(((ModuleEndpointsFilter)filter).getModule(), ((ModuleEndpointsFilter)filter).getFromTests(), ((ModuleEndpointsFilter)filter).getFromLibraries());
    }

    @NotNull
    public Iterable<MnHttpMappingInfo> getEndpoints(@NotNull MnClient group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        List<MnHttpMappingInfo> list = MnHttpModel.getHttpMethods((PsiClass)group.getPsiElement());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHttpMethods(...)");
        return list;
    }

    @NotNull
    public ItemPresentation getEndpointPresentation(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        String string = MnHttpUtils.getHttpResourcePath(endpoint);
        if (string == null) {
            string = "/";
        }
        return (ItemPresentation)new HttpMethodPresentation(string, endpoint.getMapping().getHttpMethod(), ((PsiClass)group.getPsiElement()).getName(), JavaUltimateIcons.Web.RequestMapping, (TextAttributesKey)(UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)endpoint.getMapping().getPsiElement()) ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null));
    }

    @NotNull
    public PsiElement getDocumentationElement(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        PsiElement psiElement = endpoint.getMapping().getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsiElement(...)");
        return psiElement;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public Iterable<UrlTargetInfo> getUrlTargetInfo(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        fullUrl = MnUrlPathEscapeUtilsKt.mnParseFullUrl(MnHttpUtils.getHttpResourcePath(endpoint));
        v0 = fullUrl;
        if (v0 == null || (v0 = v0.getUrlPath()) == null) {
            v0 = UrlPath.Companion.getEMPTY();
        }
        urlPath = v0;
        v1 = fullUrl;
        $this$map$iv = CollectionsKt.listOfNotNull(v1 != null && (v1 = v1.getAuthority()) != null ? v1.getValueIfKnown() : null);
        $i$f$map = false;
        var8_7 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var13_15 = (String)item$iv$iv;
            var15_17 = destination$iv$iv;
            $i$a$-map-MnHttpClientFramework$getUrlTargetInfo$authorities$1 = false;
            var15_17.add(new Authority.Exact((String)it));
        }
        authorities = (List)destination$iv$iv;
        v2 /* !! */  = fullUrl;
        if (v2 /* !! */  == null || (v2 /* !! */  = v2 /* !! */ .getScheme()) == null) ** GOTO lbl-1000
        it = $i$f$mapTo = v2 /* !! */ ;
        $i$a$-takeUnless-MnHttpClientFramework$getUrlTargetInfo$schemes$1 = false;
        v2 /* !! */  = it.getSegments().isEmpty() == false ? $i$f$mapTo : null;
        if (v2 /* !! */  != null) {
            v3 = v2 /* !! */ .getValueIfKnown();
        } else lbl-1000:
        // 2 sources

        {
            v3 = null;
        }
        it = var8_7 = CollectionsKt.listOfNotNull(v3);
        $i$a$-takeUnless-MnHttpClientFramework$getUrlTargetInfo$schemes$2 = false;
        v4 = it.isEmpty() == false ? var8_7 : null;
        if (v4 == null) {
            v4 = UrlConstants.HTTP_SCHEMES;
        }
        schemes = v4;
        return CollectionsKt.listOf((Object)new MnHttpUrlTargetInfo((List<String>)schemes, (UrlPath)urlPath, endpoint, authorities));
    }

    public boolean isValidEndpoint(@NotNull MnClient group, @NotNull MnHttpMappingInfo endpoint) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        return endpoint.isValid();
    }

    @NotNull
    public ModificationTracker getModificationTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (ModificationTracker)UastModificationTracker.Companion.getInstance(project);
    }
}

