/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.management;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.provider.base.MnLineMarkerProvider;
import com.intellij.micronaut.provider.management.MnManagementUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import icons.JavaUltimateIcons;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0012\u0010\t\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\t\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\nH\u0014\u00a8\u0006\u0015"}, d2={"Lcom/intellij/micronaut/provider/management/MnManagementLineMarkers;", "Lcom/intellij/micronaut/provider/base/MnLineMarkerProvider;", "<init>", "()V", "collectNavigationMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/RelatedItemLineMarkerInfo;", "forNavigation", "", "getIcon", "Ljavax/swing/Icon;", "getName", "", "annotateMethod", "uMethod", "Lorg/jetbrains/uast/UMethod;", "intellij.micronaut"})
public final class MnManagementLineMarkers
extends MnLineMarkerProvider {
    @Override
    public void collectNavigationMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result, boolean forNavigation) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(elements, (String)"elements");
                Intrinsics.checkNotNullParameter(result, (String)"result");
                PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
                if (psiElement == null) break block2;
                Project project = psiElement.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (MnManagementUtils.hasManagementLibrary(project)) break block3;
            }
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = JavaUltimateIcons.Cdi.Gutter.BeanInfrastructure;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"BeanInfrastructure");
        return icon;
    }

    @NotNull
    public String getName() {
        return MicronautBundle.message("micronaut.management.markers", new Object[0]);
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, @NotNull Collection<? super RelatedItemLineMarkerInfo<PsiElement>> result) {
        Intrinsics.checkNotNullParameter((Object)uMethod, (String)"uMethod");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uMethod.getUastAnchor());
        if (psiElement == null) {
            return;
        }
        PsiElement identifier = psiElement;
        PsiMethod psiMethod = uMethod.getJavaPsi();
        PsiClass psiClass = psiMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        if (MnManagementUtils.isMappedManagementMethod(psiMethod, containingClass)) {
            MnLineMarkerProvider mnLineMarkerProvider = this;
            Icon icon = JavaUltimateIcons.Web.Gutter.RequestMapping;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
            result.add((RelatedItemLineMarkerInfo<PsiElement>)MnLineMarkerProvider.marker$default(mnLineMarkerProvider, identifier, icon, MicronautBundle.message("micronaut.management.method.tooltip.text", new Object[0]), null, 8, null));
        }
    }
}

